{=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=}
{                         Z-100 SCREEN ROUTINES                             }
{=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=}
const
  on  = true;
  off = false;

var
  cadr, vram : integer;
  offadr     : integer;
  bmask      : byte;
  offrow     : array[0..224] of integer;
{=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=}
procedure initgraph;

  var
    i       : integer;

begin
  for i := 0 to 224 do
    offrow[i] := ((((i div 9) shl 4) + (i mod 9)) shl 7);
end;
{=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=}
procedure ingraph;

begin
  write(chr(27), 'x5', chr(27), 'x1');
  vram := 8;
  cadr := 27344 + 30000;
  port[216] := vram ;
end;
{=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=}
procedure outgraph;
  begin
    port[216] := 248 ;
    write(chr(27), 'y5', chr(27), 'y1')
  end;
{=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=}
procedure hline (x1,x2,y : integer;
                 onoff   : boolean);

var
  leftoffadr, rightoffadr : integer;
  leftbmask, rightbmask   : byte;
  xtemp : integer;

begin
  if x1>x2
    then begin
      xtemp := x1;
      x1 := x2;
      x2 := xtemp
    end;
  leftoffadr :=  offrow[y] + (x1 shr 3);
  leftbmask := (128 shr (x1 and 7));
  leftbmask := leftbmask or (leftbmask-1);
  rightoffadr :=  offrow[y] + (x2 shr 3);
  rightbmask := (128 shr (x2 and 7));
  rightbmask := not (rightbmask-1);
  if leftoffadr=rightoffadr
    then begin
      bmask := leftbmask and rightbmask;
      if onoff {is on}
        then mem[cadr:leftoffadr] := mem[cadr:leftoffadr] or bmask
        else mem[cadr:leftoffadr] := mem[cadr:leftoffadr] and not bmask
    end
    else begin
      if onoff {is on}
        then mem[cadr:leftoffadr] := mem[cadr:leftoffadr] or leftbmask
        else mem[cadr:leftoffadr] := mem[cadr:leftoffadr] and not leftbmask;
      leftoffadr := leftoffadr + 1;
      if onoff {is on}
        then mem[cadr:rightoffadr] := mem[cadr:rightoffadr] or rightbmask
        else mem[cadr:rightoffadr] := mem[cadr:rightoffadr] and not rightbmask;
      rightoffadr := rightoffadr - 1;
      for offadr := leftoffadr to rightoffadr do
        if onoff {is on}
          then mem[cadr:offadr] := $FF
          else mem[cadr:offadr] := $00
    end;
end;
{=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=}
procedure vline(x, y1, y2 : integer;
                onoff     : boolean);

var
  ytemp : integer;
  botoffadr : integer;

begin
  if y1>y2
    then begin
      ytemp := y1;
      y1 := y2;
      y2 :=ytemp
    end;
  bmask := (128 shr (x and 7));
  for ytemp := y1 to y2 do begin
    offadr := offrow[ytemp] + (x shr 3);
    if onoff {is on}
      then mem[cadr:offadr] := mem[cadr:offadr] or bmask
      else mem[cadr:offadr] := mem[cadr:offadr] and not bmask
  end
end;
{=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=}
procedure line (x1, y1, x2, y2 : integer;
                onoff          : boolean);
var
  x, y, r, dx, dy, xv, yv, xb, yb : integer;

begin
  ingraph;
  if y1=y2
    then hline(x1,x2,y1,onoff)
  else if x1 = x2
    then vline(x1,y1,y2,onoff)
  else begin
    r := 0;
    dx := abs(x2-x1);
    if x1>x2
      then xv := -1
      else xv := 1;
    dy := abs(y2-y1);
    if y1>y2
      then yv := -1
      else yv := 1;
    x := x1;
    y := y1;
    xb := x1;
    yb := y1;
    if dx>dy
      then begin
        while x<>x2 do begin
          x := x+xv;
          r := r+dy;
          if r>=(dx-r) then begin
            hline(xb,x,y,onoff);
            xb := x;
            y := y+yv;
            r := r-dx
          end
        end;
        hline(xb,x,y,onoff)
      end
      else begin
        while y<>y2 do begin
          y := y+yv;
          r := r+dx;
          if r>=(dy-r) then begin
            vline(x,yb,y,onoff);
            yb := y;
            x := x+xv;
            r := r-dy
          end
        end;
        vline(x,yb,y,onoff)
      end
  end;
  outgraph
end;
{=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=}
procedure box(x1, y1, x2, y2 : integer;
              onoff          : boolean);

begin
  ingraph;
  hline(x1, x2, y1, onoff);
  vline(x2, y1, y2, onoff);
  hline(x1, x2, y2, onoff);
  vline(x1, y1, y2, onoff);
  outgraph
end;
{=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=}
procedure textwindow(cx1, cy1, cx2, cy2 : integer);

var
  x1,y1,x2,y2 : integer;

begin
  x1 := (cx1-1)*8;
  y1 := (cy1-1)*9;
  x2 := (cx2-1)*8;
  y2 := (cy2-1)*9;
  box(x1-1,y1-1,x2+1,y2,on);
  end;
{=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=}
procedure showframe;

var
  x1,y1,
  x2,y2    : integer;
  dtb      : dt_block_type;

begin
  x1 := 21;
  y1 := 2;
  x2 := 59;
  y2 := 5;
  textwindow(x1,y1,x2,y2);
  gotoxy(x1+1,y1+1);
  write(logoline1);
  x1 := 35;
  y1 := 23;
  x2 := 45;
  y2 := 24;
  textwindow(x1,y1,x2,y2);
  gotoxy(x1,y1);
  date(dtb);
  write(' ');
  showdate(dtb)
end;
{=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=}
procedure hiliteitem(x, y : integer;
                     item : str80);

begin
  gotoxy(x,y);
  lowvideo;
  write(item);
  normvideo
end;
{=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=}
procedure unliteitem(x, y : integer;
                     item : str80);

begin
  gotoxy(x,y);
  normvideo;
  write(item)
end;
{=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=}
procedure cursoroff;

begin
  write(chr(27),'x5');
end; {cursoroff}
{=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=}
procedure cursoron;

begin
  write(chr(27),'y5');
end; {cursoron}
{=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=}
procedure protectstatus;

begin
  write(chr(27),'x1')
end;
{=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=}
procedure unprotectstatus;

begin
  write(chr(27),'y1')
end;
{=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=}
procedure beep;

begin
  write(^G)
end;
{=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=}
procedure at(Y, X : integer); { Personal preference -- Y before X }

begin
  gotoXY(X,Y)
end;
{=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=}
function wherex : integer; { Like IBM Turbo Pascal function }

const { See DEFMTR.ASM }
  mtr_d_seg_ptr = $3FE;  { Pointer (in segment 0) to monitor data segment }
  mtr_horp      = $0291; { Horizontal cursor position (zero relative) }

begin
  wherex := mem[memw[0:mtr_d_seg_ptr]:mtr_horp] + 1;
end;
{=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=}
function wherey : integer; { Like IBM Turbo Pascal function }

const { See DEFMTR.ASM }
  mtr_d_seg_ptr = $3FE;  { Pointer (in segment 0) to monitor data segment }
  mtr_verp      = $0292; { Vertical cursor position (zero relative) }

begin
  wherey := mem[memw[0:mtr_d_seg_ptr]:mtr_verp] + 1;
end;
{=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=}
function cursorpos : integer; { Stuffs cursor Y and X in integer }

begin
  cursorpos := (wherey shl 8) or wherex
end;
{=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=}
procedure setcursor(p : integer); { Sets cursor Y and X from integer }

begin
  gotoxy(p and $7F,p shr 8)
end;
{=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=}
function readchar(ok_chars : char_set) : char; { Restricts input to ok_chars }

var
  c : char;

begin
  repeat
    read(kbd,c);
    if not (c in ok_chars)
      then beep
  until c in ok_chars;
  readchar := c
end;
{=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=}
procedure readstr(var s : anystr); { Leaves door open for fancy string input }

begin
  readln(s)
end;
{=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=}
function upcasestr(s : anystr) : anystr; { Force string to all caps }

var
  i : integer;

begin
  for i := 1 to length(s) do
    s[i] := upcase(s[i]);
  upcasestr := s
end;
{=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=}
procedure protect_status_line;

begin
  write(#27,'y1')
end;
{=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=}
procedure unprotect_status_line;

begin
  write(#27,'x1')
end;
{=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=}
procedure center(y,             { Blanked field & center string }
                 xl,
                 xr  : byte;
                 txt : anystr);

var
  pad : byte;
  cursor : integer;

begin
  pad := (xr-xl-length(txt)+1) shr 1;
  at(y,xl); write('':pad,txt);
  cursor := cursorpos;
  write('':(xr-xl-length(txt)+1-pad));
  setcursor(cursor)
end;
{=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=}
procedure left(y,            { Left adjust string & fill right with fill char }
               xl,
               xr   : byte;
               txt  : anystr;
               fill : char);

var
  i : integer;

begin
  at(y,xl); write(txt,' ');
  for i := 1 to xr-xl-length(txt) do
    write(fill)
end;
{=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=}
procedure right(y,           { Right adjust string & fill left with fill char }
                xl,
                xr   : byte;
                txt  : anystr;
                fill : char);

var
  i : integer;

begin
  at(y,xl);
  for i := 1 to xr-xl-length(txt) do
    write(fill);
  write(' ',txt)
end;
{=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=}
procedure msg(txt : anystr); { Center msg on line 23 }

begin
  center(23,1,80,txt);
end;
{=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=}
procedure show_functions(func_txt : anystr); { Display functions on line 25 }

begin
  msg('Select function');
  unprotect_status_line;
  lowvideo;
  center(25,1,80,func_txt);
  normvideo;
  at(23,1)
end;
{=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=}
function get_function(func_list : anystr) : byte; { Get function key }

var
  c : char;
  i : integer;
  ok : boolean;

begin
  ok := false;
  repeat
    cursoroff;
    c := readchar([#27]);
    read(kbd,c);
    if c='?'
      then read(kbd,c);
    i := pos(c,func_list);
    if i=0
      then begin
        beep;
        ok := false
      end
      else begin
             ok := true;
             get_function := i-1
           end
  until ok;
  cursoron
end;
{=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=}
function yes(txt : anystr) : boolean; { Display txt, get Y or N,
                                        return TRUE if Y, FALSE if N }

var
  c : char;
  cursor : integer;

begin
  cursor := cursorpos;
  msg(txt+' (Y/N) ');
  c := readchar(['y','Y','n','N']);
  yes := (upcase(c) = 'Y');
  msg('');
  setcursor(cursor)
end;
{=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=}
function no(txt : anystr) : boolean; { Same as "yes" except opposite logic }

begin
  no := not yes(txt)
end;
{=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=}
procedure await_any_key(txt : anystr);

begin
  msg(txt);
  repeat until keypressed;
  reset(kbd)
end;
{=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=}
