{$X+}{$F+}
program barneys_quest_six;
uses krush2,crt,dos;
const

  BColor = 6;
  Ib : array[0..5,0..7] of byte =
       ((052,052,052,000,052,052,052,000),(000,053,000,000,053,000,000,053),
        (000,054,000,000,054,054,054,000),(000,056,000,000,056,000,000,056),
        (000,057,000,000,057,000,000,057),(059,059,059,000,059,059,059,000));


  Barney : array[0..4,0..3] of byte =
           ((1,1,1,0),(1,0,0,1),(1,1,1,0),(1,0,0,1),(1,1,1,0));

  Boogie_man : array[0..4,0..3] of byte =
               ((0,0,0,0),(0,1,1,0),(1,0,0,1),(1,0,0,1),(0,1,1,0));

  cube1 : array[1..8,1..3] of integer =
          ((-1,-1,+1),(+1,-1,+1),(+1,+1,+1),(-1,+1,+1),
           (-1,-1,-1),(+1,-1,-1),(+1,+1,-1),(-1,+1,-1));

  faces : array[1..6,1..4] of word =
              ((1,2,3,4),(2,6,7,3),(1,5,6,2),
               (8,7,6,5),(1,4,8,5),(3,7,8,4));


type fontt  = array[0..25600] of byte;
     piccy  = array[0..63999] of byte;
     palz   = array[0..768] of byte;
     point  = record x,y,z:real end;


var  f              : file;
     BIOSkeyb       : pointer;
     key,txc        : byte;
     underB         : array[0..4,0..3] of byte;
     font           : ^fontt;
     syk1,syk2,syk3 : ^piccy;
     pal            : ^palz;
     cube           : array[1..8] of point;
     conv           : array[1..8] of point;
     twod           : array[1..8] of record x,y:integer; end;
     z1,z2,z3       : array[1..8] of real;
     ctb,stb        : array[0..360] of real;

     xof,yof,zof,lx,ly,death,steps,pts,counter  : integer;
     x,y,z,q,w,i,old_i,plot,lev,Tlev,virseg,d   : word;


procedure keybhandler; interrupt;
assembler;asm;in al,$60;mov key,al;mov al,$20;out $20,al;end;

procedure SetCube;
begin
for i:=0 to 360 do begin stb[i] := sin(i*pi/180); ctb[i] := cos(i*pi/180); end;
for i:=1 to 8 do begin cube[i].x := cube1[i,1]; cube[i].y := cube1[i,2]; cube[i].z := cube1[i,3];end;
for i:=1 to 4 do setcolor(10+i,45+(i*4),0,0);xof:=25; yof:=145; zof:=20;
end;

procedure Rotatepoints(Xan,Yan,Zan : integer);
var tmp: point;
begin
  for i:=1 to 8 do begin
    tmp.x := cube[i].x;
    tmp.y := cube[i].y*ctb[Xan] - cube[i].z*stb[Xan];
    tmp.z := cube[i].y*stb[Xan] + cube[i].z*ctb[Xan];
    conv[i] := tmp;

    tmp.x := conv[i].x*ctb[Yan] - conv[i].z*stb[Yan];
    tmp.z := conv[i].x*stb[Yan] + conv[i].z*ctb[Yan];
    conv[i] := tmp;

    tmp.x := conv[i].x*ctb[Zan] - conv[i].y*stb[Zan];
    tmp.y := conv[i].x*stb[Zan] + conv[i].y*ctb[Zan];
    conv[i] := tmp;

    z1[i] := conv[i].z;
  end;
end;


procedure Drawpoints;
var tmp:real;
begin
  for i:=1 to 8 do begin
    tmp := conv[i].z+zof;
    twod[i].x := round((conv[i].x*256)/ tmp+xof);
    twod[i].y := round((conv[i].y*256)/ tmp+yof);
  end;
  for i:=1 to 6 do
  z2[i] := conv[faces[i,1]].z + conv[faces[i,2]].z +
           conv[faces[i,3]].z + conv[faces[i,4]].z;

  for i:=3 downto 1 do
   if (abs(z2[i]-z2[i+3])>1) then if z2[i]<z2[i+3]

   then drawpoly (twod[faces[i,1]].x,twod[faces[i,1]].y,
                  twod[faces[i,2]].x,twod[faces[i,2]].y,
                  twod[faces[i,3]].x,twod[faces[i,3]].y,
                  twod[faces[i,4]].x,twod[faces[i,4]].y,10+i,virseg)
   else drawpoly (twod[faces[i+3,1]].x,twod[faces[i+3,1]].y,
                  twod[faces[i+3,2]].x,twod[faces[i+3,2]].y,
                  twod[faces[i+3,3]].x,twod[faces[i+3,3]].y,
                  twod[faces[i+3,4]].x,twod[faces[i+3,4]].y,10+i,virseg)
end;


procedure texty (x,y:word; txt:string);
var e:byte;
begin
  for q:=1 to length(txt) do
   for w:=0 to 9 do for e:=0 to 9 do
    if font^[ord(txt[q])*100+w+e*10]<>0 then
       mem[$A000:320*y+q*10+w*320+e+x] := font^[ord(txt[q])*100+w+e*10];
end;

procedure textx (x,y:word; txt:string);
var e:byte;
begin
  for q:=1 to length(txt) do
   for w:=0 to 4 do for e:=0 to 4 do
    if font^[ord(txt[q])*25+w+e*5]<>0 then
       mem[$A000:320*y+q*5+w*320+e+x] := txc;
end;

procedure LOADPCX(filename:string;gfxdataptr:pointer);
var
 {Decoding}         rc:byte;   {Repeat count counter}
 {Position meters}  ibp:word;  {Input data position meter}
 {Scanline things}  sls:word;  {How much data is already decoded}
                    slp:word;  {Position on scanline being to processed}
                    obf:^piccy;
                    ibf:^piccy;
                    plp:byte;   {Palette position, used when decoding}
begin
  new(ibf);
  obf:=gfxdataptr;               {Locate output to given memory address}
  assign(f,filename);            {Open data file}
  reset(f,1);                    {Reset datafile}
  blockread(f,ibf^,$80);         {Discard header}
  blockread(f,ibf^,filesize(f)-$80); {Read data from file}
  close(f);
  ibp:=0;                        {Set input pointer to 0}
  sls:=0;                        {Set amout of data decoded to zero}
  while sls<$FA00 do begin {Repeat decoding until whole picture is decoded}
    slp:=0;
    while slp<$140 do begin {Decode all pixels for one gfx line}
      if (ibf^[ibp] and $C0)=$C0 then begin {Determinate if data is compressed}
        fillchar(obf^[sls+slp],ibf^[ibp] and $3F,ibf^[ibp+1]); {Move data to it's position}
        inc(slp,ibf^[ibp] and $3F); {Advance amount decoded of this line}
        inc(ibp,2); {Advance input buffer position}
      end else begin
        obf^[sls+slp]:=ibf^[ibp]; {Just move data from input to output}
        inc(slp); {Advance amount decoded of this line}
        inc(ibp); {Adanvce input buffer position}
      end;
    end;
    inc(sls,$140); {Advance gfx line to be decoded}
  end;
  inc(ibp);
  for plp:=0 to $FF do begin
    pal^[plp*3+0]:=ibf^[ibp+plp*3+0] shr 2; {Get red   value of color and divide it with 4}
    pal^[plp*3+1]:=ibf^[ibp+plp*3+1] shr 2; {Get green value of color and divide it with 4}
    pal^[plp*3+2]:=ibf^[ibp+plp*3+2] shr 2; {Get blue  value of color and divide it with 4}
  end;
  dispose(ibf);
end;



procedure Instructions;
begin
  txc:=6;
  for w:=45 to 153 do for q:=45 to 285 do mem[$A000:w*320+q]:=0;
  textx(50,50,'BARNEY ARRIVES AT SCHOOL FOR HIS FIRST DAY');
  textx(50,56,'AS AN IB-NERD. HE IS NERVOUS AND EXCITED.');
  textx(50,62,'HE IS CARRYING ALL OF HIS IB-BOOKS (26.34 KG)');
  textx(50,68,'AND IS THEREFORE VERY,VERY SLOW TODAY...');
  textx(50,80,'YOU, THE PLAYER, WILL NEED TO GUIDE BARNEY');
  textx(50,86,'THROUGH HIS FIRST DAY. IT WILL NOT BE AN');
  textx(50,92,'EASY JOB, BUT IF YOU FOLLOW INSTRUCTIONS,');
  textx(50,98,'PERHAPS BARNEY WILL MAKE IT THROUGH ALIVE.');
  textx(50,104,'PERHAPS...                                ');
  textx(50,120,'A WORD OF CAUTION: BECAUSE THE SANITARY');
  textx(50,126,'PERSONNEL ARE ON STRIKE, TOUCHING ANYTHING');
  textx(50,132,'SUSPICIOUS, LIKE WALLS, IS NOT ADVISED, AS');
  textx(50,138,'SERIOUS (AND I MEAN SERIOUS) PERSONAL INJURY');
  textx(50,144,'MAY OCCUR.');
  key:=0; repeat until key=$39;
  for w:=45 to 153 do for q:=45 to 285 do mem[$A000:w*320+q]:=0;
  textx(50,50,'THE FUNNY LITTLE COUNTER ON THE FAR RIGHT');
  textx(50,56,'MEANS THE AMOUNT OF NERD-BOXES YOU HAVE');
  textx(50,62,'COLLECTED SO FAR. THE COUNTER BELOW IT IS');
  textx(50,68,'INDICATING THE TIME YOU HAVE TO ACCOMPLISH');
  textx(50,74,'YOUR MISSION BEFORE THE SPECTACULAR WEIGHT');
  textx(50,80,'OF THE BOOKS YOU ARE CARRYING (28.3442 KG)');
  textx(50,86,'SNAPS YOUR SPINAL CORD LIKE A LITTLE TWIG');
  textx(50,98,'THE MESSAGE AT THE BOTTOM OF THE SCREEN IS');
  textx(50,104,'THE INTERACTIVE MULTIMEDIA DISPLAY TELLING');
  textx(50,110,'YOU WHAT YOUR CURRENT MISSION IS.');
  textx(50,122,'THE NERD-BOXES ALSO GIVE BARNEY A LITTLE BIT');
  textx(50,128,'OF EXTRA TIME. SO THERE, EVERYTHING CLEAR NOW?');
  textx(50,138,'REMEMBER, ANYTHING CAN HAPPEN. BARNEY MIGHT');
  textx(50,144,'EVEN MAKE IT THROUGH ALIVE...');
  key:=0; repeat until key=$39;
  setcolor(7,63,21,63);
  for w:=45 to 153 do for q:=45 to 285 do mem[$A000:w*320+q]:=0;
  textx(50,50,'OH, AND ABOUT THE INTERACTIVE MULTIMEDIA');
  textx(50,56,'DISPLAY:');
  textx(50,68,'THIS NORMAL KIND OF WHITE TEXT MEANS THAT');
  textx(50,74,'SOMEONE IS TALKING TO YOU.'); txc:=7;
  textx(50,86,'AND THIS KIND OF TEXT MEANS YOUR WEIRD');
  textx(50,92,'PERSONALITY IS SPEAKING.'); txc:=6;
  key:=0; repeat until key=$39;
end;


procedure Begin_Game;
begin
  new(syk1); new(pal);
  loadpcx('c:\krush\barney6.pcx',syk1);
  move(syk1^,mem[$A000:0],64000);
  for i:=0 to 255 do setcolor(i,pal^[i*3],pal^[i*3+1],pal^[i*3+2]);
  loadpcx('c:\krush\barney62.pcx',syk1);
  w:=key; repeat until key<>w;
  move(syk1^,mem[$A000:0],64000);
  w:=key; repeat until key<>w;
  new(font); assign(f,'c:\krush\tiny.fnt');reset(f,1);
  blockread(f,font^,6400); close(f);
  for i:=0 to 255 do setcolor(i,pal^[i*3],pal^[i*3+1],pal^[i*3+2]);
  w:=key; repeat if (key=$17) then Instructions; until key<>w;
end;


procedure Draw_target;
label again;
begin
  inc(steps,50); inc(pts);
  case lev of
   1:Move(syk1^,mem[$A000:0],58880);
   2:Move(syk2^,mem[$A000:0],58880);
   3:Move(syk3^,mem[$A000:0],58880);
  end;
Again:
  Tlev:=random(3)+1; plot:= 320*(random(177)+5) + random(285)+5;
  case Tlev of
  1: for q:=0 to 5 do for w:=0 to 7 do if
     mem[seg(syk1^):ofs(syk1^)+320*q+plot+w]=1 then goto Again;
  2: for q:=0 to 5 do for w:=0 to 7 do if
     mem[seg(syk2^):ofs(syk2^)+320*q+plot+w]=1 then goto Again;
  3: for q:=0 to 5 do for w:=0 to 7 do if
     mem[seg(syk3^):ofs(syk3^)+320*q+plot+w]=1 then goto Again;
  end;
end;


procedure Draw_Barney(x,y,color:integer);
var clr:byte;
begin
  clr:=0;
  for q:=0 to 4 do for w:=0 to 3 do mem[$A000:lx+w+320*ly+320*q]:=underB[q,w];
  for q:=0 to 4 do for w:=0 to 3 do underB[q,w]:=mem[$A000:x+w+320*y+320*q];
  for q:=0 to 4 do for w:=0 to 3 do if underB[q,w]=1 then death:=1;
  for q:=0 to 4 do for w:=0 to 3 do if underB[q,w]>51then begin
    clr:=1;
    case lev of
    1: underB[q,w]:=syk1^[w+x+320*(y+q)];
    2: underB[q,w]:=syk2^[w+x+320*(y+q)];
    3: underB[q,w]:=syk3^[w+x+320*(y+q)];
    end;
  end;
  for q:=0 to 4 do for w:=0 to 3 do
  if barney[q,w]<>0 then mem[$A000:x+w+320*y+320*q]:=color;
  lx:=x;ly:=y;
  if clr=1 then Draw_target;
end;


procedure Barneys_Quest;
begin
  Cls(0);
  new(syk2);
  loadpcx('c:\krush\syk2.pcx',syk2);
  new(syk3);
  loadpcx('c:\krush\syk3.pcx',syk3);
  loadpcx('c:\krush\syk1.pcx',syk1);
  for q:=0 to 255 do setcolor(q,pal^[q*3],pal^[q*3+1],pal^[q*3+2]);
  setcolor(6,63,63,63); setcolor(7,63,0,63);move(syk1^,mem[$A000:0],64000);
  for q:=0 to 4 do for w:=0 to 3 do underB[q,w]:=0;
  delay(200); Draw_Barney(1,67,Bcolor); delay(300);
  for x:=1 to 10 do begin Draw_Barney(x,67,Bcolor);delay(80);end; delay(400);
  for y:=63 to 76 do mem[seg(syk1^):ofs(syk1^)+y*320+3]:=1;
end;


procedure Multiple_Choice;
var wrong:byte; nwrong:string;
begin
  Cls(0); Wrong:=0; txc:=6;
  textx(30,10,'PRESS THE CORRECT NUMBER (1,2,3) FOR EACH QUESTION');
  {Q1}   textx(70,50,'THE IB-PEOPLE ARE ALSO KNOWN AS:');
         textx(70,70,'1.      The legion of the living dead');
         textx(70,80,'2.           The legion of the damned');
         textx(70,90,'3.       The battalion of brain cells');
         key:=0; repeat until (key=2) or (key=3) or (key=4);
         if (key=2) or (key=4) then inc(wrong); cls(0);

  {Q2}   textx(70,50,'WHAT CAN''T YOU PUT FOR X:');
         textx(70,70,'1.                               zero');
         textx(70,80,'2.                       x*3-1.051st');
         textx(70,90,'3.                                one');
         key:=0; repeat until (key=2) or (key=3) or (key=4);
         if (key=3) or (key=4) then inc(wrong); Cls(0);

  {Q3}   textx(70,50,'CERTAIN AQUATIC SLUGS LIKE THEIR STEAKS:');
         textx(70,70,'1.                         medium-raw');
         textx(70,80,'2.                         deep-fried');
         textx(70,90,'3.                          well-done');
         key:=0; repeat until (key=2) or (key=3) or (key=4);
         if (key=3) or (key=2) then inc(wrong); Cls(0);

  {Q4}   textx(70,50,'CERTAIN AQUATIC SLUGS TASTE BEST:');
         textx(70,70,'1.           with ammonium trinitrate');
         textx(70,80,'2.                         deep-fried');
         textx(70,90,'3.                      non-explosive');
         key:=0; repeat until (key=2) or (key=3) or (key=4);
         if (key=2) then inc(wrong); Cls(0);

  {Q5}   textx(70,50,'SCHOOL FOOD IS RICH IN:');
         textx(70,70,'1.                ammonium trinitrate');
         textx(70,80,'2.                   ammonium nitrate');
         textx(70,90,'3.                 ammonium nitroxide');
         key:=0; repeat until (key=2) or (key=3) or (key=4);
         if (key=2) or (key=4) then inc(wrong); Cls(0);

  {Q6}   textx(70,50,'GORIOTS'' DAUGHTERS ARE:');
         textx(70,70,'1.               Nucingen and Restaud');
         textx(70,80,'2.                 Sharon and Beverly');
         textx(70,90,'3.             Delphine and Anastasie');
         key:=0; repeat until (key=2) or (key=3) or (key=4);
         if (key=3) then inc(wrong); Cls(0);

  {Q7}   textx(70,50,'SCHOOL BATHROOMS ARE USED FOR:');
         textx(70,70,'1.                                sex');
         textx(70,80,'2.                             gossip');
         textx(70,90,'3.                        crucifixion');
         key:=0; repeat until (key=2) or (key=3) or (key=4); Cls(0);

  {Q8}   textx(70,50,'THE ''ANDANTE'' IS:');
         textx(70,70,'1.                             Techno');
         textx(70,80,'2.                    A piece of cake');
         textx(70,90,'3.              A violet cheeseburger');
         key:=0; repeat until (key=2) or (key=3) or (key=4);
         if (key=2) or (key=4) then inc(wrong); Cls(0);

  {Q9}   textx(70,50,'HL STANDS FOR:');
         textx(70,70,'1.            Homework and Lots of it');
         textx(70,80,'2.               Hellish Loads''o''work');
         textx(70,90,'3.                           Hot Lips');
         key:=0; repeat until (key=2) or (key=3) or (key=4);
         if (key=2) or (key=4) then inc(wrong); Cls(0);

  {Q10}  textx(70,50,'AQUATIC SLUGS LIVE MAINLY IN:');
         textx(70,70,'1.                          Luxemburg');
         textx(70,80,'2.               Malaita and Bismarck');
         textx(70,90,'3.              Vanuatu and Halmahera');
         key:=0; repeat until (key=2) or (key=3) or (key=4);
         if (key=2) or (key=4) then inc(wrong); Cls(0);


  {Q11}  textx(70,50,'THREE-AND-A-HALF INCH NAILS ARE BEST FOR:');
         textx(70,70,'1.      Cooking certain aquatic slugs');
         textx(70,80,'2.        Crucifying certain students');
         textx(70,90,'3.  Adding flavor to ammonium nitrate');
         key:=0; repeat until (key=2) or (key=3) or (key=4);

  cls(0);
  If wrong>0 then begin
    textx(70,50,'YOU FAILED, THEREFORE YOU MUST DIE!');
    textx(70,60,'QUESTIONS WRONG: ');
    str(wrong,nwrong); textx(180,60,nwrong); death:=1;
    key:=0; repeat until key=$39;
  end;
  If wrong=0 then begin
    textx(70,50,'YOU DID IT! BARNEY SURVIVED!');
    textx(70,60,'I CAN''T BELIEVE IT! YOU MADE BARNEY SURVIVE!');
    textx(70,70,'sorry the great final animation isn''t ready...');
    key:=0; repeat until key=$39; i:=100;
  end;
end;

procedure Draw_Barney_on_a_new_level(x,y,color:integer);
begin
  for q:=0 to 4 do for w:=0 to 3 do underB[q,w]:=mem[$A000:x+w+320*y+320*q];
  for q:=0 to 4 do for w:=0 to 3 do if underB[q,w]=1 then death:=1;
  for q:=0 to 4 do for w:=0 to 3 do if barney[q,w]<>0 then mem[$A000:x+w+320*y+320*q]:=Bcolor;
  lx:=x;ly:=y;
end;

procedure Missions(i:integer);
begin
  for q:=55 to 320 do for w:=185 to 198 do mem[$A000:320*w+q]:=0;
  case i of
   1:  begin
         textx(70,185,'Welcome To S.Y.K');
         textx(70,191,'First you must find the headmaster');
         steps:=600; end;
   2:  begin
         textx(70,185,'Hm: We''re very glad to have you with us');
         textx(70,191,'    for these next 2 years  (Ha Ha Haa)');
         key:=0; repeat until key=$39;;
         for q:=70 to 320 do for w:=185 to 198 do mem[$A000:320*w+q]:=0;
         textx(70,185,'Hm: Now go to room 2C');
         textx(70,191,'    And meet your new classmates');
         steps:=150; key:=0;repeat until key=$39;end;
   3:  begin
         textx(70,185,'Well hello Barney! We, the IB-nerds have decided');
         textx(70,191,'to call ourselves the ''Legion of the Damned''');
         key:=0; repeat until key=$39;;
         for q:=70 to 320 do for w:=185 to 198 do mem[$A000:320*w+q]:=0;
         textx(70,185,'Now for your first lesson.');
         textx(70,191,'Maths, in the musicroom (naturally)');
         steps:=250; key:=0;repeat until key=$39;end;
   4:  begin
         textx(55,185,'The sin of the acute angle is simply x*3-1.051st');
         textx(55,191,'the reciprocal of which is 12k$21,3+][. Understand?');
         key:=0; repeat until key=$39;
         for q:=55 to 320 do for w:=185 to 198 do mem[$A000:320*w+q]:=0;
         textx(65,185,'You can''t put 0 for x. Well, you can, but it''s');
         textx(65,191,'impossible. Now go to the nerd-room to study.');
         steps:=250; key:=0;repeat until key=$39;end;
   5:  begin
         txc:=7;
         textx(55,185,'You have 12 essays to do for next lesson. Get to it!');
         textx(55,191,'You''ll probably find the information you need about');
         key:=0; repeat until key=$39;
         for q:=55 to 320 do for w:=185 to 198 do mem[$A000:320*w+q]:=0;
         textx(55,185,'the ''Mating habits of certain aquatic slugs'' in');
         textx(55,191,'room 3P. Or was it the Chemistry lab?  Whatever...');
         steps:=250; key:=0;repeat until key=$39; txc:=6; end;
   6:  begin
         textx(65,185,'You are in the wrong room!');
         textx(65,191,'Go away!'); y:=127;
         for x:=268 downto 257 do begin delay(25); Draw_Barney(x,y,Bcolor); end;
         for q:=125 to 134 do mem[$A000:q*320+265]:=1; end;
   7:  begin
         textx(55,185,'Ah, Barnie... Come to find out about certain habits');
         textx(55,191,'of certain aquatic slugs, have you?');
         key:=0; repeat until key=$39;
         for q:=55 to 320 do for w:=185 to 198 do mem[$A000:320*w+q]:=0;
         textx(55,185,'Too bad I just had a complete mental breakdown and');
         textx(55,191,'lost my memory... You''ll have to go to room 3P');
         steps:=220; key:=0;repeat until key=$39;end;
   8:  begin
         textx(55,185,'Well.. If it isn''t Barney, the living vegetable');
         textx(55,191,'Actually, you''ve done pretty well. Now, be a dear');
         key:=0; repeat until key=$39;
         for q:=55 to 320 do for w:=185 to 198 do mem[$A000:320*w+q]:=0;
         textx(55,185,'and go fetch some books from the library for me.');
         textx(55,191,'I can''t teach you about slugs if I don''t have them.');
         steps:=200; key:=0;repeat until key=$39;end;
   9:  begin
         textx(55,185,'Hello Barney, I am NoTal King, the librarian. But');
         textx(55,191,'you may call me Owagadewrji. I suppose Mrs. 3P sent');
         key:=0; repeat until key=$39;
         for q:=55 to 320 do for w:=185 to 198 do mem[$A000:320*w+q]:=0;
         textx(55,185,'you to get some books. Here they are, only these');
         textx(55,191,'two hundred. Not heavy at all. Now go back to 3P.');
         d:=50; key:=0;repeat until key=$39;end;
  10:  begin
         textx(55,185,'Thank you, Barney. Now, about these aquatic slugs...');
         textx(55,191,'the only thing you need to know about them is...');
         key:=0; repeat until key=$39;
         for q:=55 to 320 do for w:=185 to 198 do mem[$A000:320*w+q]:=0;
         textx(55,185,'that they prefer their chateaubriand well done.');
         textx(55,191,'You had better hurry, if you want to make it in');
         key:=0; repeat until key=$39;
         for q:=55 to 320 do for w:=185 to 198 do mem[$A000:320*w+q]:=0;
         textx(55,185,'time for your cookery lesson on the first floor.');
         textx(55,191,'And remember... not medium raw, but well done!');
         steps:=180; d:=18; key:=0;repeat until key=$39;end;
  11:  begin
         textx(55,185,'Welcome to cookery, Barney. I think you will find');
         textx(55,191,'that cookery is the most important subject you''ll');
         key:=0; repeat until key=$39;
         for q:=55 to 320 do for w:=185 to 198 do mem[$A000:320*w+q]:=0;
         textx(55,185,'learn during your IB-years. Especially the making');
         textx(55,191,'of certain fried aquatic slugs. Ahh... Delicious!');
         key:=0; repeat until key=$39;
         for q:=55 to 320 do for w:=185 to 198 do mem[$A000:320*w+q]:=0;
         textx(55,185,'Would you be kind enough to fetch us some nails?');
         textx(55,191,'About three-and-a-half inchers will do just fine.');
         steps:=100; key:=0; repeat until key=$39;end;
  12:  begin
         txc:=7;
         textx(55,185,'After looking around a bit, you find the nails');
         textx(55,191,'Now run back to Mrs. Crucifixion.');
         steps:=120; key:=0; repeat until key=$39; txc:=6; end;
  13:  begin
         textx(55,185,'Back so soon, Barney. And you''ve got the nails');
         textx(55,191,'Now if you just follow me to the toilet...');
         key:=0; repeat until key=$39; txc:=7;
         for q:=55 to 320 do for w:=185 to 198 do mem[$A000:320*w+q]:=0;
         textx(55,185,'Mrs. Crucifixion heads off towards the bathroom.');
         textx(55,191,'(Barney, are you sure you want to do this?)');
         key:=0; repeat until key=$39;
         for q:=55 to 320 do for w:=185 to 198 do mem[$A000:320*w+q]:=0;
         textx(55,185,'The bell rings, your next lesson is in room 29,');
         textx(55,191,'but Mrs Crux is still waiting in the ladies toilet.');
         steps:=150; key:=0; repeat until key=$39; txc:=6; end;
  14:  begin
         textx(55,185,'Ah, you came. Now just go and stand by that wall.');
         textx(55,191,'I''ll close this door so we will not be bothered.');
         for q:=110 to 122 do mem[$A000:15040+q]:=1;
         key:=0; repeat until key=$39; txc:=7;
         for q:=55 to 320 do for w:=185 to 198 do mem[$A000:320*w+q]:=0;
         textx(55,185,'Mrs. Crux walks back to you, and promptly nails you');
         textx(55,191,'to the wall of the toilet. The pain is immense.');
         key:=0; repeat until key=$39;
         for q:=55 to 320 do for w:=185 to 198 do mem[$A000:320*w+q]:=0;
         textx(55,185,'You die an excruciatingly painful and stupid death');
         textx(55,191,'Barney, You''re an Idiot!');
         death:=1; key:=0; repeat until key=$39; txc:=6;end;
  15: begin
         textx(55,185,'Welcome to HL-level Biology. Of course you all know');
         textx(55,191,'that HL stands for Hellish Loads''o''work.');
         key:=0; repeat until key=$39;
         for q:=55 to 320 do for w:=185 to 198 do mem[$A000:320*w+q]:=0;
         textx(55,185,'Today we plan to write 4218 pages of notes and');
         textx(55,191,'perform 13.8 practicals. Lets start with the ');
         key:=0; repeat until key=$39;
         for q:=55 to 320 do for w:=185 to 198 do mem[$A000:320*w+q]:=0;
         textx(55,185,'reproduction of certain aquatic slugs, and how it');
         textx(55,191,'effects the islands of Malaita and Bismarck.');
         key:=0; repeat until key=$39; txc:=7;
         for q:=55 to 320 do for w:=185 to 198 do mem[$A000:320*w+q]:=0;
         textx(55,185,'Centuries seem to pass, yet it is actually only a');
         textx(55,191,'few minutes. After 598 pages of notes your hand');
         key:=0; repeat until key=$39;
         for q:=55 to 320 do for w:=185 to 198 do mem[$A000:320*w+q]:=0;
         textx(55,185,'accidentally catches on fire because of the');
         textx(55,191,'friction. Better hurry to the doc, Barney!');
         steps:=85; key:=0; repeat until key=$39; txc:=6; end;
  16: begin
         textx(55,185,'I am the local witch doctor, my name is IxtqwZa.');
         textx(55,191,'My goodness, those look like severe 2nd degree ');
         key:=0; repeat until key=$39;
         for q:=55 to 320 do for w:=185 to 198 do mem[$A000:320*w+q]:=0;
         textx(55,185,'burns on your hand. Have you been trying to make');
         textx(55,191,'medium raw steaks for certain aquatic slugs?');
         key:=0; repeat until key=$39;
         for q:=55 to 320 do for w:=185 to 198 do mem[$A000:320*w+q]:=0;
         textx(55,185,'No, those look more like Bio-burns. I''ll just');
         textx(55,191,'patch you up. There. Run back to your lesson.');
         steps:=100; key:=0; repeat until key=$39; end;
  17: begin
         textx(55,185,'Barney, you''re back! We are just studying the');
         textx(55,191,'temperature needed to cook medium-raw steaks.');
         key:=0; repeat until key=$39;
         for q:=55 to 320 do for w:=185 to 198 do mem[$A000:320*w+q]:=0;
         textx(55,185,'Here, have a cow. Just carve a piece out of it');
         textx(55,191,'and marinate it. Go on, we haven''t got all day.');
         key:=0; repeat until key=$39; txc:=7;
         for q:=55 to 320 do for w:=185 to 198 do mem[$A000:320*w+q]:=0;
         textx(55,185,'You manage to overdo your steak, burn the lab,');
         textx(55,191,'and spill soya-sauce all over the place. Not ');
         key:=0; repeat until key=$39;
         for q:=55 to 320 do for w:=185 to 198 do mem[$A000:320*w+q]:=0;
         textx(55,185,'bad for  a first-timer. The bell saves you.');
         textx(55,191,'Time for your violin lessons in the practice room.');
         steps:=180; key:=0; repeat until key=$39; txc:=6; end;
  18: begin
         textx(55,185,'Ah, please play Tchaikovskys ''Andante'' while I');
         textx(55,191,'go for some coffee and deep-fried aquatic slugs. ');
         for q:=89 to 95 do mem[$A000:q*320+23]:=1;
         key:=0; repeat until key=$39; txc:=7;
         for q:=55 to 320 do for w:=185 to 198 do mem[$A000:320*w+q]:=0;
         textx(55,185,'You suddenly realize that you haven''t even held');
         textx(55,191,'a violin, much less actually touched the strings.');
         key:=0; repeat until key=$39;
         for q:=55 to 320 do for w:=185 to 198 do mem[$A000:320*w+q]:=0;
         textx(55,185,'You also suddenly realize that you are');
         textx(55,191,'trapped here.'); txc:=6;
         steps:=300; key:=0; repeat until key=$39; end;
  19: begin
         textx(55,185,'Ready? I bet you thought you were going to die.');
         textx(55,191,'You may go. I''ts time to eat. (Ha Ha Haa)');
         for q:=89 to 95 do mem[$A000:q*320+23]:=0;
         steps:=130; key:=0; repeat until key=$39; end;
  20: begin txc:=7;
         textx(55,185,'You are shoved a plate of hot sludge, and told');
         textx(55,191,'to go sit down.'); txc:=6;
         steps:=100; key:=0; repeat until key=$39; end;
  21: begin txc:=7;
         textx(55,185,'You sit down, and apprehensively taste the sludge.');
         textx(55,191,'Your throat feels warm.');
         key:=0; repeat until key=$39;
         lev:=2; x:= 65; y:=20; Move(syk2^,mem[$A000:0],58560);
         Draw_Barney_on_a_new_level(x,y,Bcolor); delay(500);
         for q:=55 to 320 do for w:=185 to 198 do mem[$A000:320*w+q]:=0;
         textx(55,185,'You regain consciousness. The doctor tells you:'); txc:=6;
         textx(55,191,'You had a close one, laddie. You shouldn''t go');
         key:=0; repeat until key=$39;
         for q:=55 to 320 do for w:=185 to 198 do mem[$A000:320*w+q]:=0;
         textx(55,185,'eating ammonium nitrate without permission.');
         textx(55,191,'Bad boy! Now go to your chemistry lesson.');
         steps:=160; key:=0; repeat until key=$39; end;
  22: begin
         textx(55,185,'Welcome to Chemistry. Here we will learn which');
         textx(55,191,'substances explode and which don''t. This, is Igor,');
         key:=0; repeat until key=$39;
         for q:=55 to 320 do for w:=185 to 198 do mem[$A000:320*w+q]:=0;
         textx(55,185,'my assistant. Today we will prepare non-explosive');
         textx(55,191,'aquatic slugs. Everybody, take out your frying pans.');
         key:=0; repeat until key=$39; txc:=7;
         for q:=55 to 320 do for w:=185 to 198 do mem[$A000:320*w+q]:=0;
         textx(55,185,'You only set fire to your oven this time. You are');
         textx(55,191,'getting better at this. Your next lesson is in 26.');
         steps:=150; key:=0; repeat until key=$39; txc:=6; end;
  23: begin
         textx(55,185,'Welcome to English. Please read this 280 page book.');
         textx(55,191,'You have approximately 17 minutes. ');
         key:=0; repeat until key=$39; txc:=7;
         for q:=55 to 320 do for w:=185 to 198 do mem[$A000:320*w+q]:=0;
         textx(55,185,'You glance at the title. "Pere Goriot"  The cover ');
         textx(55,191,'looks so boring that you don''t even begin reading.');
         key:=0; repeat until key=$39; txc:=6;
         for q:=55 to 320 do for w:=185 to 198 do mem[$A000:320*w+q]:=0;
         textx(55,185,'Now kids, who can tell me the names of Goriots'' ');
         textx(55,191,'daughters?  Barney, Why don''t you have a go. ');
         key:=0; repeat until key=$39; txc:=7;
         for q:=55 to 320 do for w:=185 to 198 do mem[$A000:320*w+q]:=0;
         textx(55,185,'You concentrate all your psychic energy, and then');
         textx(55,191,'answer: Beverly and Sharon!  The teacher looks');
         key:=0; repeat until key=$39;
         for q:=55 to 320 do for w:=185 to 198 do mem[$A000:320*w+q]:=0;
         textx(55,185,'strangely at you for a while, then tells you');
         textx(55,191,'that their names were Anastasie and Delphine.');
         key:=0; repeat until key=$39;
         for q:=55 to 320 do for w:=185 to 198 do mem[$A000:320*w+q]:=0;
         textx(55,185,'Well, you were pretty close. Luckily the headmaster');
         textx(55,191,'decides to make an announcement at that moment:');
         key:=0; repeat until key=$39; txc:=6;
         for q:=55 to 320 do for w:=185 to 198 do mem[$A000:320*w+q]:=0;
         textx(55,185,'''Forgive me for interrupting your schoolday,'' ');
         textx(55,191,'''but the school is on fire.'' ');
         key:=0; repeat until key=$39; txc:=7;
         for q:=55 to 320 do for w:=185 to 198 do mem[$A000:320*w+q]:=0;
         textx(55,185,'Everyone else rushes outside. You had better');
         textx(55,191,'follow them, or find a SAFE place. ');
         steps:=350; key:=0; repeat until key=$39; txc:=6; end;
  24: begin txc:=7;
         textx(55,185,'You judge this to be a safe place. You sit around');
         textx(55,191,'until the fire department comes and sprays you');
         key:=0; repeat until key=$39;
         for q:=55 to 320 do for w:=185 to 198 do mem[$A000:320*w+q]:=0;
         textx(55,185,'totally wet. Your English teaches tells you to');
         textx(55,191,'go to your test in the ''Scenery'' ');
         steps:=140; key:=0; repeat until key=$39; txc:=6; end;
  25: begin txc:=7;
         textx(55,185,'You sit down, and a teacher gives you paper with');
         textx(55,191,'some multiple choice questions.');
         key:=0; repeat until key=$39; txc:=6;
         Multiple_Choice; end;
  end;
  old_i:=i;
end;


procedure checklevel;

procedure two2one;begin lev:=1; x:=x+24; Move(syk1^,mem[$A000:0],58560);Draw_barney_on_a_new_level(x,y,Bcolor);end;
procedure two2one2;begin lev:=1; x:=x-22; Move(syk1^,mem[$A000:0],58560);Draw_barney_on_a_new_level(x,y,Bcolor);end;
procedure one2two;begin lev:=2; x:=x-16; Move(syk2^,mem[$A000:0],58560);Draw_barney_on_a_new_level(x,y,Bcolor);end;
procedure one2two2;begin lev:=2; x:=x+16; Move(syk2^,mem[$A000:0],58560);Draw_barney_on_a_new_level(x,y,Bcolor);end;
procedure three2two;begin lev:=2; x:=x+24; move(syk2^,mem[$A000:0],58560);Draw_barney_on_a_new_level(x,y,Bcolor);end;
procedure three2two2;begin lev:=2; x:=x-22; move(syk2^,mem[$A000:0],58560);Draw_barney_on_a_new_level(x,y,Bcolor);end;
procedure two2three;begin lev:=3; x:=x-22; Move(syk3^,mem[$A000:0],58560);Draw_barney_on_a_new_level(x,y,Bcolor);end;
procedure two2three2;begin lev:=3; x:=x+24; Move(syk3^,mem[$A000:0],58560);Draw_barney_on_a_new_level(x,y,Bcolor);end;

begin
  if (lev=1) and (x>63) and (x<76) and (y>47) and (y<62) then one2two;
  if (lev=1) and (x>63) and (x<76) and (y>121) and (y<137) then one2two;
  if (lev=1) and (x>206) and (x<218) and (y>47) and (y<62) then one2two2;
  if (lev=1) and (x>206) and (x<218) and (y>121) and (y<137) then one2two2;

  if (lev=2) and (x>76) and (x<82) and (y>47) and (y<62) then two2three;
  if (lev=2) and (x>76) and (x<82) and (y>121) and (y<137) then two2three;
  if (lev=2) and (x>196) and (x<206) and (y>47) and (y<62) then two2three2;
  if (lev=2) and (x>196) and (x<206) and (y>121) and (y<137) then two2three2;

  if (lev=2) and (x>66) and (x<76) and (y>47) and (y<62) then two2one;
  if (lev=2) and (x>66) and (x<76) and (y>121) and (y<137) then two2one;
  if (lev=2) and (x>198) and (x<212) and (y>47) and (y<62) then two2one2;
  if (lev=2) and (x>198) and (x<212) and (y>121) and (y<137) then two2one2;

  if (lev=3) and (x>66) and (x<88) and (y>47) and (y<62) then three2two;
  if (lev=3) and (x>66) and (x<88) and (y>121) and (y<137) then three2two;
  if (lev=3) and (x>196) and (x<218) and (y>47) and (y<62) then three2two2;
  if (lev=3) and (x>196) and (x<218) and (y>121) and (y<137) then three2two2;
end;

procedure Checkmission;
begin
  if  (i=1) and (lev=2) and (x>94) and (y>152) and (x<113) then inc(i);
  if  (i=2) and (lev=2) and (x>173) and (y>160) and (x<193) then inc(i);
  if  (i=3) and (lev=1) and (x<57) and (y<26) then inc(i);
  if  (i=4) and (lev=2) and (x>264) and (y>32) and (y<44) then inc(i);
  if  (i=5) and (lev=3) and (x>268) and (y>122) and (y<137) then inc(i);
  if  (i=5) and (lev=1) and (x<57) and (y>155) then inc(i,2);
  if  (i=6) and (lev=3) and (x>268) and (y>122) and (y<137) then Missions(6);
  if  (i=6) and (lev=1) and (x<57) and (y>155) then inc(i);
  if  (i=7) and (lev=3) and (x>268) and (y>122) and (y<137) then inc(i);
  if  (i=8) and (lev=2) and (x>218) and (y>68) and (y<115) then inc(i);
  if  (i=9) and (lev=3) and (x>268) and (y>122) and (y<137) then inc(i);
  if (i=10) and (lev=1) and (y<27) and (x>57) and (x<133) then inc(i);
  if (i=11) and (lev=1) and (y<27) and (x>195) and (x<258) then inc(i);
  if (i=12) and (lev=1) and (y<27) and (x>57) and (x<133) then inc(i);
  if (i=13) and (lev=1) and (y>49) and (y<62) and (x>108) and (x<133) then inc(i);
  if (i=13) and (lev=2) and (y<27) and (x>248) then inc(i,2);
  if (i=15) and (lev=2) and (y<25) and (x>50) and (x<76) then inc(i);
  if (i=16) and (lev=2) and (y<27) and (x>248) then inc(i);
  if (i=17) and (lev=1) and (x<19) and (y>77) and (y<97) then inc(i);
  if (i=18) and (lev=1) and (steps=1) then inc(i);
  if (i=19) and (lev=1) and (x>133) and (x<178) and (y<25) then inc(i);
  if (i=20) and (lev=1) and (x>164) and (x<178) and (y>99) and (y<110) then inc(i);
  if (i=21) and (lev=1) and (y>154) and (x<57) then inc(i);
  if (i=22) and (lev=2) and (y<27) and (x>174) and (x<196) then inc(i);
  if (i=23) and (lev=3) and (y>155) and (x<62) then inc(i);
  if (i=24) and (lev=3) and (x>218) and (y>68) and (y<105) then inc(i);
end;

procedure Checksteps;
var nsteps:string;
begin
  counter:=0;
  if steps=0 then death:=1;
  dec(steps);
  str(steps,nsteps);
  for q:=295 to 320 do for w:=16 to 20 do mem[$A000:q+320*w]:=0;
  txc:=6; textx(292,16,nsteps);
end;

procedure Writepoints;
var np:string;
begin
  for q:=295 to 320 do for w:=10 to 14 do mem[$A000:q+320*w]:=0;
  str(pts,np);
  txc:=6; textx(292,10,np);
end;

label Again,Play_again;
begin
  GetIntVec(9,BIOSkeyb);
  SetIntVec(9,@keybhandler);
  Screenmode($13); cls(0);

Play_Again:

  Begin_Game; lx:=10;ly:=67; pts:=-1; d:=18; txc:=6; death:=0;
  Barneys_Quest; x:=10;y:=67; i:=1; lev:=1; counter:=0; randomize;
  Missions(i); Draw_target;
  repeat
     if Tlev=lev then for q:=0 to 5 do for w:=0 to 7 do mem[$A000:(320*q)+w+plot] := IB[q,w];
     delay(d);
     if key=$4D then inc(x,1);           { Right Arrow }
     if key=$4B then dec(x,1);           { Left Arrow  }
     if key=$50 then inc(y,1);           { Down Arrow  }
     if key=$48 then dec(y,1);           { Up Arrow    }
     Draw_barney(x,y,Bcolor);
     Checklevel;
     Writepoints;
     Checkmission;
     inc(counter); if (counter>3) then Checksteps;
     if (old_i<>i) then Missions(i);
     if i=100 then goto Again;
  until (port[$60]=1) or (death=1);

  Cls(0);dispose(font); new(font);
  assign(f,'c:\krush\kru$h.fnt');reset(f,1);
  blockread(f,font^,25600);
  close(f);
  texty(20,010,'So you''ve done it again,');
  texty(20,020,'killed Barney. I hope you');
  texty(20,030,'are happy, because Barney');
  texty(20,040,'   definately isn''t !   ');
  texty(20,060,'Better try again, or you ');
  texty(20,070,'might wake up one morning');
  texty(20,080,' and realize that Barney ');
  texty(20,090,' bit your head off last  ');
  texty(20,100,'         night !!!       ');
  SetCube; virseg := seg(syk1^); Fillchar(mem[virseg:0],64000,0);
  key:=0; i:=0;
  repeat
    Rotatepoints(x,y,z); Drawpoints; for i:=0 to 56 do
    move(mem[virseg:37120+320*i],mem[virseg:37220+320*i],100);
    move(mem[virseg:37000],mem[$A000:37085],19000);
    Fillchar(mem[virseg:0],64000,0);
    if x<360 then inc(x,1) else x:=0;
    if y<360 then inc(y,3) else y:=0;
    if z<360 then inc(z,1) else z:=0;
    inc(i);
    if i=220 then texty(20,180,'      I''m Serious ...   ');
  until key=$39;

Again:

  Cls(0);
  texty(20,80, 'Press Space for a new game,');
  texty(20,95, 'or ESC if you want to quit.');
  key:=0; repeat until (key=$01) or (key=$39);
  if key=$39 then begin
  Dispose(font);Dispose(pal);
  Dispose(syk1);Dispose(syk2);Dispose(syk3);
  goto Play_Again end else begin
    texty(20,115,'       YOU CHICKEN !       ');
    delay(1500);
  end;
  Screenmode($3); SetIntVec(9,BIOSkeyb); Dispose(font);
  Dispose(pal);Dispose(syk1);Dispose(syk2);Dispose(syk3);
  textcolor(cyan); writeln('Oh, I almost forgot...');
  writeln('All characters, places and events described in this game are fictional');
  writeln('Any relation to real people, schools or events is pure coincidence');
  writeln;
  writeln('If playing this game causes you to develop insomnia, or causes your');
  writeln('fern to grow seven feet tall and devour you while you are sleeping,');
  writeln('or makes you get an irresistable urge to mutate into a Mesopotamian');
  writeln('purplish Aquatic Slug, then that is also totally coincidental.'); writeln;
  writeln('So don''t blame me!                       Enjoy, Krush 95');
end.