Unit Krush2;

Interface
uses dos;

type palname     =  array [0..255,0..2] of byte;
     virtua      =  array[0..64000] of byte;
     virpnt      =  ^virtua;

var  Scr_Ofs     :  Array[0..199] of Word;
     fseg, fofs  :  word;
     virscr      :  virpnt;
     virseg      :  word;


procedure screenmode (mode:byte);
procedure svgamode (svga:word);
procedure retrace;
procedure putpixel (X,Y : Integer; Col : Byte; where:word);
function  Getpixel (X,Y : Integer; where:word):byte;
procedure fetch_text (ftype:word);
procedure setcolor (color, red, green, blue : byte);
procedure getcolor (color:byte; var red, green, blue : byte);
procedure cls (color : byte);
procedure textit (x,y:word ; txt:string ; height,lenght,shadow,color,dither:byte ; on:boolean);
procedure text1 (x,y:word;txt:string;width,height:word;font:array of byte);
procedure line (x1,y1,x2,y2:word ; col:byte; where:word);
procedure Hline (x1,x2,y:word;col:byte;where:word);
procedure DrawPoly(x1,y1,x2,y2,x3,y3,x4,y4:integer;color:byte;where:word);
procedure Circle (x,y,rad:integer;Col:Byte);
procedure loadpcx(filename:string; paletteptr, gfxdataptr:pointer);

{procedure V_Setup;                               { ...      }
{procedure V_Free;                                { ...      }
{procedure V_Flip (source,dest:word);             { For the  }
{procedure V_Putpixel (x,y,color,virseg:word);    { virtual  }
{procedure V_Cls (virseg:word ; color:byte);      { screen.  }
{function  V_GetPixel (x,y,virseg : word) : byte; { ...      }

function  rad (angledeg: real) : real;
function  keypressed : boolean;


Implementation


Procedure ScreenMode;    { Set screenmode }
Begin
  Asm
    Mov  AH,00
    Mov  AL,Mode
    Int  10h
  End;
End;


Procedure SVGAmode;      { Set SVGA-mode }
begin
  asm
    Mov  AX,4F02h
    Mov  BX,svga
    Int  10h
  end;
end;


procedure retrace; assembler;   { Wait for a vertical retrace. }
asm
        Mov  DX,3DAh;
@WAIT1: In   AL,DX;
        Test AL,8;
        Jz   @WAIT1
@RETR2: In   AL,DX;
        Test AL,8;
        Jnz  @RETR2;
end;


Procedure Putpixel (X,Y : Integer; Col : Byte; where:word); assembler;
asm
   mov  ax,where
   mov  es,ax
   mov  bx,[y]
   shl  bx,1
   mov  di,word ptr [Scr_Ofs + bx]
   add  di,[x]
   mov  al,[col]
   mov  es:[di],al
end;


Function Getpixel (X,Y : Integer; where:word):byte; assembler;
asm
   mov  ax,where
   mov  es,ax
   mov  bx,[y]
   shl  bx,1
   mov  di,word ptr [Scr_Ofs + bx]
   add  di,[x]
   mov  al,es:[di]
end;

procedure fetch_text;                     { Get font. }
var regs       : registers;
begin
  with regs do begin
    AX := $1130;
    BH := ftype;
  end;
  Intr($10,regs);
  Fseg := regs.es;
  Fofs := regs.bp;
end;


procedure Setcolor;                       { Setcolor }
Begin
  Port[$3C8] := Color;
  Port[$3C9] := Red;
  Port[$3C9] := Green;
  Port[$3C9] := Blue;
End;


Procedure Getcolor;                       { Getcolor }
Begin
   Port[$3c7] := Color;    { This procedure reads the values of    }
   Red   := Port[$3c9];    { Red, Green & Blue for a certain color }
   Green := Port[$3c9];    { from the [$3c9] port.                 }
   Blue  := Port[$3c9];
End;

{ Stores current palette to pal1.                                    }
{ Procedure StorePal;                                                }
{ var color : word;                                                  }
{ begin                                                              }
{  for color:=0 to 255 do                                            }
{    Getcolor (color,pal1[color,0],pal1[color,1],pal1[color,2]);     }
{  end;                                                              }
{                                                                    }

procedure Cls;       { Clear screen. }
begin
  FillChar(mem[$A000:0000],64000,color);
end;


procedure Textit;    { Text. }
var q,w,e:byte;
begin
  for q:=1 to length(txt) do
   for w:=0 to height {7 or 15} do
    for e:=0 to lenght {7} do
     if ((mem[fseg:fofs+w+(ord(txt[q])*(height+1))] shl e) and 128) <> 0 then
     begin
      if on=true then mem[$a000:(y+w+1)*320+(q*8)+x+e+1]:=shadow; { Shadow }
      mem[$A000:(y+w)*320+(q*8)+x+e]:= color+random(dither);      { Text   }
     end;
end;


procedure Text1 (x,y:word;txt:string;width,height:word;font:array of byte);
var q,w,e:byte;
begin
  for q:=0 to length(txt) do
   for w:=0 to height do
    for e:=0 to width do
     mem[$A000:320*y+q*width+w*320+e+x] := font[ord(txt[q])*height*width+w+e*height];
end;


procedure line; assembler;       {  Draws a line.                }
var ddx,ddy : word;
    sx,sy : word;                {  This procedure has not been  }
asm                              {  made by me... It came from   }
        mov     ax,where         {  some nameless source.        }
        mov     es,ax
        mov     ax,[y1]
        mov     bx,320
        imul    bx
        mov     di,[x1]
        add     di,ax
        mov     ax,[x2]
        clc
        mov     bx,1
        sub     ax,[x1]
        jnc     @@1
        neg     ax
        mov     bx,0ffffh
@@1:    mov     [ddx],ax
        mov     [sx],bx
        mov     ax,[y2]
        clc
        mov     bx,320
        sub     ax,[y1]
        jnc     @@2
        neg     ax
        mov     bx,-320
@@2:    mov     [ddy],ax
        mov     [sy],bx

        cmp     ax,[ddx]
        ja      @@yGrtr
        mov     cx,[ddx]
        inc     cx
        mov     bx,[ddx]
        shr     bx,1
        mov     al,[col]
@@x1:   mov     byte ptr [es:di],al
        add     di,[sx]
        clc
        sub     bx,[ddy]
        jnc     @@xg
        add     di,[sy]
        add     bx,[ddx]
@@xg:   loop    @@x1
        jmp     @@ret
@@yGrtr:mov     cx,[ddy]
        inc     cx
        mov     bx,[ddy]
        shr     bx,1
        mov     al,[col]
@@y1:   mov     byte ptr [es:di],al
        add     di,[sy]
        clc
        sub     bx,[ddx]
        jnc     @@yg
        add     di,[sx]
        add     bx,[ddy]
@@yg:   loop    @@y1
@@ret:
end;


Procedure Hline; assembler;   { Horizontal Line }
asm
  mov   ax,where
  mov   es,ax
  mov   ax,y
  mov   di,ax
  shl   ax,8
  shl   di,6
  add   di,ax
  add   di,x1

  mov   al,col
  mov   ah,al
  mov   cx,x2
  sub   cx,x1
  shr   cx,1
  jnc   @start
  stosb
@Start :
  rep   stosw
end;

Procedure DrawPoly;
var
  x:integer; mny,mxy:integer; mnx,mxx,yc:integer;
  mul1,div1, mul2,div2, mul3,div3, mul4,div4:integer;

begin
  mny:=y1; mxy:=y1;
  if y2<mny then mny:=y2;
  if y2>mxy then mxy:=y2;
  if y3<mny then mny:=y3;
  if y3>mxy then mxy:=y3;    { Choose the min y mny and max y mxy }
  if y4<mny then mny:=y4;
  if y4>mxy then mxy:=y4;

  if mny<0 then mny:=0;
  if mxy>199 then mxy:=199;
  if mny>199 then exit;
  if mxy<0 then exit;        { Verticle range checking }

  mul1:=x1-x4; div1:=y1-y4;
  mul2:=x2-x1; div2:=y2-y1;
  mul3:=x3-x2; div3:=y3-y2;
  mul4:=x4-x3; div4:=y4-y3;  { Constansts needed for intersection calc }

  for yc:=mny to mxy do begin

    mnx:=320; mxx:=-1;

    if (y4>=yc) or (y1>=yc) then
      if (y4<=yc) or (y1<=yc) then     { Check that yc is between y1 and y4 }
        if not(y4=y1) then begin
          x:=(yc-y4)*mul1 div div1+x4; { Point of intersection on x axis    }
          if x<mnx then mnx:=x;
          if x>mxx then mxx:=x;  { Set point as start or end of horiz line  }
        end;
    if (y1>=yc) or (y2>=yc) then
      if (y1<=yc) or (y2<=yc) then     { Check that yc is between y1 and y2 }
        if not(y1=y2) then begin
          x:=(yc-y1)*mul2 div div2+x1; { Point of intersection on x axis    }
          if x<mnx then mnx:=x;
          if x>mxx then mxx:=x;  { Set point as start or end of horiz line  }
        end;
    if (y2>=yc) or (y3>=yc) then
      if (y2<=yc) or (y3<=yc) then     { Check that yc is between y2 and y3 }
        if not(y2=y3) then begin
          x:=(yc-y2)*mul3 div div3+x2; { Point of intersection on x axis    }
          if x<mnx then mnx:=x;
          if x>mxx then mxx:=x;  { Set point as start or end of horiz line  }
        end;
    if (y3>=yc) or (y4>=yc) then
      if (y3<=yc) or (y4<=yc) then     { Check that yc is between y3 and y4 }
        if not(y3=y4) then begin
          x:=(yc-y3)*mul4 div div4+x3; { Point of intersection on x axis    }
          if x<mnx then mnx:=x;
          if x>mxx then mxx:=x;  { Set point as start or end of horiz line  }
        end;
   if mnx<0 then mnx:=0;
   if mxx>319 then mxx:=317;  { Range checking on horizontal line        }
   if mnx<=mxx then hline (mnx,mxx+1,yc,color,where);{ Draw the horizontal line }
  end;
end;




procedure circle;             { Draws a circle                       }
var deg:real;
    x1,y1,x2,y2 : longint;    { Weird things happen when the circle  }
begin                         { goes over the borders of the screen. }
  y2:= x+(y*320);             { eg. KRU$H10.PAS                      }

  deg:=0;
  repeat
    x1:=round(rad*cos (deg));
    y1:=round(rad*sin (deg));
    mem[$A000:y2+(y1*320)+x1] := col;
    deg:=deg+0.005;
  until (deg>6.4);
end;

procedure LOADPCX(filename:string;paletteptr,gfxdataptr:pointer);

{ 24/2/95 11:10 PCX loader routine written by Zorlim (Sami Lehtinen)
  E-Mail: Zorlim@freenet.hut.fi (All questions are welcome)
  PLEASE NOTIFY!
  1) This routine decodes only "normal" (type 5) pcx pictures, with
     resolution 320*200!
  2) If your .pcx file is bigger than 64000 bytes this routine will mess up
     end of picture and palette. (coz input buffer is only 64000 bytes)
     Reason why there is size limit was that I wanted just do as simple
     pcx decoder as possible.                                            }
type
  tdata=array[0..$F9FF] of byte; {Data type}
  tpal=array[0..$2FF] of byte;   {Palette type}
var
 dfile:file; {Data file}
 {Position meters}  ibp:word;  {Input data position meter}
 {Decoding}         rc:byte;   {Repeat count counter}
 {Scanline thigns}  sls:word;  {How much data is already decoded}
                    slp:word;  {Position on scanline being to processed}
 {Buffers}          ibf:^tdata; {Input buffer}
                    obf:^tdata; {Output buffer}
 {Palette things}   pal:^tpal;  {Array for palette values}
                    plp:byte;   {Palette position, used when decoding}
begin {Begin of LOADPCX procedure}
  {Set up} new(ibf);               {Get memory for input buffer}
           obf:=gfxdataptr;        {Locate output to given memory address}
           pal:=paletteptr;        {Locate palette to given memory address}
  {Loading stuff}
           assign(dfile,filename); {Open data file}
           reset(dfile,1);         {Reset datafile}
           blockread(dfile,ibf^,$80); {Discard header}
           blockread(dfile,ibf^,filesize(dfile)-$80); {Read data from file}
           close(dfile); {Close file, if you didnt figure that out}
  {Decode PCX image} ibp:=0;  {Set input pointer to 0}
                     sls:=0;  {Set amout of data decoded to zere}

  while sls<$FA00 do begin {Repeat decoding until whole picture is decoded}
    slp:=0; {Reset amount decoded for this gfx line}
    while slp<$140 do begin {Decode all pixels for one gfx line}
      if (ibf^[ibp] and $C0)=$C0 then begin {Determinate if data is compressed}
        {Data is compressed so it must be expanded}
        fillchar(obf^[sls+slp],ibf^[ibp] and $3F,ibf^[ibp+1]); {Move data to it's position}
        inc(slp,ibf^[ibp] and $3F); {Advance amount decoded of this line}
        inc(ibp,2); {Advance input buffer position}
      end else begin
        {And if data is NOT compressed}
        obf^[sls+slp]:=ibf^[ibp]; {Just move data from input to output}
        inc(slp); {Advance amount decoded of this line}
        inc(ibp); {Adanvce input buffer position}
      end;
    end;
    inc(sls,$140); {Advance gfx line to be decoded}
  end;
  {End of image decoding}
  {Get the damn palette}
  inc(ibp); {Advance input buffer position to start of the palette}
  for plp:=0 to $FF do begin {Decode all colors}
    pal^[plp*3+0]:=ibf^[ibp+plp*3+0] shr 2; {Get red   value of color and divide it with 4}
    pal^[plp*3+1]:=ibf^[ibp+plp*3+1] shr 2; {Get green value of color and divide it with 4}
    pal^[plp*3+2]:=ibf^[ibp+plp*3+2] shr 2; {Get blue  value of color and divide it with 4}
  end;
  {End of palette loading}
  dispose(ibf); {Dump input data buffer out}
end; {End of LOADPCX procedure}


{
Procedure V_Setup;
begin
  GetMem (VirScr,64000);
  virseg := seg (virscr^);
end;

Procedure V_Free;
begin
  FreeMem (VirScr,64000);
END;

procedure V_Flip(source,dest:Word);
begin
  asm
    push    ds
    mov     ax, [Dest]
    mov     es, ax
    mov     ax, [Source]
    mov     ds, ax
    xor     si, si
    xor     di, di
    mov     cx, 32000
    rep     movsw
    pop     ds
  end;
end;
{ Flip virtual screen on normal screen
{ or vice versa.

{ Put a pixel on the virtual screen.
procedure V_Putpixel;
begin
  mem[virseg:(320*y)+x] := color;
end;

{ Clear virtual screen
procedure V_Cls;
begin
  Fillchar(mem[virseg:0],64000,color);
end;

function V_getpixel;
begin
  V_getpixel := mem[virseg:(y*320)+x];
end;
}

function rad;             { Convert deg. to rad.                 }
begin
  rad := angledeg * pi / 180;
end;

function keypressed; assembler;
asm
  mov ah,0bh;
  int 21h;
  and al,0feh;
end;

var l:integer;

begin
  for L := 0 to 199 do Scr_Ofs[L] := (L * 320);
end.
