program StarField;
uses krush2,crt;

{  This program creates a random 2D starfield, which   }
{  it then scrolls from left to right. What makes      }
{  this program look neat is the fact that the star-   }
{  field doesn't repeat itself, and there are many     }
{  different speeds (or distances in 3D.) -KrusH -95   }


const   maxstars = 100;             { Easy to change...   }
type    stardata = record
                    X,Y    : word;  { X and Y coordinates }
                    Sp,Os  : byte;  { Speed, OldSpeed     }
                    C      : byte;  { Color               }
                   end;

var     star     : array[0..maxstars] of stardata;
        i,d      : integer;
        ch       : char;


procedure Set_Stars;             { Set first co-ordinates }
begin
  randomize;
  for i:=0 to maxstars do begin
    star[i].X := random(320);    { First X-coordinate     }
    star[i].Y := random(180);    { First Y-coordinate     }
    star[i].Sp:= random(10);     { Speed                  }
    star[i].Os:= star[i].Sp;     { Saved Speed            }
    star[i].C := random(63);     { Star Color             }
  end;
end;                             { The higher the Sp & Os }
                                 { the slower the star.   }

procedure Move_Stars;
begin
  For i:=0 to maxstars do begin
    If (star[i].Sp) > 0 then dec(star[i].Sp) else begin

      If star[i].X =319 then begin   { So... If Speed is not zero, decrease }
        PutPixel(319,star[i].Y,0);   { speed by one and skip to next star.  }
        star[i].X :=1;               { If speed is zero: increase X by one  }
        star[i].Y :=random(180);     { and draw new star, erase old one.    }
        star[i].C :=random(63);      { ...Unless X=319, in which case make  }
        star[i].Sp:=random(10);      { new random Y-coordinate, color and   }
        star[i].Os:=Star[i].Sp;      { speed and set X as 1.                }
      end;

      PutPixel(star[i].X,star[i].Y,0);
      Inc(star[i].X);
      PutPixel(star[i].X,star[i].Y,star[i].C);
      star[i].Sp := star[i].Os;      { Restore the speed.                   }
    end;
  end;
end;


begin
  d:=3; Screenmode($13); Fetch_text($3);
  for i:=0 to 63 do setcolor(i,0,i,i);
  Textit(20,180,'Starfield by KrusH',7,7,40,60,3,true);
  Textit(180,190,'[+] [-] [ESC]',7,7,40,60,3,true);
  Set_Stars;
  repeat
    Move_Stars;
    delay(d);
    while keypressed or (d>=8) do begin
      ch:=readkey;
      if (ch='+') and (d>=1) then dec(d);
      if (ch='-') and (d<=7) then inc(d);
    end;
  until port[$60]=1;
  textmode(lastmode);
end.
