program fractals;
uses crt, krush2;
type   palname = array[0..255,0..2] of byte;

{  MandelBrot set.                     }
{  With color-cycling.                 }
{                           KrusH 95   }

const  xmin = -2.2;   {-2.2;}       { Try different }
       xmax = 2.0;    {2.0; }       { variations of }
       ymin = -2;     {-2;  }       { these values. }
       ymax = 2.1;    {2;   }

       cnt  = 15;     { Accuracy of colors }
       px   = 320;    { Total X of screen. }
       py   = 200;    { Total Y of screen. }

var x,y,xx,yy,xm,ym,chk,step        : real;
    qw,qr                           : integer;
    i,c                             : longint;
    pal1                            : palname;
    ch                              : char;

procedure Setcoolstuff;
begin
   For i:=1 to 16 do setcolor(239+i,i*4,0,48-i*3);
   Fetch_text($3);
   Textit(10,177,'Mandelbrot by Kru$H -95',7,7,1,38,0,true);
   Textit(10,187,'Sorry about the awful accuracy...',7,7,1,39,0,true);
end;


procedure Rotate_Palette;
var temp : array[0..2] of byte;
begin
  for i:=0 to 255 do getcolor(i,pal1[i,0],pal1[i,1],pal1[i,2]);
    move(pal1[1,0],temp[0],3);
    move(pal1[2,0],pal1[1,0],255*3);
    move(temp[0],pal1[255,0],3);
    for i:=0 to 255 do setcolor(i,pal1[i,0],pal1[i,1],pal1[i,2]);
end;


procedure Draw_MandelBrot;
begin
   step:= (xmax-xmin)/PX;
{  ymax:= ymin+py*step;      { Optional. Comment out the const-ymax }
   x:=xmin;                  { if you use this.                     }
   while x<=xmax do begin
     y:=ymin;
     while y<=ymax do begin
       xm:=0;
       ym:=0;
       i:=0;
       repeat                           { Here's your }
         inc(i);                        { basic loop  }
         Chk := xm*xm+ym*ym;            { for deter-  }
         if (Chk < 4) then begin        { mining the  }
           xx :=xm;                     { color of    }
           yy :=ym;                     { each pixel. }
           xm := (xx*xx-ym*ym)+x;       { A bit hard  }
           ym := 2*xx*yy+y;             { to follow   }
           if keypressed then exit;     { ... eh?     }
         end;
       until (Chk >= 4) or (i>=cnt);
       if i=cnt then c:=0 else c:=239+(i mod 15);
       qw:= round(20+(x+2)*50);
       qr:= round(2+(y+2)*41.7);
       putpixel(qw,qr,c);
       y:=y+step;
     end;
     x:=x+step;
   end;
end;

begin
   Screenmode($13);
   Setcoolstuff;
   Draw_Mandelbrot;
   readkey;
   repeat
     Rotate_Palette;           { Press [SPACE] to stop the cycling and   }
     delay(40);                { any other key to resume it. [ESC] quits }
     if keypressed then begin
       ch:=readkey;
       if (ch=' ') then repeat until keypressed;
     end;
   until port[$60] = 1;        { The colors can be cycled one-by-one by  }
   textmode(lastmode);         { pressing [SPACE] several times.         }
end.
