program movedot;
uses dos,crt,krush2;

type dotpos = record
                x,y    : word; { X and Y coordinate }
                c,r    : byte; { color and radius   }
                ang    : real; { angle              }
              end;


const maxdots  = 300;
      cx       = 160;
      cy       = 95;

var add          : real;
    scan,asc     : byte;
    dot          : array[0..maxdots] of dotpos;

procedure checkscancode;
begin
  asm
    mov  ax,0h      { Int 16 -> Read keyboard }
    int  16h
    mov  scan,ah
    mov  asc,al
  end;
  if (scan=$4b) and (add>-0.7) then add:=add-0.01; { Left Arrow  }
  if (scan=$4d) and (add< 0.7) then add:=add+0.01; { Right Arrow }
  if (scan=$50) then add:=0;                       { Down Arrow  }
end;


procedure setupdots;
var i : word;
begin
  randomize;
  for i:=1 to 64 do setcolor(i,5,5,i);
  setcolor(65,63,0,5);
  for i:=0 to maxdots do begin
    dot[i].ang := random(360);
    dot[i].c   := random(63);
    dot[i].r   := random(206);
  end;
end;


procedure move_dots;
var i : word;
begin
  for i:=0 to maxdots do begin  { Repeat for all the stars }

    if (dot[i].x>0) and (dot[i].x<320)and (dot[i].y>0)     { Erase old   }
    and (dot[i].y<175) then putpixel(dot[i].X,dot[i].Y,0); { star.       }

    dot[i].X := cx+round(dot[i].r * sin(dot[i].ang));      { Set new     }
    dot[i].Y := cy+round(dot[i].r * cos(dot[i].ang));      { coordinates }

    if (dot[i].x>0) and (dot[i].x<320)and (dot[i].y>0)
    and (dot[i].y<175) then putpixel(dot[i].x,dot[i].y,dot[i].c); { New Star }

    dot[i].ang := dot[i].ang+add;                          { Increase angle }
  end;
end;



begin
  Screenmode($13); Cls(0); add:=0;
  Setupdots; Fetch_text($3);
  Line(0,175,319,175,63);
  Textit(15,179,'Kru$H',7,7,60,65,0,true);
  Textit(140,190,'[arrow keys] [esc]',7,7,60,65,0,true);
  repeat
    Move_dots;
    if keypressed then checkscancode;
  until port[$60]=1;                   { ESC pressed. }
  textmode(lastmode);
end.




