
{******************************************}
{*                                        *}
{* Example for MGCACHEF unit.             *}
{*                                        *}
{* 07-27-95 by Mark Gauthier.             *}
{*                                        *}
{******************************************}

uses mgmisc, mgcachef;

(* procedure call if error occur. *)
procedure error(f:cfileptr);
begin
  { convert dos error number to string and print it }
  writeln('File error code     :',getdoserrormsg(f^.buffile.errcode));
  halt;
end;

var
  f       : cFilePtr; { infile will use dynamic memory.  You can use   }
  fbuf    : pointer;  { file buffer  }
  s       : string;
  result  : word;

begin
  new(f); { allocate file in heap }
  getmem(fbuf, 1024); { get memory for file buffer }

  if (f = nil) or (fbuf = nil) then halt;

  { cCreate and cOpen are similar so only cCreate is use in this example
    NOTE: cache buffer is allocate BEFORE the call this function
    dosen't allocate memory.
  }
  cCreate(f, 'test.dat', 1024, fbuf);
  if f^.buffile.errcode <> mgfilhdl.fsucces then error(f);

  s:='Mark Gauthier';
  result := cWrite(f, @s[1], length(s));
  if f^.buffile.errcode <> mgfilhdl.fsucces then error(f);
  writeln('Number of bytes written = ',result);

  cSeek(f, 0); {seek to start of file}
  if f^.buffile.errcode <> mgfilhdl.fsucces then error(f);

  writeln('is end of file? = ',cEof(f));

  s:='';
  { read a maximum of 4 bytes }
  cRead(f, @s[1], 4);
  s[0]:=#4;
  writeln('First four bytes = ',s);

  writeln;
  writeln('File position = ',cPos(f));

  Writeln('File size = ',cSize(f));

  { cFill & and cFlush are use internaly, but if you do some direct }
  { access to cache buffer you may want to use them. }
  (*
    cFill(infile);
    cFlush(infile);
  *)

  { close file }
  cClose(@f);

  { dispose file buffer }
  freemem(fbuf, 1024);
  dispose(f);

end.

