
{******************************************}
{*                                        *}
{* Example for MGDATE unit.               *}
{*                                        *}
{* 07-27-95 by Mark Gauthier.             *}
{*                                        *}
{******************************************}

uses crt,mgdate;

var
 b       : byte;
 y,m,d   : word;
 i,h,min,
 s,s100  : word;
 date    : longint;
 datet   : datetime;
 str     : string;
 cnt     : countryinfo;

begin

 clrscr;

 SetTime(0,0,0,0); { change time to 0:00:00,00 }
 SetDate(1995, 08, 05); { change date... }

 { Get Simple information }
 writeln('timezone      = ',GetTimeZone);
 writeln('datestring    = ',DateString);
 writeln('timestring    = ',TimeString);
 writeln('day of year   = ',DayOfYear);
 writeln('day of month  = ',DayOfMonth);
 writeln('day of week   = ',DayOfWeek);
 writeln('year number   = ',ThisYear);
 writeln('month number  = ',ThisMonth);
 writeln('hour number   = ',ThisHour);
 writeln('minute number = ',ThisMinute);
 writeln('second number = ',ThisSecond);

 { return yesterday value }
 Yesterday (y, m, d);
 writeln('yesterday was = ',y,'-',m,'-',d);

 { return tomorrow value }
 Tomorrow (y, m, d);
 writeln('tomorrow will be = ',y,'-',m,'-',d);

 { is bixetill year ?? }
 writeln('is this year a bixetill year ?', IsLeapYear (ThisYear));

 d := WkDay (2045, 11, 11);
 writeln('week day in  2045-11-11 will be ',d);

 { Now functions to play with Unix date format }
 writeln;
 date:=TodayInUnix;
 writeln('Today date in unix format = ',date);
 UnixToNormal (date, y, m, d, h, min, s);
 writeln('Today unix convert to normal = ',y,'-',m,'-',d);
 Tomorrow (y, m, d);
 date := NormalToUnix (y, m, d, 0, 0, 0);
 writeln('Tomorrow at midnight will be in Unix format:', date);


 GetTime(datet.hour, datet.min, datet.sec, i);
 GetDate(datet.year, datet.month, datet.day, i);
 packtime (datet, date);

 str := PackToUnixStr(date);
 date := UnixStrToPack(str);

 Unpacktime (date, datet);

 { Get systeme information: loaded from country.sys }
 if getcountryinfo (@cnt) then
 begin
     write('date format = ');
     case cnt.cidateformat of
       0 : writeln('USA');
       1 : writeln('Europe');
       2 : writeln('Japan');
     end;
 end;
 writeln('date using country codes = ',countrydatestr);
 writeln('time using country codes = ',countrytimestr);
 b := getcountrycode (i);
 writeln('country name = ',getcountrycodename (i));


 { Here: gregorian and julian date format. }
 GregorianToJulianDN (1995, 02, 10, date);
 writeln('1995-01-01 in JulianDay = ',date);
 JulianDNToGregorian (date, datet.year, datet.month, datet.day);
 GregorianToJulianDate (95, 03, 07, i);
 writeln('1995-01-01 in JulianDate = ',i);
 JulianToGregorianDate (i, 95, datet.month, datet.day);

end.
