
{******************************************}
{*                                        *}
{* Example for MGLIST unit.               *}
{*                                        *}
{* 07-27-95 by Mark Gauthier.             *}
{*                                        *}
{******************************************}

uses mglist;

type
   { Element use in list... }
   Element = record
     name : string[15];
     age  : byte;
   end;

var
 lst : lstptr;
 e   : element;

begin

 lstinit(lst); { Initalize list variable }

 { Add element at end of list }
 e.name := 'eric';
 if not lstaddend (lst, sizeof(element), @e, true) then
 begin
  write('...');
  halt;
 end;

 writeln('is lst empty? ',lstempty (lst));

 { add mark after current (eric) }
 e.name := 'mark';
 if not lstaddafter (lst, sizeof(element), @e, false) then
 begin
  write('element not insert');
  halt;
 end;

 { add list before current (still eric) }
 e.name := 'lise';
 if not lstaddbefore (lst, sizeof(element), @e, false) then
 begin
  write('element not insert');
  halt;
 end;

 { add first and change current pointer on this element }
 e.name := 'first element';
 if not lstaddstart (lst, sizeof(element), @e, true) then
 begin
  write('element not insert');
  halt;
 end;

 { now we have first, lise, eric, mark }

 repeat { we should be at start (but to be sure) }
 until not lstseekprev(lst); { seek to first element }

 if not lstempty(lst) then
 begin
   repeat
      writeln(element(lst^.curentobj^.address^).name);
   until not lstseeknext (lst);
 end;

 writeln('Delete curent element');
 lstdelete(lst); {curent element}

 writeln;
 writeln('new curent = ',element(lst^.curentobj^.address^).name);

 write('changing size:');
 if not lstchangesize (lst, 3) then
    writeln ('failed')
 else
    writeln('succes new curent size = ',lst^.curentobj^.size);


 { Deinit list (free memory) }
 lstdone (lst);

end.
