
{******************************************}
{*                                        *}
{* Example for MGMOUSE unit.              *}
{*                                        *}
{* 07-27-95 by Mark Gauthier.             *}
{*                                        *}
{******************************************}

uses crt, mggraph, mgmouse, mgkeyb;

var

 LeftButton,
 RightButton    : boolean;
 key            : word;
 left_button,
 right_button,
 middle_button  : byte;
 y,x,i          : word;
 version        : word;
 mtype,
 interup        : byte;

{$S-} (* This is a mouse handler *)
procedure MHandler;far;assembler;
asm
  push  ds
  mov   dx,SEG @DATA
  mov   ds,dx
  mov   bx,ax
  shr   bl,1
  and   bl,00000001b
  mov   LeftButton,bl
  mov   cl,3
  shr   al,cl
  and   al,00000010b
  mov   RightButton,al
  pop   ds
end;
{$S+}

begin

   { Initialize mouse driver }
   if not minit then
   begin
     writeln('no mouse driver found');
     halt;
   end;

   { msetlanguage (langue: word); }
   { mgetlanguage: word; }

   mgetinfo (version, mtype, interup);

   { mtype: mouse type 1=bus, 2=serial, 3=inport, 4=PS/2, 5=HP }
   if mtype = 03 then msetintrrate (10);

   writeln('Load as driver rather than TSR = ',mgetdrvinfo and $8000 <> 0);
   { bit(s) description
     15     driver loaded as device driver rather than tsr
     14     driver is newer integrated type
     13,12  current cursor type
     00 software text cursor
     01 hardware text cursor (crt controller's cursor)
     1x graphics cursor
     11-8   interrupt rate (see ax=001ch)
     7-0    count of currently-active m display drivers (mdd), the newer
     integrated driver type
   }

   { Install new handler }
   mseteventhandler (127, @MHandler);

   clrscr;
   repeat
     gotoxy(1,1);
     writeln('Left pressed  :',LeftButton);
     writeln('Right pressed :',RightButton);
   until iskeypressed;
   key := getkey;

  {mswapeventhandler (mask, @AnotherHandler);}

  { restore default handler }
  minstalldefaulthandler ($7F);

  writeln('show mouse press a key to quit');
  mshow;
  repeat
    gotoxy(1,25);
    write(mgetx, '-', mgety,'     ');
  until iskeypressed;
  key := getkey;

  { save mouse status }
  msave;

  { clear screen }
  clrscr;

  gotoxy(1,1);
  write('goto 10,10');
  msetcursor (10,10);
  repeat until iskeypressed; key := getkey;

  gotoxy(1,1); write('goto 100,100');
  msetcursor (100,100);
  repeat until iskeypressed; key := getkey;

  gotoxy(1,1); write('restore     ');
  mrestore;
  repeat until iskeypressed; key := getkey;

  gotoxy(1,1); write('hide        ');
  mhide;
  repeat until iskeypressed; key := getkey;

  clrscr;
  mshow;
  repeat
        if mbuttonpressed then
        begin {test right and left}
           gotoxy(1,1);
           {at least one is up}
           writeln('button right was pressed # of times = ',mbuttonpresses (bright));
           writeln('button left was pressed # of times  = ',mbuttonpresses (bleft));
           write('position = ');
           write(mlastxpress (bleft));
           writeln(',',mlastypress (bright));
        end;

        if mbuttonreleased then
        begin
           gotoxy(1,5);
           writeln('button left was release # of times  = ',mbuttonreleases (bleft));
           writeln('button right was release # of times = ',mbuttonreleases (bright));
           write('position = ');
           write(mlastxrelease (bleft));
           writeln(',',mlastyrelease (bright));
        end;

        gotoxy(1,10);
        case mrecentxmovement of
          0: begin {writeln('none');} end;
          1..maxint: writeln('move x direction = right');
          else writeln('move x direction = left ');
        end;

        gotoxy(1,11);
        case mrecentymovement of
          0: begin {writeln('none');} end;
          1..maxint  : writeln('move y direction = down');
          else writeln('move y direction = up  ');
        end;

  until iskeypressed;
  key := getkey;

  clrscr;
  repeat
     mgetlastevent (x, y, left_button, right_button, middle_button);
     gotoxy(1,1);
     writeln('last event:');
     writeln('position:',x,'-',y,'  ');
     writeln('Left status  :',left_button);
     writeln('Right status :',right_button);
  until iskeypressed;
  key := getkey;

  mdefinesensetivity (8, 8);

  msetcursor(250,75);
  mbox (200,50,400,100);
  repeat
  until iskeypressed;
  key := getkey;

  msetcursor(250,75);
  msethidecursorbox (200,50,400,100);
  repeat
  until iskeypressed;
  key := getkey;

  mshow;
  mbox (0,0,692,200);

  clrscr;
  writeln('hardware cursor');
  mhardwaretextcursor (3,7);
  repeat until iskeypressed;
  key := getkey;

  gotoxy(1,1);
  mhide;
  fillchar(ptr($b800,0)^, 4000, #15);
  writeln('software cursor                                          ');
  msoftwaretextcursor ($0a, $0a);
  repeat until iskeypressed; key := getkey;

  {menablelightpenemulation;
  mdisablelightpenemulation;}

  clrscr;
  writeln('change double speed to 100');
  mdefinedoublespeedtreshhold (100);
  repeat until iskeypressed; key := getkey;

  {mdisabletreshhold;}

  clrscr;
  writeln('change double speed to default');
  mdefaulttreshhold;

  {mgetlcdlargep (var style: byte; size: byte; thres: byte; activeflg: boolean; delay: word);}
  {msetlcdlargep (style: byte; size: byte; thres: byte; activeflg: boolean; delay: word);}

  {msetpage (page: byte);}
  {writeln ('mouse page = ',mgetpage);}

end.
