
{******************************************}
{*                                        *}
{* Example for MGSTACKD unit.             *}
{*                                        *}
{* 07-27-95 by Mark Gauthier.             *}
{*                                        *}
{******************************************}

uses mgstackd;

var
 dynamicStack : stackdptr;
 i            : word;

begin

  new(dynamicstack);

  { create a dynamic stack of word }
  stackdinit(DynamicStack, sizeof(word));

  { store elements on stack }
  i := 5;
  stackdpush (DynamicStack, @i);
  i := 25;
  stackdpush (DynamicStack, @i);

  writeln('is stack empty?', stackdempty (dynamicstack));

  { Get element from stack }
  stackdpeek (Dynamicstack, @i);
  writeln('peek = ',i);

  stackdpop (Dynamicstack, @i);
  writeln('pop = ',i);

  { Clear stack }
  writeln('clearing stack');
  stackdclear (Dynamicstack);

  { get element from stack }
  stackdpop (Dynamicstack, @i);
  if dynamicstack^.error <> 0 then
    writeln('error: stack is empty can''t pop.');

  { Clear element in stack }
  stackddone (DynamicStack);

  { dispose stack variable }
  dispose(dynamicstack);

end.
