
{******************************************}
{*                                        *}
{* Example for MGSTRING unit.             *}
{*                                        *}
{* 07-27-95 by Mark Gauthier.             *}
{*                                        *}
{******************************************}


uses mgstring;

var
 s,s2   : string;
 c      : char;
 xtable : array[0..255] of char;
 i      : word;

const
 null:array[1..5] of char = ('M','a','r','k',#0);
 strarray : array[0..5] of string = (
  '', (* first is blank *)
  'hi',
  'hello',
  'mark',
  'gauthier',
  'this');

begin

 { Test Upper/Lower character functions }
 c:=upch('a');
 s:='mark gauthIer';
 s:=upcstr(s);
 c:=lwch('a');
 s:='maRK gauthIer';
 s:=lwcstr(s);

 { Null to Pascal and Pascal to Null }
 s := Null2Pascal(@null);
 s:='Test';
 Pascal2Null(s, @null);

 s2:=' Allo';
 addstr(s, s2);

 writeln('Word in s = ',wordcount(s));

 { write part of string s }
 writeln(stringof(s, 10));

 writeln(searchstring(s, 'Allo', 1));

 { Pad functions }
 padright(s2, '!', 25);
 writeln(s2);
 padleft(s2, '~', 50);
 padbooth(s2, '$', 75);
 padpos(s2, '#', 2, 77);

 overwrite(s2, ' Insert ', 10);

 xchgchar(s2, '$','%');

 deleteright(s2, '%');
 deleteleft(s2,'%');

 deletech(s2, '#');

 s := Remove(s2, 'Insert',1);

 s := Precede(s2, 'Insert',1);
 s := Follow (s2, 'Insert',1);

  sortstr (@StrArray, 5);
 sortstrdec (@StrArray, 5);

 for i:= 0 to 255 do xtable[i] := char(i+1);

 s2:='Hi Mark';
 s:=txlat(s2, @xtable);

end.
