{ Mouse unit version 1.00 for Pascal! Written by: Tero Airasjrvi 24.09.1995 }

unit m_unit;

interface

{ procedures... }
procedure getsoftware(var ver: string; var mtype, intr: byte); { get software}
procedure mousewindow(x1, y1, x2, y2: word); { set window to mouse           }
procedure setmousepixelratio(x, y: word);{ set mickey/pixel ratio for mouse  }
procedure getmousespeed(var x, y: word); { get mouse speed                   }
procedure setmousespeed(x, y: word);     { set mouse speed                   }
procedure setmousexy(x, y: word);        { change mouse position             }
procedure setlanguage(lan: word);        { set language for messages         }
procedure showmouse;                     { show mouse on screen              }
procedure hidemouse;                     { hide mouse at screen              }
procedure setlightpenemulation_off;      { setlight pen emulation off        }
procedure setlightpenemulation_on;       { setlight pen emulation on         }
{ !! setlanguage -is avaible ONLY internatiol version of mouse driver !! }

{ functions... }
function resetmouse(var buttons: byte): boolean; { reset mouse and get numer of buttons }
function driverinstalled: boolean;       { is mouse driver installed         }
function textpos(w: word): word;         { translate mouse position to ...   }
function mousebut_1: boolean;            { get left button status            }
function mousebut_2: boolean;            { get right button status           }
function getlanguage: word;              { get language for messages         }
function mouse_x: word;                  { get mouse horizontal position     }
function mouse_y: word;                  { get mouse vertical position       }

const
  languagenames: array[0..8] of string[10] = (
    'English',
    'French',
    'Dutch',
    'German',
    'Swedish',
    'Finnish',
    'Spanish',
    'Portugese',
    'Italian'
  );
  strbuttons: array[2..4] of string[30] = (
    'Two buttons',
    'Other than two buttons',
    'Mouse systems / Logitech mouse'
  );
  mousetypestr: array[1..5] of string[30] = (
    'Bus',
    'Serial',
    'Inport',
    'PS/2',
    'HP'
  );
  english = 0;   { language numbers }
  french = 1;
  dutch = 2;
  german = 3;
  swedish = 4;
  finnish = 5;
  spanish = 6;
  portugese = 7;
  italian = 8;

var
  xshift, yshift: byte;

implementation

procedure showmouse; assembler;
asm
  mov ax, 1h
  int 33h
end;

procedure hidemouse; assembler;
asm
  mov ax, 2h
  int 33h
end;

function mouse_x: word; assembler;
asm
  mov ax, 0003h
  int 33h
  mov ax, cx
end;

function mouse_y: word; assembler;
asm
  mov ax, 0003h
  int 33h
  mov ax, dx
end;

function mousebut_1: boolean; assembler;
asm
  mov ax, 0003h
  int 33h
  and bx, 01h
  mov ax, bx
end;

function mousebut_2: boolean; assembler;
asm
  mov ax, 0003h
  int 33h
  and bx, 02h
  mov ax, bx
end;

procedure setmousexy(x, y: word);
begin
  dec(x);
  dec(y);
  x:= x shl xshift;
  y:= y shl yshift;
  asm
    mov ax, 0004h
    mov cx, x
    mov dx, y
    int 33h
  end;
end;

procedure getmousespeed(var x, y: word);

var
  x1, y1: word;

begin
  asm
    mov ax, 001Bh
    int 33h
    mov x1, dx
    mov y1, cx
  end;
  x:= x1;
  y:= y1;
end;

procedure setmousespeed(x, y: word); assembler;
asm
  mov ax, 001Ah
  mov dx, x
  mov cx, y
  int 33h
end;

procedure setmousepixelratio(x, y: word); assembler;
asm
  mov ax, 000Fh
  mov cx, x  { normal in text mode is: x = 8 and y = 16 }
  mov dx, y
  int 33h
end;

procedure setlanguage(lan: word); assembler;
asm
  mov ax, 0022h
  mov bx, lan
  int 33h
end;

function getlanguage: word; assembler;
asm
  mov ax, 0023h
  int 33h
  mov ax, bx
end;

function textpos(w: word): word;
begin
  textpos:= w div 8+1;
end;

function driverinstalled: boolean; assembler;
asm
  mov ax, 0021h
  int 33h
  and ax, $FFFF
end;

function resetmouse(var buttons: byte): boolean;

var
  ok: boolean;
  b, w: word;

begin
  asm
    mov ax, 0000h
    int 33h
    mov b, bx
    mov w, ax
  end;
  ok:= true;
  if w = 0 then
    ok:= false;
  if b = $FFFF then buttons:= 2;
  if b = $0000 then buttons:= 3;
  if b = $0003 then buttons:= 4;
  resetmouse:= ok;
  if not ok then buttons:= 255;
end;

procedure setlightpenemulation_on; assembler;
asm
  mov ax, 000Dh
  int 33h
end;

procedure setlightpenemulation_off; assembler;
asm
  mov ax, 000Eh
  int 33h
end;

procedure getsoftware(var ver: string; var mtype, intr: byte);

var
  mt, int: byte;
  s: string;
  w: word;

begin
  asm
    mov ax, 0024h
    int 33h
    mov w, bx
    mov mt, ch
    mov int, cl
  end;
  str(hi(w), s);
  ver:= s+'.';
  str(lo(w), s);
  ver:= ver+s;
  mtype:= mt;
  int:= intr;
end;

procedure mousewindow(x1, y1, x2, y2: word);
begin
  dec(x1);
  dec(y1);
  dec(x2);
  dec(y2);
  x1:= x1 shl xshift;
  x2:= x2 shl xshift;
  y1:= y1 shl yshift;
  y2:= y2 shl yshift;
  asm
    mov ax, 0007h
    mov cx, x1
    mov dx, x2
    int 33h
    inc ax
    mov cx, y1
    mov dx, y2
    int 33h
  end;
end;

var
  b: byte;

begin
  asm
    mov ah, 0Fh
    int 10h
    mov b, al
  end;
  case b of
    0, 1, 2, 3, 7: begin
      xshift:= 3;
      yshift:= 3;
    end;
    4, 5, 13, 19: begin
      xshift:= 1;
      yshift:= 0;
    end;
    else begin
      xshift:= 0;
      yshift:= 0;
    end;
  end;
end.