Program XMS_Test;

Uses
    Crt,Dos,XMS_Lib,AsmTools;

Var
    BufHandle : XMS_Handle;
    Buf       : Array[1..2048] of Byte;
    X         : Word;

BEGIN
     WriteLn('XMS Information');
     WriteLn('------------------------------------------------');
     If NOT XMS_Installed then
     BEGIN
          WriteLn('XMS Driver NOT Installed, add HIMEM.SYS to your Config.sys file.');
          Halt(1);
     END;
     WriteLn('Address : $',Word2Hex(XMS_Driver_Address SHR 16),':$',Word2Hex(XMS_Driver_Address));
     Write  ('Version : ',Hi(XMS_Version) AND $7F,'.',Lo(XMS_Version),' ');
     If Hi(XMS_Version) AND $80<>0 then
        WriteLn('(HMA In use)')
     Else
        Writeln('(HMA Not in use)');
     WriteLn('Memory  : ',XMS_MemTotal,' KB Total  (',XMS_MemMaxBlock,' KB Max Block)');
     WriteLn('Handles : ',XMS_HandlesFree,' EMB Handles Free');

     BufHandle:=0;
     BufHandle:=XMS_AllocBlock(2);

     If BufHandle<>0 then
     BEGIN
          WriteLn('Alloc   : ',XMS_HandleSize(BufHandle),' KB allocated');

          { Fill Buffer woth DATA }
          For X:=1 to 2048 do Buf[X]:=X;

          If XMS_MoveTo(@Buf,BufHandle,0,SizeOf(Buf)) then
             WriteLn('Move To : Moved from Buffer into XMS')
          Else
             WriteLn('Move To : Move failed');

          FillChar(Buf,SizeOf(Buf),0);

          If XMS_MoveFrom(BufHandle,@Buf,0,SizeOf(Buf)) then
             WriteLn('Move frm: Moved from XMS into Buffer')
          Else
             WriteLn('Move frm: Move failed');


          If XMS_FreeBlock(BufHandle) then
             WriteLn('Free    : Memory Successfully freed')
          Else
             WriteLn('Free    : Memory NOT successfully freed');
     END Else
          WriteLn('Alloc   : Memory could NOT be allocated');

END.