     TITLE   'LINE ROUTINE FOR MCGA'
     NAME    _LINE
     PAGE    55,132

VARINCR1       EQU   WORD PTR [BP-6]
VARINCR2       EQU   WORD PTR [BP-8]
VAROUTINE      EQU   WORD PTR [BP-10]
ORIGINOFFSET   EQU  0                            ; BYTE OFFSET OF (0,0)
VIDEOBUFFERSEG EQU  0A000H                       ; START OF VIDEOBUFFER

BYTESPERLINE EQU   320

DGROUP     GROUP   DATA

DATA       SEGMENT BYTE PUBLIC 'DATA'
           ASSUME  DS:DATA
           EXTRN   X1:WORD
           EXTRN   Y1:WORD
           EXTRN   X2:WORD
           EXTRN   Y2:WORD
           EXTRN   C:BYTE
           DATA ENDS

CODE       SEGMENT BYTE PUBLIC
           ASSUME  CS:CODE,DS:DGROUP

           PUBLIC  ALINE
ALINE      PROC    NEAR

           PUSH    BP                       ; PRESERVE CALLER REGISTERS
           MOV     BP,SP
           SUB     SP,6                     ; STACK SPACE FOR LOCAL VARIABLES
           PUSH    SI
           PUSH    DI

; CHECK FOR VERTICAL LINE

           MOV     SI,BYTESPERLINE          ; INITIAL Y-INCREMENT

           MOV     CX,X2
           SUB     CX,X1                    ; CX := X2 - X1
           JZ      VERTLINE                 ; JUMP IF VERTICAL LINE

; FORCE X1 < X2
           JNS     LO1                      ; JUMP IF X2 > X1

           NEG     CX                       ; CX := X1 - X2
           MOV     BX,X2                    ; EXCHANGE X1 AND X2
           XCHG    BX,X1
           MOV     X2,BX

           MOV     BX,Y2                    ; EXCHANGE Y1 AND Y2
           XCHG    BX,Y1
           MOV     Y2,BX

; CALCULATE DY := ABS(Y2 - Y1)

LO1:       MOV     BX,Y2
           SUB     BX,Y1                    ; BX := Y2 - Y1
           JZ      HORIZLINE                ; JUMP IF HORIZONTAL LINE
           JNS     LO3                      ; JUMP IF SLOPE IS POSITIVE
           NEG     BX                       ; BX := Y1 - Y2
           NEG     SI                       ; NEGATE Y-INCREMENT

; SELECT APPROPRIATE ROUTINE FOR SLOPE OF LINE

LO3:       PUSH    SI                       ; PRESERVE Y-INCREMENT

           MOV     VAROUTINE,OFFSET LOSLOPELINE
           CMP     BX,CX
           JLE     LO4                      ; JUMP IF DY <= DX
           MOV     VAROUTINE,OFFSET HISLOPELINE
           XCHG    BX,CX

; CALCULATE INITIAL DECISION VARIABLE AND INCREMENTS

LO4:       SHL     BX,1                     ; BX := 0.5 * DY
           MOV     VARINCR1,BX              ; INCR1 := 2 * DY
           SUB     BX,CX
           MOV     SI,BX                    ; SI := D = 2 * DY - DX

           SUB     BX,CX
           MOV     VARINCR2,BX              ; INCR2 := 2 * (DY - DX)

; CALCULATE FIRST PIXEL ADDRESS

           PUSH    CX
           MOV     AX,Y1
           MOV     BX,X1
           XCHG    AH,AL                         ; AX := 256 * Y
           ADD     BX,AX                         ; BX := AX + X
           SHR     AX,1
           SHR     AX,1                          ; AX := 64 * Y
           ADD     BX,AX                         ; BX := 320 * Y + X

           ADD     BX,ORIGINOFFSET               ; BX := BYTE OFFSET IN VBUF

           MOV     AX,VIDEOBUFFERSEG
           MOV     ES,AX                         ; ES:BX := BYTE ADDR IN VBUF
           MOV     DI,BX
           POP     CX
           INC     CX
           POP     BX
           JMP     VAROUTINE

; ROUTINE FOR VERITCAL LINES

VERTLINE:  MOV     AX,Y1
           MOV     BX,Y2
           MOV     CX,BX
           SUB     CX,AX
           JGE     L31                      ; JUMP IF DY >= 0
           NEG     CX
           MOV     AX,BX

L31:       INC     CX
           MOV     BX,X1
           PUSH    CX
           XCHG    AH,AL                         ; AX := 256 * Y
           ADD     BX,AX                         ; BX := AX + X
           SHR     AX,1
           SHR     AX,1                          ; AX := 64 * Y
           ADD     BX,AX                         ; BX := 320 * Y + X

           ADD     BX,ORIGINOFFSET               ; BX := BYTE OFFSET IN VBUF

           MOV     AX,VIDEOBUFFERSEG
           MOV     ES,AX                         ; ES:BX := BYTE ADDR IN VBUF
           POP     CX
           MOV     DI,BX
           DEC     SI                       ; SI := BYTES/LINE - 1
           MOV     AL,C                     ; AL := COLOR

L32:       STOSB                            ; SET PIXEL VALUE IN BUFFER
           ADD     DI,SI
           LOOP    L32

           JMP     LEXIT

; ROUTINE FOR HORIZONTAL LINES

HORIZLINE: PUSH    CX
           MOV     AX,Y1
           MOV     BX,X1
           XCHG    AH,AL                         ; AX := 256 * Y
           ADD     BX,AX                         ; BX := AX + X
           SHR     AX,1
           SHR     AX,1                          ; AX := 64 * Y
           ADD     BX,AX                         ; BX := 320 * Y + X

           ADD     BX,ORIGINOFFSET               ; BX := BYTE OFFSET IN VBUF

           MOV     AX,VIDEOBUFFERSEG
           MOV     ES,AX                         ; ES:BX := BYTE ADDR IN VBUF
           MOV     DI,BX
           POP     CX
           INC     CX
           MOV     AL,C                     ; AL := COLOR
           REP     STOSB                    ; FAST UPDATE TO VIDEO BUFFER
           JMP     SHORT LEXIT

; ROUTINE FOR DY <= DX

LOSLOPELINE:
           MOV     AL,C

L11:       STOSB
           OR      SI,SI                    ; TEST SIGN OF D
           JNS     L12

           ADD     SI,VARINCR1
           LOOP    L11
           JMP     SHORT LEXIT

L12:       ADD     SI,VARINCR2
           ADD     DI,BX
           LOOP    L11
           JMP     SHORT LEXIT

; ROUTINE FOR DY > DX

HISLOPELINE:
           MOV     AL,C

L21:       STOSB

           ADD     DI,BX

L22:       OR      SI,SI
           JNS     L23
           ADD     SI,VARINCR1
           DEC     DI
           LOOP    L21
           JMP     LEXIT

L23:       ADD     SI,VARINCR2
           LOOP    L21

LEXIT:     POP     DI
           POP     SI
           MOV     SP,BP
           POP     BP
           RET     2

           ALINE   ENDP

           CODE ENDS

           END
