     TITLE 'SETPIXEL DEMONSTRATION'
     NAME  _SETPIXEL
     PAGE  55,132

;
; NAME:       SETPIXEL
;
; FUNCTION:   SETPIXEL ( X, Y : INTEGER; C : INTEGER);
;

ORIGINOFFSET   EQU  0                            ; BYTE OFFSET OF (0,0)
VIDEOBUFFERSEG EQU  0A000H                       ; START OF VIDEOBUFFER

DGROUP     GROUP   DATA

DATA       SEGMENT BYTE PUBLIC 'DATA'
           ASSUME  DS:DATA
           EXTRN   X:WORD
           EXTRN   Y:WORD
           EXTRN   C:BYTE
           DATA    ENDS

CODE       SEGMENT BYTE PUBLIC
           ASSUME  CS:CODE,DS:DGROUP

           PUBLIC  SETPIXEL
SETPIXEL   PROC    NEAR

           PUSH    BP                            ; PRESERVE CALLER REGISTERS
           MOV     BP,SP

           MOV     AX,Y                          ; AX := Y
           MOV     BX,X                          ; BX := X

           XCHG    AH,AL                         ; AX := 256 * Y
           ADD     BX,AX                         ; BX := AX + X
           SHR     AX,1
           SHR     AX,1                          ; AX := 64 * Y
           ADD     BX,AX                         ; BX := 320 * Y + X

           ADD     BX,ORIGINOFFSET               ; BX := BYTE OFFSET IN VBUF

           MOV     AX,VIDEOBUFFERSEG
           MOV     ES,AX                         ; ES:BX := BYTE ADDR IN VBUF

           MOV     AL,C                          ; AL := PIXEL VALUE
           MOV     ES:[BX],AL                    ; SET COLOR TO X,Y

           MOV     SP,BP                         ; PREPARE FOR RETURN
           POP     BP
           RET

           SETPIXEL ENDP

           CODE    ENDS

           END