uses
   crt,
   dos;

type
   teksti = string[25];

var
   x,y : integer;
   color,
   red_v,
   green_v,
   blue_v,
   c   : byte;
   ch : char;
   reg : registers;

{$F+}
procedure setpixel (x , y : integer; c : byte);external;
{$L pixdemo.obj}
{$F-}

procedure getcolor (var c,r,g,b : byte);
   var
      reg : registers;

   begin
      reg.ah := $10;
      reg.al := $15;
      reg.bx := c;
      intr ($10,reg);
      g := reg.ch;
      b := reg.cl;
      r := reg.dh;
   end;

procedure setcolor (r,g,b : byte);
   var
      reg : registers;

   begin
      reg.ah := $10;
      reg.al := $10;
      reg.bx := 1;
      reg.ch := g;
      reg.cl := b;
      reg.dh := r;
      intr ($10,reg);
   end;

procedure WrtTxt (t:teksti;fg,bg,col,row : byte);
   var
      reg : registers;
      ch : char;
      i,l : byte;

   begin
      l := length (t)-1;
      for i := col to col+l do
      begin
         reg.ah := 2;
         reg.bh := 0;
         reg.dh := row;
         reg.dl := i;
         intr ($10,reg);
         ch := t[i-col+1];
         reg.ah := 9;
         reg.al := ord (ch);
         reg.bh := bg;
         reg.bl := fg;
         reg.cx := 1;
         intr ($10,reg);
      end;
   end;

procedure Sivu;
   begin
      WrtTxt ('Incr.  7    8    9    +',12,0,15,3);
      WrtTxt ('Color Red Green Blue Pal.',10,0,15,4);
      WrtTxt ('Decr.  1    2    3    -',9,0,15,5);
      WrtTxt ('Palette number',14,0,15,8);
      WrtTxt ('Red',15,0,20,10);
      WrtTxt ('Green',15,0,20,12);
      WrtTxt ('Blue',15,0,20,14);
      WrtTxt ('Quit <Esc>',14,0,20,17);
   end;

procedure ClrTxt (c,r,g,b : byte);
   var
      apu,
      t : teksti;

   begin
      str (c:4,t);
      WrtTxt (t,0,0,30,8);
      str ((100*r/63):3:0,t);
      str (r:3,apu);
      t := t+'%,'+apu;
      WrtTxt (t,0,0,26,10);
      str ((100*g/63):3:0,t);
      str (g:3,apu);
      t := t+'%,'+apu;
      WrtTxt (t,0,0,26,12);
      str ((100*b/63):3:0,t);
      str (b:3,apu);
      t := t+'%,'+apu;
      WrtTxt (t,0,0,26,14);
   end;

procedure Txt (c,r,g,b : byte);
   var
      apu,
      t : teksti;

   begin
      str (c:4,t);
      WrtTxt (t,14,0,30,8);
      str ((100*r/63):3:0,t);
      str (r:3,apu);
      t := t+'%,'+apu;
      WrtTxt (t,15,0,26,10);
      str ((100*g/63):3:0,t);
      str (g:3,apu);
      t := t+'%,'+apu;
      WrtTxt (t,15,0,26,12);
      str ((100*b/63):3:0,t);
      str (b:3,apu);
      t := t+'%,'+apu;
      WrtTxt (t,15,0,26,14);
   end;

begin
   reg.ah := 0;
   reg.al := $13;
   intr ($10,reg);
   c := 1;
   for x := 10 to 100 do
   begin
      for y := 10 to 189 do
         setpixel (x,y,c);
   end;
   color := 1;
   getcolor (color,red_v,green_v,blue_v);
   Sivu;
   Txt (color,red_v,green_v,blue_v);
   repeat
       ch := readkey;
       case ch of
       '7' : if (red_v < 63) then
                inc (red_v)
             else
                write (#7);
       '8' : if (green_v < 63) then
                inc (green_v)
             else
                write (#7);
       '9' : if (blue_v < 63) then
                inc (blue_v)
             else
                write (#7);
       '1' : if (red_v > 0) then
                dec (red_v)
             else
                write (#7);
       '2' : if (green_v > 0) then
                dec (green_v)
             else
                write (#7);
       '3' : if (blue_v > 0) then
                dec (blue_v)
             else
                write (#7);
       '+' : if (color < 255 ) then
             begin
                inc (color);
                getcolor (color,red_v,green_v,blue_v);
                if (color = 1) then
                begin
                   red_v := 0;
                   green_v := 0;
                   blue_v := 42;
                end;
             end
             else
                write (#7);
       '-' : if (color > 0) then
             begin
                dec (color);
                getcolor (color,red_v,green_v,blue_v);
                if (color = 1) then
                begin
                   red_v := 0;
                   green_v := 0;
                   blue_v := 42;
                end;
             end
             else
                write (#7);
       end;
       ClrTxt (color,red_v,green_v,blue_v);
       setcolor (red_v,green_v,blue_v);
       Txt (color,red_v,green_v,blue_v);
   until ch = #27;
   reg.ah := 0;
   reg.al := 3;
   intr ($10,reg);
   write ('TM-Products, (c) 1991');
end.