{---
  TURBO PASCAL - Frequently Asked Questions / Routines
               - Yleisimmin kysytyt kysymykset ja rutiinit

  Jussi Josefsson 1996

  Osa 2, koska ensimminen tiedosto tyttyi ja alkoi olla jo hankala ksitell
  Tss osassa lis rutiineja, MEM-taulukon kytt, assembleria ja
  selvityksi. Mitp muutakaan?

  NPPIMENPAINALLUKSEN TOTEAMINEN - KEYPRESSED
  NPPIMEN LUKEMINEN - READKEY
  MONTA NPPINT YHTAIKAA POHJASSA / OMA NPPINRUTIINI - INT09

  PASCAL OPTIMOINNISTA
   VALITSIMET

  SANASTOA
  KEYBOARD - KIRJASTO (KEYBOARD.TPU)
 ---}

NPPIMENPAINALLUKSEN TOTEAMINEN - KEYPRESSED

         Erityisesti pieniss ohjelmissa ottaa usein phn kun joudutaan
         linkittmn CRT-kirjasto mukaan ohjelmaan vain sen takia ett se
         sislt Keypressed-rutiinin, jolla voidaan esimerkiksi katkaista
         silmukka, kun kyttj painaa jotakin nppint. Joten ehk on
         helpompi jos on oma aliohjelma, jolla voi tehd tysin saman asian?

         Seuraavaksi toteamme keskeytyst $21 kytten, ett onko mitn
         merkki painettu, toisinsanoen ilmoitamme assemblerille, ett ky
         noutamassa nppimistpuskurin tilan, jonka ANDaamme luvulla $FE
         eli 254, jolloin saamme tiet, onko minkn napin lippua asetettu.
         Jos lippu on pll, tulee AND lauseen tulokseksi 1 (sama kuin TRUE)
         ja jos mikn ei ole asetettu plle, on tulos 0 (FALSE). Ei thn
         vaadita monimutkaisia nppimistnksittelykeskeytyksi tms.

         Function KeyPressed : Boolean; Assembler;
           Asm
             MOV AH, $B
             INT $21
             AND AL, $FE
           End;

         Seuraavana sama tehtyn Turbo Pascalin DOS-unitin sisist REGISTERS
         muuttujaa kytten. Toimii TP 5.0 tai uudemmalla ja on erittin
         selke. Rutiini pelaa mys TP 3.0+ kanssa, jos esittelee REGISTERS
         muuttujan:
           Type
             { Registers record used by Intr and MsDos }
             Registers =
               record
                 case Integer of
                   0: (AX, BX, CX, DX, BP, SI, DI, DS, ES, Flags: Word);
                   1: (AL, AH, BL, BH, CL, CH, DL, DH: Byte);
                 End;

         Function KeyPressed : Boolean;
           Var Regs : REGISTERS;
           Begin
             Regs.AH := $B;
             Intr ($21,Regs);
             If Regs.AL AND $FE <> 0 then KeyPressed:=True
              else KeyPressed:=False;
           End;

         Vlill voi olla jrkev tyhjt rekisterit ennen keskeytyksen
         kutsumista. Helpoimmin tmn toteuttaa tutulla FillChar -komennolla,
         jolla voi mys mrt mill arvolla rekisterit tytetn:
           FillChar(Regs,SizeOf(Regs),0);
         Ylpuolen kskyss luku 0 tarkoittaa siis arvoa jolla rekisterit
         tytetn.

         Yllolevissa rutiineissa on pieni ongelma, sill ne eivt huomioi
         lainkaan SHIFT, CTRL, ALT, CAPS LOCK tms. nppimi.
         Jos haluat nppimenlukurutiinin, joka todellakin esim. keskeytt
         silmukan kun MIT TAHANSA nappia painetaan, voit varmistaa asian
         seuraavalla rutiinilla:

         FUNCTION AnyKeyPressed: BOOLEAN;
         BEGIN
           AnyKeyPressed := ((MEM[$40:$17] AND $0F) > 0) OR (MEM[$40:$18] > 0)
                            OR KEYPRESSED;
         END;

         Edellisen rutiinin voi mys suoraan laittaa REPEAT..UNTIL rutiinin
         ehdoksi. Ensimminen MEM-kohta tarkistaa onko jonkin erikoisnapin
         lippu asetettu. MEM-taulukon osoitteessa $40:$17 olevassa tavussa
         on seuraavanlainen rakenne:
         Numero  Bitti  Nppin
         ------  -----  -------
             1     0   Right Shift
             2     1   Left Shift
             4     2   Ctrl
             8     3   Alt
            16     4   Scroll Lock
            32     5   Num Lock
            64     6   Caps Lock
           128     7   Insert

         Jos siis haluat tehd lukurutiinin, joka tekee jotakin kun insert
         -nppint painetaan, ANDaa muistipaikan sislt luvun 128 kanssa:
         begin
           repeat
             write ('!');
           until Mem[$40:$17] and 128 >0;
         end.

         Jos haluat tietoja SysReq -nppimest tai lopuista erikois
         -nppimist, lue seuraava muistipaikka, eli muistipaikka [$40:$18].
         Muistipaikan sislt lytyy alta MEMW taulukon yhteydest, MEM
         taulukkoa kytettess bitit vain alkavat 0:sta, eli Insert
         -nppimen lippu (bitti) on seitsems bitti.

         Huomaa ett vielkin elegantimpi keino on kytt mys seuraavaa
         tavua hyvkseen kyttmll MEMW -taulukkoa, joka lukee yhden WORD
         pituisen arvon kerrallaan. Ja kun kerran WORD (eli MEMW) on kaksi
         BYTE (MEM), voidaan yhdell luvulla saadaan kaikkien nppimistn
         erikoisnppinten liput kerralla yhteen muuttujaan!
         Numero  Bitti  Nppin
         ------  -----  -------
           256     8  
           512     9  
          1024    10   Sys Req
          2048    11  
          4096    12   Scroll Lock Pressed
          8192    13   Num Lock Pressed
         16384    14   Caps Lock Pressed
         32768    15   Insert Pressed

         IF MEMW[$0000:$0417] AND [numero] > 0 then [Nppin_painettu]

         Jos siis haluat laittaa peliohjelmasi ampumaan CTRL - nppimell,
         voit tehd esimerkiksi seuraavan silmukan:
         IF MEMW [$0000:$0417] AND 4 > 0 then
           REPEAT
             { tulitusrutiinit }
           UNTIL MEMW [$0000:$0417] AND 4 = 0;

         Ja jos et halua tulittaa jatkuvasti, laita repeat..until lauseen
         tilalle normaali BEGIN..END. Edellisess rutiinin tyngss kytettiin
         toistolauseen lopettamisen ehdoksi CTRL-napin pstmist, jolloin
         MEMW..AND - lausekkeen tulokseksi tuli 0, jos nappi EI ole pohjassa.

         Uudemmissa (uudemmissa? AT-koneissa!) voidaan kytt mys surutta
         porttia $60, josta luettaessa tytyy huomioida mys merkkipuskurin
         tyhjys ja tarpeelliset viiveet, sill merkin luku on NOPEAA, ja
         voi aiheuttaa useiden merkkien luvun turhankin nopeasti.
         Lisksi on muistettava ett arvot, jotka saadaan portista $60 ovat
         nk. SCAN-koodeja, eli kertovat kirjaimellisesti mit nppint
         on painettu eik niinkn mik olisi nppimen sislt.

         Scan_Code := Port[$60];

         Jos siis halutaan toistaa lausetta, kunnes ESCAPE nppint on
         painettu, voidaan kytt seuraavanlaista toistolausetta:
         WHILE Port[$60]<>1 DO
           BEGIN
           END;

         SCAN-koodit ilmoittavat mys kun nappi pstetn, koodi on sama
         kuin alas painetun napin koodi: listn vain 128 ($80) napin
         koodiin. Jos haluttaisiin toistaa silmukkaa, kunnes ESCAPE nappi
         PSTETN, olisi lause seuraavan nkinen:
         WHILE Port[$60]<>129 DO
           BEGIN
           END;

MERKIN LUKEMINEN - READKEY

         Ja kun kerran nppimistn lukemisessa on psty vauhtiin, lienee
         tarpeellista saada luettua merkki nppimistlt ilman CRT
         -kirjastoa ja sen tuomia listavuja. Borlandin vakiokirjastot
         nimittin tekevt erittin paljon tarkistuksia ja vertailuja, jotka
         eivt vlttmtt ole kovinkaan tarpeellisia.
         Yksinkertainen READKEY rutiini voisi nytt vaikka tlliselta:

         Function ReadKey : Char;
           VAR Regs : Registers;
           Begin
             Regs.AX := $0700;
             Intr($21, Regs);
             ReadKey := Chr(Regs.AL);
           End;

         BIOSin tarjoamat keskeytykset ja niiden hydyntminen on kyll
         monissa tapauksissa perusteltua ja erittin yksinkertaista, lisksi
         8086-koneiden nppimist ohjaava prosessori ei talleta tietoja
         muistiin samalla tavalla, joten edellisen kappaleen Keypressed
         rutiini ei tllin toimi, kuten ei seuraavan kappaleen
         MEM - taulukkoon nojaavat rutiinitkaan. Kannattaa kuitenkin muistaa,
         erityisesti pelej tehtess, ett BIOS ei suoraan kykene lukemaan
         useita merkkej yhtaikaa. Mutta jos demo tai ohjelma tarvitsee
         yhden ainoan Readkeyn/Keypressed - tarkistuksen, on jrkevmp tehd
         oma, lyhyt BIOS-rutiini, kuin tehd oma nppimistkeskeytyksen
         koukuttava rutiini, jonka viilaukseen voi kulua paljon aikaa ja
         monta rsyttv koneen kaatumista.

NPPINPUSKURIN TYHJYS - FLUSHKEYBOARD

         Vlill on trket saada tieto siit ett nppimistn puskuri on
         tyhjennetty; esimerkiksi peleiss siirryttess vaikkapa menusta
         itse toiminnankeskelle. Nppimist nimittin lukee merkkej
         puskuriin, josta ne ohjelmalle sytetn. Jos tarkistat esimerkiksi
         onko nppint painettu, trmt ongelmaan, koska painettu merkki
         j nppimistpuskuriin ja se menee seuraavan nppimistn luvun
         sytteeksi. Esimerkki:
           REPEAT
            { grafiikkaa tahi kskyj }
           UNTIL KEYPRESSED;
           Writeln ('Menu: valitse 1 / 2 / 3 tai poistu muuta nappia
                     painamalla');
           Merkki := Readkey;

         Yllolevassa tapauksessa repeat..until lauseesta saatu napin
         painallus heitt useimmissa tapauksissa kyttjn pois ohjelmasta.
         Ongelma esiintyy usein mys tilanteissa jossa kyttjn vaihtoehtoina
         on painaa jotain nappia tai hiiren nappia.
         On siis tarpeen tyhjent nppinpuskuri turhista merkeist:

         procedure FlushKeyboard;
         begin
           MEM[$0040:$001A]:=MEM[$0040:$001C];
         end;

         procedure FlushKeyboardW;
         begin
           MEMW[$0000:$041A] := MemW[$0000:$041C];
         end;

         Tss kytetn hyvksi nppimistpuskurin ominaisuutta, eli
         rengasmaisuutta, laittamalla puskurin alku osoittamaan loppua, joka
         on (ainakin ohjeiden mukaan) "likainen temppu". Mutta tyhmt kulkevat
         pidempi reittej ;) Kyseess on siis kaksi osoitinta, "alku" ja
         "loppu" ja jos molemmat osoittavat samaa, on puskuri tyhj.

         Ah ja voi! Jlkimminen tapa tekee tysin saman kuin edellinenkin,
         kytten vain hyvkseen MEMW taulukkoa, jossa sislt koostuu WORD
         tyyppisist muuttujista. Ainakin jos koneen ohjeistuksia on uskominen
         niin jlkimmisen pitisi olla nopeampi. Huomaa, ett SWAG
         -tiedostoissa ja FIDOnetin alueilla on kyty keskustelua ja todettu
         ett MEMW-taulukon kytt yll olevalla tavalla voi haitata
         suojatussa tilassa olemista.

         Mik hyty sitten MEMW -taulukolla on MEM taulukkoon verrattuna?
         En usko ett yhden kellon ero auttaa ketn, ainoa hyty lienee MEM
         ja MEMW -taulukoiden osoituksen vertailu. $0040:$001A vs. $0000:$041A
         nenk niss jotakin yhteist?

         Ja sama tapahtuu syttmll AX -rekisterin ylempn puoliskoon arvo
         $0C ja alempaan $00, jolloin tyhjtn BIOSin avulla nppinpuskuri.

         procedure FlushKbd; Assembler;
         asm
           Mov AX, $0C00;
           Int 21h;
         end;

MONTA NPPINT YHTAIKAA POHJASSA / OMA NPPINRUTIINI - INT09

         Erityisesti peleiss on trke lukea useita nppimi yhtaikaa,
	 koska yleens nuolinppimill ohjataan liikett ja jollain muulla
	 napilla ammutaan jne.  Yllolevat rutiinit ovat hyvi jos kyseess
	 on menu-tyyppinen nppimistnluku, merkin tai merkkijonon
	 lukeminen tai vastaava toiminta, jossa nopeudella ei ole
	 merkityst.  Lisksi tytyy muistaa, ett DOSin perusnppimist
	 puskuri on ainoastaan 16 merkki pitk, joten monia perkkisi
	 "Keypressed - readkey" yhdistelmi ei kannata tehd.  Yleens
	 esimerkiksi peleiss on silmukka seuraavan nkinen:

	 REPEAT
	   { pivit ruutua }
	   IF keypressed THEN 
	     BEGIN
	       C := READKEY;
	       Case C of
	        'T','t':Tulita;
		'V','v':vasemmalle;
		'O','o':oikealle;
	       end;
	     END;
	 UNTIL "Escape"

         Yllolevasta esimerkist ky jo ilmi selvt puutteet joita
         silmukassa on, eli mit jos halutaan menn vasemmalle JA tulittaa
         ja entp jos ruudunpivitys on kesken lukemisen aikana ja
         nppimistpuskuri tyttyy?  Samoin ongelmia tulee juuri
         puskuroinnin takia, koska kyttj voi vahingossa pit nppint
         koko ajan pohjassa, jolloin ruudunpivitys tapahtuu, tehdn
         seuraavan nppilyn mukainen asia jne.  Jolloin kyttj ei
         vlttmtt pse ohjaamaan hahmoa/alusta (tai vast.) reaaliajassa.

         Vastaus pulmiin on oma nppimistkeskeytys, jossa tehdn selke
         taulukko, joka ilmoittaa mitk nppimet ovat kulloinkin pohjassa
         ja koukutetaan se tapahtumaan ENNEN normaalia
         nppimistkeskeytyst.

         Aluksi esitelln TP:lle siis taulukko, jossa on jokaiselle
         painetulle nppimelle on oma TRUE/FALSE arvo, joka kertoo, onko
         nppint painettu.  Huomaa ett taulukkoa kytettess valvotaan
         nppint, ei nppimen sislt!  Eli numeronppimistn "+"
         -kirjain saa eri arvon kuin perusnppimistn "+"-kirjain!  Samoin
         taulukkoon ei talletu onko CTRL tai muuta erikoisnppint
         painettu yhtaikaa jonkin muun kanssa.  Niss joudut soveltamaan
         yllmainittuja keinoja kuten MEMW -taulukkoa.  Voit toki laittaa
         rutiinin tarkistamaan mys erikoisnppimet tai laittaa nille omat
         BOOLEAN muuttujat:
                VAR CTRL :  Boolean;

         (tai kytt "epvirallista" tapaa: 
                CONST CTRL : BOOLEAN = FALSE; 
          Ylloleva siis esittelee CTRL-muuttujan BOOLEAN tyyppiseksi ja
          antaa sille alussa arvon FALSE, eli nppint ei ole aluksi
          painettu.  Tllist vakiota voidaan ksitell kuten normaalia
          muuttujaa)

         Itse taulukko voi siis olla esimerkiksi tmn nkinen:
                VAR Keyboard : ARRAY [0..127] OF BOOLEAN;

	 Tllin voimme jokaisen nppimistkeskeytyksen tapahtuessa asettaa
         nppimen arvon todeksi (TRUE) tai nppimen pstmisen yhteydess
         asettaa nppimen arvo eptodeksi (FALSE).
         Yllolevan taulukon huono puoli on ainoastaan siin, ett et voi
         milln muistaa kaikkia muuttujan arvoja ulkoa, eli et vlttmtt
         muista mik koodi on esim.  SPACE-nppimelle.  Ratkaisu on
         tietysti vakiot (CONST), joissa jokaiselle nppimelle annetaan
         kuvaava vakio (esim.  KEY_SPACE, KEY_1 etc.).  Mutta nm taasen
         vievt tilaa ja ovat hankalia ohjelman luettavuuden kannalta.
         Kannattanee tehd erillinen KEYBOARD (tms.)  -kirjasto (UNIT) johon
         sijoittaa nppimistn hallinta rutiinit. Vakiot lytyvt tiedoston
         lopusta, valmiina leikattaviksi.

         VAR Keys : ARRAY [0 .. 127] OF BOOLEAN;
             OldInt09 : POINTER;

         {$F+}
         PROCEDURE NewKbdINT09;
           VAR  Highbyte, Lowbyte : BYTE;
           BEGIN
             Highbyte := PORT [$60];
             Keys [Highbyte AND $7f] := (Highbyte <= $7f);
             Lowbyte := PORT [$61];
             PORT[$61] := Lowbyte OR $80;
             PORT[$61] := Lowbyte;
             PORT[$20] := $20;
           END;

         {$F+}
         PROCEDURE HookKBDInt;
           VAR KeyCount : Byte;
           BEGIN
             For KeyCount:=0 to 127 do Keys[KeyCount]:=False;
             GetIntVec(9, OldInt09);
             SetIntVec(9, Addr( Newkbdint ));
           END;

         PROCEDURE UnHookKBDInt;
           BEGIN
             MEMW [$0000:$041A]:=MEMW [$0000:$041C];
             SetIntVec (9,addr (oldint09));
           END;

         Eli ensimmiseksi tulee kutsua "HookKbdInt"-rutiinia, joka koukuttaa
         vanhan nppimistksittelijn, joka siis sijaitsee keskeytyksess
         09 (sama numero heksana/desimaalina). Osoitteeseen laitetaan oma
         keskeytys, joka muuttaa "Nppint painettu" - muuttujan (KEYS)
         arvoja ja jtt ohjat sitten vanhalle nppimistrutiinille.
         Nin voimme tehd silmukan, joka tekee jotakin, jos vasenta nuolta
         on painettu, esimerkiksi perinteisess ammuntapeliss alus siirtyy
         vasemmalle ja lisksi jos esim. vlilynti on painettu, ammutaan.
         Nm voivat siis tapahtua yhtaikaa, samoin voi kuvitella saman
         tapahtuvan tuplasti useammin kaksinpeliss. Ikv kyll PC:t ovat
         todella sekavanlaatuisia nppimistjens kanssa, sill jotkut
         nppimistt pystyvt lhettmn useampia merkkej yhtaikaa kuin
         toiset. Nyrkkisntn voi pit ett 6-8 merkki kerralla voidaan
         lukea. Suurempi mr vain riskeeraa pelin toimivuuden ja aiheuttaa
         harmaita hiuksia pelaajille ja ohjelmoijalle.
         Silmukka voi olla esimerkiksi aikaisemmin mainitun kaltainen:

           REPEAT
             If Keys [key_left] = TRUE then vasemmalle;
             If Keys [key_right] = TRUE then oikealle;
             If Keys [key_space] = TRUE then tulita;
           UNTIL Keys [key_esc] = TRUE;

         Ja huomaa ett KAIKKI yllolevat napit voivat olla pohjassa ja yht-
         aikaa. On vain lukemisjrjestyksest kysymys, mit tapahtuu, kun
         pelaaja painaa sek yls- ett alasnuolta yhtaikaa.

         Ohjelman ptytty tulee poistaa uusi nppimistnksittelij ja
         palauttaa vanha. "UnHookInt" tekee tmn ja lisksi tyhjent
         nppimistpuskurin aikaisemmin selvitetyll tavalla.

HUOM!    Tiedoston lopussa on paitsi lista kaikista nppimistkoodeista ja
         nille vakiot, mys kokonainen nppimistnksittely-kirjasto, jonka
         voi helposti liitt omiin ohjelmiinsa. Tallenna koko listaus alkaen
         (***) - rivist nimell KEYBOARD.PAS. Voit kutsua kirjaston rutiineja
         aivan normaalisti, eli pakolliset rivit ovat:
           USES Keyboard; { ja muut kirjastot joita mahdollisesti kytt }
           BEGIN
             { omaa koodia }
             Unhookint;
           END.

         Ohjelma "vaatii" huimat 190 tavua muistia tiedoille ja lisksi 134
         tavua symboleille etc. Yhteens siis 324 tavua, mik ei nykyisten
         ohjelmien ja kiintolevyjen aikana liene liikaa. Pelkk TP:n CRT
         kirjasto vaatii noin 3 kiloa (10 kertainen mr) eik edes pysty
         ksittelemn useita nppimi yhtaikaa.

         Tss yksinkertainen esimerkki, joka kirjoittaa ruudulle merkkej
         niin kauan kun nappia painetaan.

           USES KEYBOARD;
           BEGIN
             REPEAT
              If Keys [key_left]=true then write ('<');
              If Keys [key_right]=true then write ('>');
              If Keys [key_space]=true then write ('_');
              If Keys [key_up]=true then write ('^');
              If Keys [key_down]=true then write ('-');
             UNTIL Keys[key_esc]=true;
             UnHookInt;
           END.

---

PASCAL OPTIMOINNISTA

         Lienee hyv mainita pieni vihjeit koon ja nopeuden optimoinnista
         kaikille Turbo Pascal-kyttjille. Tietysti optimoinnista voi
         rimpuilla ja vnt ktt loputtomiin, mutta tietyt yleisptevt
         neuvot voi vied kauan jos niit lhtee itse kokoilemaan.
         Lisksi jos olet tekemss pieni "yleisi" apuohjelmia tai jopa
         pieni introja, erityisesti koon suhteen optimointi lienee
         paikallaan, sill esimerkiksi debug-option kntminen pois plt
         tekee tilaa introssa esimerkiksi kokonaiselle MOD-soitin ohjelmalle!
         Valitsimet kannattaa sijoittaa TPC.CFG tiedostoon, jolloin ne vasta
         knnettess otetaan kyttn, eivtk ne vaikuta koodaamisen aikana
         eivtk siis hiritse koodiin keskittymist.

VALITSIMET

         Valitsimilla ohjataan ohjelman knnksen tapahtumista, valitaan
         erilaisia tkn metsstys-menetelmi, ilmoitetaan kytetnk
         matematiikkaprosessoria vai emulointia jne.
         Osa valitsimista hidastaa ohjelmaa ja osa kasvattaa ohjelman kokoa,
         joten turhat valitsimet kannattaa knt pois plt.

           {$G+} Sallii 286 kskyjen kytn, jos kytt esim. STOSW, PUSHA,
                 IMUL, SHL, vaikuttaa lhinn assembler-kskyihin.
                 Huomaa ett SHL assemblerilla toimii mys 8086
                 prosessoreilla, mutta silloin pit useammat SHL-komennot
                 tehd joko perttisill toistoilla, tai tallettamalla
                 SHR/SHL-komentojen mr rekisteriin ja toimittamalla se
                 komennolla.  Esimerkki 286+ tavasta toteuttaa neljll
                 jakaminen, eli esim. 128 / 8, eli 128 SHR 3:
                    asm
                      mov ax, 128
                      shr ax, 3
                    end;
                 Kun taas 8086-prosessorilla joudutaan tekemn jompikumpi
                 seuraavista tavoista:
                    asm                 asm
                      mov ax, 128         mov ax, 128
                      mov cx, 3           shr ax
                      shr ax, cx          shr ax
                    end;                  shr ax
                                        end;

           {$D-} Poistaa debuggaukseen (virheiden lytmiseen) tarvittavat
                 "turhat" tiedot ajettavan koodin joukosta.  Erityisesti
                 paljon kirjastoja kyttvlle hydytt poistaa ainakin
                 lopullisesta ajettavasta ohjelmasta nm kyttjlle turhat
                 tiedot.
                 Esimerkiksi ers GFX.TPU (sislt grafiikkaa ksittelevi
                 rutiineja, hivenen samaan tyyliin kuin TPFAQ1.PAS:ssa),
                 joka vie "normaalisti" knnettyn 10848 tavua, vie -$d-
                 valitsimella varustettuna 6192 tavua, eli 75% entisest!
                 Melkoinen parannus yhdell valitsimella toteutettuna.
                 Toisaalta, suurikokoisessa Cyberpunk NPC-generaattorissani
                 lisys oli aivan mittn, koska loppujen lopuksi debuggerille
                 ei ilmeisesti ollut jnyt paljoakaan epselvksi.
                 Alkuperinen EXE tiedosto (ilman data yms. tiedostoja) oli
                 49824 tavua ja ilman debug-tietoja tiedosto puristui
                 ainoastaan 32 tavua pienemmksi! Tllin enemmn hyty on
                 kytt ajonaikaista pakkausta, esim. PKLITE (vaatii
                 rekisterinnin) tai Compack -ohjelmia. Tllin edell
                 mainittu ohjelma puristui 22844 tavuun, eli alle puoleen
                 alkuperisest.

           {$S-} Hivenen vaarallinen valitsin tysin kokemattomille
                 TP-faneille, koska valitsin poistaa pinon tarkistuksta
                 varten tuotettavan koodin. Eli jos pino vuotaa yli (pino =
                 stack) koko kone voi kaatua. Toisaalta, huolehtimalla siit
                 ett pino EI vuoda yli, saadaan pienennetty ohjelman
                 vaatimaa tilaa. Pinon ylivuodon voi estmll varaamalla
                 tarpeeksi tilaa ohjelman alussa {$M} valitsimen parametrein.
                 {$M 16384} on oletus, joka yleens riitt, jos ohjelma
                 kaatuu, kokeile lukua 32000.
                 Edellisen valitsimen kohdalla mainittu kirjasto vie
                 {$D-} ja {$S-} valitsimien kanssa knnettyn 5696 tavua.

           {$R-} Poistaa rajojen tarkistuksen, eli kntj ei tarkista ovatko
                 esim. array - tyyppisen muuttujan osoitukset rajojen sisll.
                 Jos esim. olet mritellyt muuttujan
                   X : Array [1..100] of byte;
                 ja osoitat sit X[1001]:=1000; seuraa virheilmoitus, jos
                 valitsin on pll. Jos valitsin ei ole pll, ohjelma
                 toimii nopeammin ja vie vhemmn tilaa. Jos ohjelma ei
                 ksittele taulukoita, tilan ja nopeuden etua ei juurikaan
                 saavuteta.

           {$A+} Pist kntjn ksittelemn muuttujia ja vakioita WORD
                 tyyppisin paketteina, eli jos on LONGINT ja WORD mittainen
                 muuttuja perkkin (BYTE=8 bitti=1 tavu, WORD=16 bitti=
                 2 tavua), kntj tytt tavun mittaisen tilan tyhjll,
                 jotta ei synny "parittomia" (odd) eli eptasaisia osoitteita
                 muuttujille:
                 BYTE  WORD
                 0000 1000 0010 1001 0100 1001  {$A-} -tilan ollessa pll

                 TYTE BYTE -WORD
                 0000 0000 0000 1000 0010 1001 0100 1001  {$A+} tilassa

                 80X86-prosessorit toimivat nopeammin kun ksitelln WORD
                 tyyppisi lukuja, koska rekisterit ovat 16 bittisi.
                 Huomaa ett valitsin ei vaikuta record - tyypin sisll
                 oleviin kenttiin, eik taulukoiden sisltihin.
                 Toisin kuin ohjeissa sanotaan, valitsin VAIKUTTAA tavun
                 kokoisiin muuttujiin, mutta ei sisltn, ainoastaan
                 osoitenpaikkaan, jossa muuttuja on. Kyttj, kntj tai
                 kyttjrjestelm ei ne eroa muuttujissa.

---
SANASTOA

         Ohjelmointia harrastavat henkilt ovat lhes pakotettuja lukemaan
         lukuisia sekavia ja vhemmn sekavia lhteit ja yleens aina
         kielen on Lontoon murre, eli Englanti. Tst syyst suomenkielinen
         sanasto on hivenen sekoittunut termeist, jotka voivat olla ainakin
         aluksi hivenen sekavia. Itsekin olen varmasti sekoittanut joidenkin
         pit puhumalla silmukoista, koukuttamisesta jne. Tss kuitenkin
         tmn artikkelin sanojen sislt eri vastikkein.

         debugaus (debugging) - virheiden metsstys ja -korjaus. Joka
                  ohjelmassa on virheit, ainakin aluksi ja debuggaus
                  tarkoittaa jrjestelmllist virheiden metsstyst joko
                  Turbo Pascalin sisll tai erillisell ohjelmalla (Turbo
                  Debugger ja erilaiset disassemblerit eli ohjelmat jotka
                  muuntavat EXE-muotoisen ohjelman konekielelle virheiden
                  metsstyst tai optimointia varten).

         keskeytys (interrupt) - kyttjrjestelmn tapa hoitaa asioita. Eri
                  laitteille on eri keskeytyksi, joilla voidaan ohjelman
                  ajon(kin) aikana seurata niden tilaa tai saada tietoa
                  nist. Esimerkiksi kellokeskeytys pivitt kelloa
                  snnllisin vliajoin. Keskeytyksiin voidaan laittaa omaa
                  koodia ja/tai kaapata koko keskeytys. Osa keskeytyksist
                  on ohjelmoitavia mys tapahtumanopeudeltaan.

         koukutus (hooking) - koukuttaa keskeytys, eli laittaa omaa koodia
                  kyttjrjestelmn keskeytyksiin, jolloin saadaan halutun
                  keskeytyksen tullessa kone suorittamaan meidn koodia.
                  Yleens vanha keskeytys tulee heti oma tekemn "koukun"
                  jlkeen, keskeytykseen siis vain listn omaa koodia.
                  Esimerkiksi nppimist keskeytykseen, joka ky snnllisin
                  vliajoin tarkistamassa nppimistn tilan, voidaan list
                  koodia esimerkiksi tulitusnppimi, useiden nappien yht-
                  aikaa painamisen toteamista tms.

         kntj (compiler) - tulkki, joka knt kyttjn kirjoittamat
                  kskyt koneen ymmrtmn muotoon. Turbo Pascalissa on
                  mainio IDE (yhteennivottu kehitysymprist - eli yhdess
                  ohjelmassa on kirjoitustila, kntj, debuggeri, ohjeet
                  jne.) jossa on kntj ja lisksi TP:ss on komentorivilt
                  toimiva kntj jota voidaan kytt suoraan dossista.

         lippu (flag) - rekisterin bitin tila. Yksinisest bitist kytetn
                  nimityst "lippu", koska sill on kaksi tilaa; pll (1)
                  tai pois plt (0), tllin sanotaan ett jos bitti on
                  1 niin lippu on asetettu ja jos bitti on 0, lippu on pois
                  plt (alhaalla). Jotkut rekisterit palauttavat sisltns
                  tavuna, jossa jokaisella bitill on oma tarkoituksensa, eik
                  kokonaistuloksella ole niinkn vli.

         nppimistpuskuri (keyboard buffer) - tavallisesti 16 merkin
                  taulukko johon merkit tallentuvat.

         port     (port/portw) - tapa, jolla voidaan osoittaa suoraan CPU:n
                  (keskusyksikk) data-portteihin, toisinsanoen vied tai
                  tuoda tietoa data-yksikist. Port taulukkoa voidaan
                  kytt BYTE (tavu, 8 bitti) tyyppisen tiedon tuomiseen
                  tyyliin Vari := Port [$3C9]; tai viemiseen tyyliin
                  Port [$3C9]:=63; PortW sislt/tuo tietoa WORD mittaisina
                  (2 tavua, 16 bitti).

         rutiini (routine) - aliohjelma tai kskyjoukko, jolla saadaan haluttu
                  asia tehdyksi. Viittaa aliohjelmaan, joksi muokattuna
                  rutiinia voidaan kutsua rutiininomaisesti eli aina
                  tarvittaessa.

         silmukka (loop) - toistolause, jolle voidaan asettaa haluttuja
                  ehtoja. Lausetta toistetaan kunnes ehto tyttyy. Ehto voi
                  olla tietty lukumr toistoja, nppimen painallus,
                  matemaattisen laskutoimituksen tulos tai vaikkapa tietty
                  ajan kuluminen.

         valitsin (switch) - ilmaistaan kntjlle miten ohjelmaa tulee
                  ksitell. Valitsimilla voidaan tehd ohjelmasta helpommin
                  debugattava, huomioida eri prosessorit, mritell ehtoja
                  suoritukselle tms.

---
SCAN-KOODIT
	 Tss seuraavana on tydellinen nppimistkeskeytyksen koukuttava
         pascal kirjasto, eli UNIT. Samasta ohjelmasta voi mys luntata
         nppimistn arvon, jos haluaa lukea vain muutamia arvoja suoraan
         portista $61.
         Kyseess on siis painetun nppimen "numero", EI ARVO.  Eli tulos
         on sama kaikilla nppimistill riippumatta COUNTRY.SYS, KEYB SU
         tms. arvoista.  Samoin nppimen antamaan arvoon EI vaikuta SHIFT,
         ALT, CTRL, tms. nppin (paitsi ett mys ALT nppimen arvo voidaan
         lukea koska nppimistksittelij pit sillkin KEYDOWN -taulukkoa!

	 Ehdotonta lukemista:
   	  Ralph Brownin "MS-DOS interrupt list v. ??" - INT??.ZIP
   	  Inbar Raz "Keyboard" - KEYBOARD.ZIP
   
   	 TP On-line help (sanan kohdalla CTRL+F1) valitsimista

  	 DOSin nppimist keskeytykset lytyvt mys
   	 Gunvald Hedemalm "80486 ohjelmointi" -kirjasta

	 Seuraavassa osassa pureudutaan takaisin grafiikan ktkihin
	 esittelemll nennisruudut (virtualscreens), muutamia trkeit
	 grafiikka-alkioita etc.

(**********************8<************************>8**************************)
UNIT KEYBOARD;
INTERFACE

Uses DOS;

CONST
             KEY_ESC         =1;  { ESCAPE }
             KEY_1           =2;
             KEY_2           =3;
             KEY_3           =4;
             KEY_4           =5;
             KEY_5           =6;
             KEY_6           =7;
             KEY_7           =8;
             KEY_8           =9;
             KEY_9           =10;
             KEY_0           =11;
             KEY_MINUS       =12; { + / amerikkalaisen mallin mukaan - }
             KEY_EQUALS      =13; { ' / amerikkalaisen mallin mukaan - }
             KEY_BACKSPACE   =14;
             KEY_TAB         =15; { sarkain / tabulaattori }
             KEY_Q           =16;
             KEY_W           =17;
             KEY_E           =18;
             KEY_R           =19;
             KEY_T           =20;
             KEY_Y           =21;
             KEY_U           =22;
             KEY_I           =23;
             KEY_O           =24;
             KEY_P           =25;
             KEY_OPENBRACE   =26; {  }
             KEY_CLOSEBRACE  =27; {  }
             KEY_ENTER       =28; { ENTER / Return }
             KEY_CONTROL     =29; { CTRL -nppin }
             KEY_A           =30;
             KEY_S           =31;
             KEY_D           =32;
             KEY_F           =33;
             KEY_G           =34;
             KEY_H           =35;
             KEY_J           =36;
             KEY_K           =37;
             KEY_L           =38;
             KEY_COLON       =39; { ; }
             KEY_QUOTE       =40; { ' / * }
             KEY_TILDE       =41; { ~ /  / ^ }
             KEY_LSHIFT      =42; { Vasen shift }
             KEY_Z           =44;
             KEY_X           =45;
             KEY_C           =46;
             KEY_V           =47;
             KEY_B           =48;
             KEY_N           =49;
             KEY_M           =50;
             KEY_COMMA       =51; { , POINT  }
             KEY_STOP        =52; { . PERIOD }
             KEY_SLASH       =53; { - / _ }
             KEY_RSHIFT      =54; { oikea shift }
             KEY_ASTERISK    =55; { numeronppimistn * }
             KEY_ALT         =56; { ALT / ALTGR }
             KEY_SPACE       =57; { vlilynti }
             KEY_CAPSLOCK    =58;
             KEY_F1          =59;
             KEY_F2          =60;
             KEY_F3          =61;
             KEY_F4          =62;
             KEY_F5          =63;
             KEY_F6          =64;
             KEY_F7          =65;
             KEY_F8          =66;
             KEY_F9          =67;
             KEY_F10         =68;
             KEY_NUMLOCK     =69;
             KEY_SCRLOCK     =70;
             KEY_HOME        =71;
             KEY_UP          =72;
             KEY_PGUP        =73;
             KEY_PAD_MINUS   =74; { numeronppimistn - }
             KEY_LEFT        =75; { nuoli vasemmalle }
             KEY_PAD_5       =76; { numeronppimistn 5 }
             KEY_RIGHT       =77; { nuoli oikealle }
             KEY_PAD_PLUS    =78; { numeronppimistn + }
             KEY_END         =79;
             KEY_DOWN        =80;
             KEY_PGDN        =81;
             KEY_INSERT      =82;
             KEY_DEL         =83;
             KEY_F11         =87;
             KEY_F12         =88;


	 Var KEYS : ARRAY [0..127] OF Boolean;
             OldInt09 : POINTER;


     PROCEDURE NewKbdINT09; interrupt;
     PROCEDURE UnHookInt;

     IMPLEMENTATION

         {$F+}  { Laitetaan FAR CALLS valitsin plle }
         PROCEDURE NewKbdINT09;
           VAR  Highbyte, Lowbyte : BYTE;
           BEGIN
             Highbyte := PORT [$60];
             Keys [Highbyte AND $7f] := (Highbyte <= $7f);
             Lowbyte := PORT [$61];
             PORT[$61] := Lowbyte OR $80;
             PORT[$61] := Lowbyte;
             PORT[$20] := $20;
           END;

         PROCEDURE UnHookInt;
           BEGIN
             MEMW [$0000:$041A]:=MEMW [$0000:$041C];
             SetIntVec (9,addr (oldint09));
           END;

         {$F+}
           VAR KeyCount : Byte;
           BEGIN
             For KeyCount:=0 to 127 do Keys[KeyCount]:=False;
             GetIntVec(9, OldInt09);
             SetIntVec(9, Addr( Newkbdint09 ));
           END.
