Program xdemo;

{
 NAPALM SOFTWARE XMODE-LIBRARY ver. 1.2 DEMO PROGRAM
 """""""""""""""""""""""""""""""""""""""""""""""""""
 This program demonstrates the abilities of our library.
 It shows allmost all of the functions and procedure of
 the library.

 XGRAPH.PAS is written by Antti Virtanen
 Documentations and some portions are written by Tapio ijl

 Copyright (C) Napalm Software 1994.

 Read xmode.txt for distributing rules and license agreement!

 Demo parts:

  -Fill ellipses
  -Ellipses
  -Bars
  -Rectangles
  -Texts
  -Filled polygons
  -Scaled images
  -Viewport
  -Resolution
  -Scrolling
  -Palette
  -Mouse
  -Last words

}


Uses
  crt, xgraph, mouse;

Const
  Mode = 0;                     {360x480 resolution mode, you can change it
  if you want!}
  
  {First the general procedures}
  
  Procedure initxmode;
Begin
  If setxmode (Mode) <> 0 Then Begin
    ClrScr;
    WriteLn ('Impossible to use xmode graphics. Program aborted.');
    Halt (1);
  End;
End;

Procedure flush_keypres;
Var
  c : Char;
Begin
  If KeyPressed Then Repeat
    c := ReadKey;
  Until KeyPressed = False;
End;

Procedure put_rubriken (rubriken : String);
Begin
  SetViewPort (0, 0, xmax, ymax);
  Bar (0, ymax - 30, xmax, ymax, 0, 0);
  hline (0, xmax, ymax - 29, 0, 14);
  hline (0, xmax, ymax, 0, 14);
  bigouttext (10, ymax - 17, 15, 0, rubriken);
  SetViewPort (0, 0, xmax, ymax - 30);
End;

{And now the actual demo_procedures}

Procedure fillellipse_demo;
Begin
  flush_keypres;
  fillscreen (0, 0);
  put_rubriken ('XLIBTP is advanced.');
  Repeat
    FillEllipse (Random (Xmax), Random (Ymax), Random (Xmax ShR 4), Random (Ymax ShR 4), Random (255), 0);
  Until KeyPressed;
End;

Procedure ellipse_demo;
Begin
  flush_keypres;
  fillscreen (0, 0);
  put_rubriken ('It draws all the basic things.');
  Repeat
    Ellipse (Random (Xmax), Random (Ymax), Random (Xmax ShR 4), Random (Ymax ShR 4), Random (255), 0);
  Until KeyPressed;
End;

Procedure bar_demo;
Begin
  flush_keypres;
  fillscreen (0, 0);
  put_rubriken ('This is only bar-demo.');
  Repeat
    Bar (Random (Xmax), Random (Ymax), Random (Xmax), Random (Ymax), Random (255), 0);
  Until KeyPressed;
End;

Procedure rectangle_demo;
Begin
  flush_keypres;
  fillscreen (0, 0);
  put_rubriken ('Fast, aren''t they?');
  Repeat
    Rectangle (Random (Xmax), Random (Ymax), Random (Xmax), Random (Ymax), Random (255), 0);
  Until KeyPressed;
End;

Procedure text_demo;
Begin
  flush_keypres;
  fillscreen (0, 0);
  bigouttext (0, 0, 15, 0, 'XLIBTP 1.2 provides');
  bigouttext (0, 20, 15, 0, 'improved text commands');
  bigouttext (0, 40, 15, 0, 'when compared to GRAPH.TPU');
  bigouttext (0, 60, 15, 0, 'of Borland boyz!-)');
  put_rubriken ('Also user-defined fonts possible.');
  textline (10, 80, xmax , ymax ShR 1, 15, 0, 1, '...As you can see...');
  textline (10, ymax ShR 1, xmax ShR 1, vy2, 14, 0, 0, '...Even two rom fonts...');
  Repeat
  Until KeyPressed;
End;

Procedure fillpoly_demo;
Var
  polybuffer : Array [0..8] Of Word;
Begin
  flush_keypres;
  fillscreen (0, 0);
  put_rubriken ('Filled polygons.');
  Repeat
    polybuffer [0] := Random (xmax);
    polybuffer [1] := Random (ymax);
    
    polybuffer [2] := Random (xmax);
    polybuffer [3] := Random (ymax);
    
    polybuffer [4] := Random (xmax);
    polybuffer [5] := Random (ymax);
    
    polybuffer [6] := Random (xmax);
    polybuffer [7] := Random (ymax);
    
    FillPoly (Random (3) + 1, polybuffer, Random (255), 0);
  Until KeyPressed;
End;

Procedure image_demo;
Var
  imake : Pointer;
  scalar: Real;
  D     : Word;
Begin
  flush_keypres;
  fillscreen (0, 0);
  put_rubriken ('XLIBTP is an enchanced graph utility!');
  bigouttext (0, 0, 15, 0, 'YO! scaling!');
  bigouttext (0, 20, 14, 0, 'XLIBTP provides also');
  bigouttext (0, 40, 14, 0, 'some bitmap scalings.');
  If GetImage (0, 0, 12 * 8, 16, imake, 0) <> 0 Then Exit;
  scalar := 1;
  D := 1;
  Repeat
    If D = 0 Then Begin
      scalar := scalar + 0.01;
      If scalar > 0.95 Then D := 1;
    End
    Else Begin
      scalar := scalar - 0.01;
      If scalar < 0.05 Then D := 0;
      syncretrace;
      {RECTANGLE system which is used to erase the old image has somekind of bug}
      Rectangle ( (xmax ShR 1) - Trunc (scalar * 12 * 4), (ymax ShR 1) - Trunc (scalar * 8), (xmax ShR 1)+Trunc(scalar*12*4),
      (ymax ShR 1) + Trunc (scalar * 8), 0, 0);
    End;
    putscaledimage ( (xmax ShR 1) - Trunc (scalar * 12 * 4), (ymax ShR 1) - Trunc (scalar * 8), scalar, scalar, imake, 0);
    putscaledimage ( (xmax ShR 1) - Trunc (scalar * 12 * 4), (ymax ShR 1) + Trunc (scalar * 8), scalar, scalar, imake, 0);
  Until KeyPressed;
  freeimagemem (imake);
End;

Procedure viewport_demo;
Var
  count : Byte;
Begin
  fillscreen (0, 0);
  put_rubriken ('Definable viewports can be useful!');
  flush_keypres;
  SetViewPort (50, 90, xmax - 50, ymax - 90);
  count := 0;
  Repeat
    Bar (Random (xmax), Random (Ymax), Random (Xmax), Random (Ymax), Random (255), 0);
    filledcircle (Random (Xmax), Random (Ymax), Random (xmax ShR 2), Random (255), 0);
    Inc (count);
    If count > 10 Then
      If vx1 > 10 Then Begin
        Dec (vy1, 2);
        Inc (vy2, 2);
        Dec (vx1, 2);
        Inc (vx2, 2);
        Rectangle (vx1, vy1, vx2, vy2, 14, 0);
        Inc (vy1);
        Dec (vy2);
        Inc (Vx1);
        Dec (vx2);
        count := 0;
      End;
    
  Until KeyPressed;
End;

Procedure palette_demo;
Var
  t : Word;
  b : Byte;
Begin
  b := 0;
  setxmode (0);
  flush_keypres;
  put_rubriken ('XLIBTP has better pal cmds than GRAPH.TPU!');
  For t := 0 To 10 Do
    filledcircle (t * (xmax Div 12) + 20, 30, 20, Lo (t + 1), 0);
  bigouttext (40, 120, 14, 0, 'Hi! Isn''t this fantastic?');
  bigouttext (40, 140, 14, 0, 'And you don''t have to pay anything!');
  bigouttext (40, 160, 14, 0, 'XLIBTP is all freeware.');
  bigouttext (40, 180, 14, 0, 'Read xmode.txt for more information');
  bigouttext (40, 200, 14, 0, 'and license agreement!');
  Repeat
    For t := 0 To 10 Do Begin
      palette_cycle (1, 11, 0);
      Delay (100);
    End;
    setborder (b);
    Inc (b);
    If (B And 16) = 16 Then
      shade_palette (1, 11, Random (30) + 20, Random (30) + 20, 0, Random (40), 0, Random (20) + 30);
  Until KeyPressed;
  pal_fadeout (15);
  setxmode (Mode);
End;

Procedure resolution_demo;
Begin
  setxmode (0);
  put_rubriken ('XLIBTP provides eight different resolutions.');
  flush_keypres;
  Repeat
    Ellipse (Random (xmax), Random (ymax), Random (xmax ShR 1), Random (ymax ShR 2), Random (255), 0);
  Until KeyPressed;
  setxmode (4);
  flush_keypres;
  put_rubriken ('From 360x480 to 320x200.');
  Repeat
    Ellipse (Random (xmax), Random (ymax), Random (xmax ShR 1), Random (ymax ShR 2), Random (255), 0);
  Until KeyPressed;
End;

Procedure scrol_demo;
Var
  D : Byte;
  o : Word;
Begin
  copy_page (0, 1);
  fillscreen (0, 0);
  OutText (0, 0, 14, 0, 'SCROLLING WITH VIRTUAL SCREEN IS EASY!');
  OutText (0, 10, 14, 0, 'AND lINE COMPARE PROVIDES SPLIT SCREEN!');
  OutText (0, 20, 14, 0, 'So don''t wait any longer...');
  OutText (0, 30, 15, 0, 'START USING X-LIBRARY FOR TP IMMEDIATELY!');
  setlinecomp (320);
  flush_keypres;
  D := 0;
  o := 0;
  Repeat
    If D = 0 Then Begin
      Inc (o, 80);
      If o > 400 * 80 Then D := 1;
    End
    Else Begin
      Dec (o, 80);
      If o < 38 * 80 Then D := 0;
    End;
    syncretrace;
    setoffset (o);
  Until KeyPressed;
  setxmode (Mode);
End;

Procedure mouse_demo;
Var
  oldcondition : Byte;
  newcondition : Byte;
Begin
  If initialize_mouse = False Then Exit;
  flush_keypres;
  fillellipse_demo;
  flush_keypres;
  put_rubriken ('Mouse handling is now easy.');
  Repeat
    update_mouse;
    newcondition := 0;
    If leftbutton = True Then newcondition := 2;
    If rightbutton = True Then newcondition := 4;
    If bothbuttons = True Then newcondition := 8;
    If oldcondition <> newcondition Then Begin
      If leftbutton = True Then Begin
        If bothbuttons = False Then put_rubriken ('Left button pressed')
        Else put_rubriken ('Both buttons pressed');
      End
      Else
        If rightbutton = True Then put_rubriken ('Right button pressed')
        Else put_rubriken ('Mouse handling is now easy.');
    End;
    oldcondition := newcondition;
  Until KeyPressed;
End;

Procedure last_demo;
Begin
  TextMode;
  TextAttr := White;
  WriteLn ('It''s time to end!');
  WriteLn;
  TextAttr := LightCyan;
  WriteLn ('More details, read xmode.txt.');
  TextAttr := LightGray;
  WriteLn;
  WriteLn ('Okay now we can start...');
  WriteLn ('Hope you enjoy our library, because it has now took us');
  WriteLn ('so much time to do it.');
  WriteLn ('Now it should be enough fast, it has enchanced drawing');
  WriteLn ('commands etc.. but you can still send us ideas about');
  WriteLn ('"How to do it even better"');
  WriteLn;
  WriteLn ('Thank you for your interests.');
  WriteLn;
  WriteLn ('5.9.1994 Napalm guyz!');
  WriteLn;
End;

Begin
  initxmode;
  SetViewPort (0, 0, xmax, ymax - 30);
  fillellipse_demo;
  ellipse_demo;
  bar_demo;
  rectangle_demo;
  text_demo;
  fillpoly_demo;
  image_demo;
  viewport_demo;
  resolution_demo;
  scrol_demo;
  palette_demo;
  mouse_demo;
  last_demo;
End.

