(* This is a little demo to see how to use Xlib and Bitmaps for animations.

   This demo need the files
      see in names : Array of String  the bitmaps
      u.inc                           the font (while compiling)

   - You can 'move' the Bitmaps in one masterfile Ani_Demo.dat  .
     So you can handle this demo with 2 files only ...

   - Draw with BEX own bitmaps and change the filename in names.

     I had scaned the bitmaps from a comic, converted and zoomed in
     80x50 - pcx-pictures and read/colored with BEX.

*)



(* All these Compiler-directives make the EXE smaller ;-)
   Put this line in {  }  and your errors will be deteteced.             *)

{$D-,K+,O-,Q-,R-,S-,T-,V-,Y-}

uses x_const,  (* Variables like GetMaxX,GetMaxY  or  X_Mode_360x240 and *)
               (* function WaitVsyncStart                                *)
     x_main,   (* x_set_mode,x_text_mode,x_set_clip_rect,x_circle        *)
     x_bitmap, (* x_load_pbm,x_put_pbm_clipx,x_get_pbm_siyeXY            *)
     x_FileIO, (* F_Size,Init_MasterFile,Close_MasterFile                *)
     x_keys,   (* keyspressed                                            *)
     x_Pal,    (* x_set_rgb_pal                                          *)
     x_text,   (* x_text_init,x_register_userfont,x_set_font,E_Write     *)
     x_rect;   (* box                                                    *)

const Bitmaps  = 2;
      names : Array[0..Bitmaps] of String =
              ('ani_pic1.pbm','ani_pic2.pbm','ani_pic3.pbm');
      Frames   = 3;
      Run  : Array[0..Frames] of Byte = (0,1,2,1);

(* Created with FEX   [FNT -> INC] *)
{$I u.inc}

var P:Array[0..Bitmaps] of Pointer;
    Help:Pointer;
    i,i1,j,x:Word;
    s:String;
    Pic_X,Pic_Y:Word;
    dummy:Boolean;
    F:File;
begin;
  if not Init_MasterFile('Ani_Demo.dat') then WriteLn('ANI_DEMO.DAT not found - looking for single Bitmaps.');

  WriteLn('Loading Bitmaps ...');
  (* Search PBM and Load -
     if no PBM found, search PCX, if found load and convert in PBM  *)
  for j:=0 to Bitmaps do
  begin;
    if F_Size(names[j])>0 then
    begin;
      GetMEM(P[j],F_Size(names[j]));
      x_load_pbm(names[j],P[j]^);
    end                   else
    begin;                (* PCX load and convert *)
      i:=F_Size(Only_one_Ext(names[j],'PCX'));
      if i<>0 then i:=x_get_PCX_Size(Only_one_Ext(names[j],'PCX'))
              else begin;WriteLn(names[j]+' not found.');exit;end;

      GetMEM(Help,i);
      fillchar(Help^,i,0);
      if not x_load_pcx_as_lbm(Only_one_Ext(names[j],'PCX'),Help^)
           then begin;WriteLn(names[j]+'-File format error');exit;end;
      if not x_lbm_to_pbm(Help^,P[j]^)
           then begin;WriteLn(names[j]+' converting error');exit;end;
      FreeMEM(Help,i);
    end;
  end;

  (* Get X,Y-resolution for calculating bitmapmove. *)
  x_get_pbm_sizeXY(Pic_X,Pic_Y,P[0]^);

  (* Set mode X , RGB-palette (default in BEX),  ClipX-Window *)
  x_set_mode(X_Mode_360x240,400);
  x_set_rgb_pal;
  x_set_clip_rect(Pic_X+2,0,GetMaxX-Pic_X,400);

  (* Init the userfont. *)
  x_text_init;
  x_register_userfont(font_U);
  x_set_font(2);

  (* Write the title of this little demo . *)
  E_Write(10,10,Gray5,Gray3,center(340,'Der Alte Sack und das kleine Arschloch.'));
  x_write(10,14+x_font_height,Gray2,center(340,'The old slump and the little asshole (german comic).'));

  (* Draw the cinema box. *)
  box(Pic_X,90,GetMaxX-Pic_X+4,110+Pic_Y,Gray5);
  for i:=0 to 19 do
  begin;
    box(Pic_X+4+i*10,92,Pic_X+8+i*10,96,Gray0);
    box(Pic_X+4+i*10,104+Pic_Y,Pic_X+8+i*10,108+Pic_Y,Gray0);
  end;

  x :=GetMaxX-Pic_X;
  j:=0;

  x:=200;

  (* Animate the bitmaps. *)
  while (not keyspressed) do
  begin;
    (* Calcutale X and frameindex .  *)
    Dec(x,2);    if x<2 then x:=GetMaxX-Pic_X;
    Inc(j);
    j:=j mod (frames+1);

    for i:=0 to 5 do WaitVsyncStart;  (* This delay is on every PC the same. *)

    (* Put Bitmap with X-clipping on screen. *)
    x_put_pbm_clipx(x,100,P[Run[j]]^);

  end;

  x_text_mode;

  Close_MasterFile;
  WriteLn('Thanx for watching. (Source in XLib_TP , the mode x units for Turbo Pascal).');
  WriteLn;
  WriteLn('Wer jetzt mehr vom kleinen Arschloch sehen will, sollte sich sofort');
  WriteLn('"Der alte Sack, ein kleines Arschloch und andere Hhepunkte des Kapitalismus",');
  WriteLn('erschienen im Eichborn Verlag, zulegen.');
  WriteLn;
  WriteLn('Also avaible as "little asshole", "Petit Emmerdeur", "Piccolo Stronzo".');

end.
