/*
 * This file contains Application definitions and structures that
 * define the View.
 */

/* 
 * The VIEW structure is the basic display unit of a topic. It contains
 * a scrolling and non-scrolling region (either of which can be empty).
 * It also carries information (HANDLES) on the parent window and the
 * current open title.
 * This structure could be augmented with other layout information 
 * for more complex displays.
 */
/* structure for holding group name/title association */
typedef struct tagGROUP
	{
	char *name;
	char *title;
	} GROUPUI, far * LPGROUPUI;

typedef struct VIEW_tag
	{
	int isOpen;				/* is the View currently open? */
	int isInitial;			/* so we know the first time through */
	HWND hView;				/* the view window itself */
	HWND hSR;				/* the scrolling region window */
	HWND hNSR;				/* the non-scrolling region window */
	HANDLE hTitle;			/* the handle of the title */
	HANDLE hFont;			/* font table for the title */
	HANDLE hFileSys;		/* title file system handle */
	HANDLE hTopicList;	/* search results topic list */
	HANDLE hHighlights;	/* search results highlights list */
	int showHits;			/* show the search highlights? */
	HBRUSH hHitBrush;		/* current brush for search hilights */
	HWHEEL hWordWheel;	/* the current open word wheel */
	int iIndex;				/* the currently open index group number */
	LPGROUPUI lpGroups;	/* group list for the title */
	LPGROUPUI lpKeyIndex;/* list of keyword index groups */
	LPAPPVIEW lpApp;		/* any application specific data */
	} VIEW, far * LPVIEW;

/* these define the offsets to the View data stored in the window structure */
#define GWL_VIEW				0
#define EXTRA_VIEW_SIZE	sizeof(long)

/* and MACROs for getting and setting the window data */
#define GetView(hWnd) (LPVIEW)GetWindowLong(hWnd, GWL_VIEW)
#define SetView(hWnd, lpV) SetWindowLong(hWnd, GWL_VIEW, (long)lpV)

/* is hotspot highlighting turned on? */
extern int bShowHotspots;

/* these define the search limiters */
#define SEARCH_ALL			1
#define SEARCH_GROUPS		2
#define SEARCH_TOPIC		3

/* we need to know where the View_SetTopic call came from */
#define SET_FROM_BACK		0
#define SET_FROM_OTHER		1
#define SET_FROM_PRINT		2
#define SET_FROM_SOURCE	3
#define SET_FROM_WORKAROUND 4

/* the Print Mark List */
typedef struct tagPRINTMARK
	{
	int type;				/* topic, group, or all */
	VA va;					/* topic address */
	int group;				/* group number in group list */
	LPSTR lpName;			/* topic or group name */
	} PRINTMARK, far * LPPRINTMARK;

#define INT int			/* BUGBUG ... until MediaView clarifies
								 * interfaces that have LPINT arguments.
								 */
