VERSION 2.00
Begin Form frmCharStyles 
   BackColor       =   &H00C0C0C0&
   BorderStyle     =   3  'Fixed Double
   Caption         =   "Character Styles"
   ClientHeight    =   2625
   ClientLeft      =   1710
   ClientTop       =   4890
   ClientWidth     =   4890
   Height          =   3150
   Left            =   1650
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   175
   ScaleMode       =   3  'Pixel
   ScaleWidth      =   326
   Top             =   4425
   Width           =   5010
   Begin CommonDialog CMDialog1 
      Left            =   3690
      Top             =   1950
   End
   Begin CommandButton cmdCancel 
      Cancel          =   -1  'True
      Caption         =   "&Cancel"
      Height          =   345
      Left            =   3435
      TabIndex        =   4
      Top             =   1230
      Width           =   1305
   End
   Begin CommandButton cmdFormat 
      Caption         =   "&Format"
      Default         =   -1  'True
      Height          =   345
      Left            =   3435
      TabIndex        =   3
      Top             =   555
      Width           =   1305
   End
   Begin SSPanel pan3dCharStyles 
      BevelOuter      =   1  'Inset
      Height          =   2010
      Left            =   195
      TabIndex        =   1
      Top             =   510
      Width           =   3060
      Begin ListBox lbCharStyles 
         Height          =   1980
         Left            =   15
         Sorted          =   -1  'True
         TabIndex        =   2
         Top             =   15
         Width           =   3030
      End
   End
   Begin Label lblCharStyles 
      BackStyle       =   0  'Transparent
      Caption         =   "C&haracter Styles:"
      Height          =   270
      Left            =   195
      TabIndex        =   0
      Top             =   195
      Width           =   2175
   End
End
Option Explicit

Dim frmgblhFontTable As Integer

Sub cmdCancel_Click ()
    'Hide the form so that execution can continue in calling subroutine
    Me.Visible = False
End Sub

Sub cmdFormat_Click ()
    'Let lbCharStyles_DblClick handle this event
    lbCharStyles_DblClick
End Sub

Sub FillStyleListBox ()
    'This subroutine fills the list box the character styles in the title

    Dim nStyleCount, nTemp1, nTemp2, lpErr As Integer
    Dim nSubSuper As Integer
    Dim szStyleName As String
    Dim lfLogFont As LOGFONT
    Dim rgbFore As RGBTRIPLE
    Dim rgbBack As RGBTRIPLE
    Dim byMoreAttr As String * 1

    'Get the number of styles
    nStyleCount = iCharStyleCount(frmgblhFontTable, lpErr)
    If nStyleCount <> 0 Then
        For nTemp1 = 0 To nStyleCount - 1
            'Initialize the string
            szStyleName = String$(128, 0)
            
            'Get the style name
            nTemp2 = fGetCharStyle(frmgblhFontTable, CInt(nTemp1), szStyleName, lfLogFont, rgbFore, rgbBack, nSubSuper, byMoreAttr, lpErr)
            If nTemp2 <> 0 Then
                'Strip any nulls from right of style name
                If InStr(szStyleName, Chr$(0)) <> 0 Then
                    szStyleName = Left$(szStyleName, InStr(szStyleName, Chr$(0)) - 1)
                End If
                'Add the name of the style and its index into the Font Table to the list box
                lbCharStyles.AddItem szStyleName
                lbCharStyles.ItemData(lbCharStyles.NewIndex) = CLng(nTemp1)
            Else
                'Show an error message
                nTemp2 = MVError(lpErr, "")
            End If
        Next nTemp1
    ElseIf lpErr <> wERRS_NONE Then
        'Show an error message
        nTemp1 = MVError(lpErr, "")
    End If
End Sub

Sub Form_Load ()
    Dim lpMV As Long

    Call WaitCursor
    'Get a valid lpMV
    lpMV = GetValidlpMV(frmMain.MediaView1)
    'Get the handle to the font table
    frmgblhFontTable = hMVGetFontTable(lpMV)
    'Fill the list box with character styles in title
    Call FillStyleListBox
    Me.Move frmMain.Left + 500, frmMain.Top + 800
    'Should be false until a style is selected
    cmdFormat.Enabled = False
    Call DefaultCursor
End Sub

Sub lbCharStyles_Click ()
    'Once a style is selected, enable the Format button
    cmdFormat.Enabled = True
End Sub

Sub lbCharStyles_DblClick ()
    Dim nTemp, lpErr As Integer
    Dim nSubSuper As Integer
    Dim szFontName, szStyleName As String
    Dim lfLogFont As LOGFONT
    Dim rgbFore As RGBTRIPLE
    Dim rgbBack As RGBTRIPLE
    Dim byMoreAttr As String * 1
    
    'Initialize the string
    szStyleName = String$(128, 0)
    'Get the style attributes
    nTemp = fGetCharStyle(frmgblhFontTable, CInt(lbCharStyles.ItemData(lbCharStyles.ListIndex)), szStyleName, lfLogFont, rgbFore, rgbBack, nSubSuper, byMoreAttr, lpErr)
    If nTemp <> 0 Then
        CMDialog1.CancelError = True
        CMDialog1.Flags = CF_EFFECTS Or CF_SCREENFONTS Or CF_ANSIONLY Or CF_FORCEFONTEXIST
        CMDialog1.FontBold = (lfLogFont.lfWeight >= FW_BOLD)
        CMDialog1.FontItalic = (lfLogFont.lfItalic <> Chr$(0))
        CMDialog1.FontSize = lfLogFont.lfHeight
        
        'Strip any nulls from right of style name
        If InStr(szStyleName, Chr$(0)) <> 0 Then
            szStyleName = Left$(szStyleName, InStr(szStyleName, Chr$(0)) - 1)
        End If
        
        'Strip any nulls from right of font name
        If InStr(lfLogFont.lfFaceName, Chr$(0)) <> 0 Then
            szFontName = Left$(lfLogFont.lfFaceName, InStr(lfLogFont.lfFaceName, Chr$(0)) - 1)
        Else
            szFontName = lfLogFont.lfFaceName
        End If
        CMDialog1.FontName = RTrim$(szFontName)
        CMDialog1.Color = RGB(Asc(rgbFore.rgbtRed), Asc(rgbFore.rgbtGreen), Asc(rgbFore.rgbtBlue))
        CMDialog1.FontStrikeThru = (lfLogFont.lfStrikeOut <> Chr$(0))
        CMDialog1.FontUnderLine = (lfLogFont.lfUnderline <> Chr$(0))
        On Error Resume Next
        CMDialog1.Action = 4
        If Err <> CDERR_CANCEL Then
            'They've clicked OK so set the new style
            On Error GoTo 0
            Call SetTextProperties(szStyleName, lfLogFont.lfWeight, rgbBack, byMoreAttr)
        End If
        On Error GoTo 0
    ElseIf lpErr <> wERRS_NONE Then
        'There was an error so show the error message
        nTemp = MVError(lpErr, "")
    End If
End Sub

Sub SetLFFields (lfLogFont As LOGFONT, szFontName As String)
    'This function sets the fields of the logical font
    'It loads a new form because the common dialog VBX doesn't return all the LOGFONT fields
    'of the chosen font.  So, the choices were write another DLL function, or show how to work
    'around the problem using VB.
    
    Dim tm As TEXTMETRIC
    Dim nTemp As Integer

    'This is the hokeyest workaround, but
    'without writing a DLL to return all the lf fields
    'this is the only way I could figure out.
    Load frmTempText
    frmTempText.FontName = szFontName
    frmTempText.FontBold = lfLogFont.lfWeight >= FW_BOLD
    frmTempText.FontItalic = lfLogFont.lfItalic <> Chr$(0)
    frmTempText.FontSize = lfLogFont.lfHeight
    
    'Get the text metrics for the form
    nTemp = GetTextMetrics(frmTempText.hDC, tm)
    If nTemp Then
        'Set the appropriate fields.
        lfLogFont.lfWidth = tm.tmAveCharWidth
        'NOTE: the 0xF0 masks the value to only return the HIBYTE
        lfLogFont.lfPitchAndFamily = Chr$(Asc(tm.tmPitchAndFamily) And &HF0)
    End If
    Unload frmTempText
End Sub

Sub SetTextProperties (szStyleName As String, ByVal lfWeight As Integer, rgbBack As RGBTRIPLE, szMoreAttr As String)
    Dim nTemp, lpErr As Integer
    Dim nSubSuper As Integer
    Dim lfLogFont As LOGFONT
    Dim rgbFore As RGBTRIPLE
    Dim byMoreAttr As String * 1

    'Set the appropriate LOGFONT fields
    If CMDialog1.FontBold Then
        lfLogFont.lfWeight = FW_BOLD
    Else
        lfLogFont.lfWeight = FW_NORMAL
    End If
    lfLogFont.lfItalic = Chr$(Abs(CMDialog1.FontItalic))
    lfLogFont.lfFaceName = CMDialog1.FontName
    lfLogFont.lfHeight = CMDialog1.FontSize
    rgbFore.rgbtRed = Chr$(CMDialog1.Color And &HFF&)
    rgbFore.rgbtGreen = Chr$((CMDialog1.Color And &HFF00&) / &H100&)
    rgbFore.rgbtBlue = Chr$((CMDialog1.Color And &HFF0000) / &H10000)
    lfLogFont.lfStrikeOut = Chr$(Abs(CMDialog1.FontStrikeThru))
    lfLogFont.lfUnderline = Chr$(Abs(CMDialog1.FontUnderLine))
    byMoreAttr = szMoreAttr
    
    'This function sets the fields with values that aren't returned by the common dialog VBX
    Call SetLFFields(lfLogFont, CStr(CMDialog1.FontName))
    
    'Set the character styles
    nTemp = fSetCharStyle(frmgblhFontTable, -1, szStyleName, lfLogFont, rgbFore, rgbBack, 0, byMoreAttr, lpErr)
    If nTemp = 0 Then
        'Show the error message
        nTemp = MVError(lpErr, szStyleName)
    Else
        'Update the MediaView
        Call UpdateMedView(frmMain.MediaView1)
        
        'This is here because the MediaView window does not always paint properly without it.
        frmMain.MediaView1.TopicIndex = frmMain.MediaView1.TopicIndex
    End If
End Sub

