#include <windows.h>
#include <mverror.h>
#include "mvbrkr.h"  
#include "partbrkr.h"

// Static buffers in which raw and normalized part numbers are stored

BYTE abRaw[RAW_PARTLENGTH+1];     // Raw includes space for two hyphens
BYTE abNorm[PARTLENGTH+1];        // Normalized just stores part digits

#define ISDIGIT(c)(((c >= '0') && (c <= '9')))

/****************************************************************************
   FUNCTION: LibMain(HANDLE, WORD, WORD, LPSTR)

   PURPOSE:  Performs initialization tasks required by the DLL. In this 
             case, no initialization is required.
           
*******************************************************************************/
int FAR PASCAL LibMain(hModule, wDataSeg, cbHeapSize, lpszCmdLine)
HANDLE  hModule;
WORD    wDataSeg;
WORD    cbHeapSize;
LPSTR   lpszCmdLine;
{
    return 1;
}


/****************************************************************************
   FUNCTION: BreakPartNumber(LPBRK_PARMS)

   PURPOSE:  Performs word breaking for part numbers. The text to break is
             passed to the lpBrkParms parameter.
             
   RETURN:   Returns zero if successful or an error code otherwise.
           
*******************************************************************************/
int FAR PASCAL BreakPartNumber(LPBRK_PARMS lpBrkParms)
{
    LPBYTE lpb, lpbEnd;                 // Beginning and end of topic text
    LPBYTE lpbRaw, lpbNorm;             // Beginning of part number text
    LPBYTE lpcbRaw, lpcbNorm;           // Count of word length
    int i;
    int nRet;
    
    int  nState;
    DWORD dwCurOffset;                // Offset of part # from topic start

    // Initialize some variables    
    
    lpb = lpBrkParms->lpbBuf;               // Current text position
    lpbEnd = lpb + lpBrkParms->nBufCount;   // End of text buffer

    lpcbRaw = &abRaw[0];                    // Count byte for raw word
    lpcbNorm = &abNorm[0];                  // Count byte for normalized word
    lpbRaw  = &abRaw[1];                    // Current raw word position
    lpbNorm = &abNorm[1];                   // Current normalized word position

    nState = STATE_WHITE;                   // Parsing state
    
    // First check if buffer is null. If so, just return.
    
    if(lpb == NULL)
        return 0;
    
    // This loop walks through the text buffer, breaking all the part numbers
    // contained therein. Two states are recognized:
    // 
    // STATE_WHITE: Not in a part number.
    // STATE_PART:  In a part number.
    //
    // While in STATE_WHITE, we just continue to skip characters.
    // While in STATE_PART, we add part-number digits to the raw and normalized
    // text buffers.
    //
    // Most of the interesting activity occurs when changing states. See the
    // following comments for details.

    for(nState = STATE_WHITE; lpb < lpbEnd; lpb++)
    {
        // In a part number?
        
        if(ISDIGIT(*lpb) || *lpb == '-')
        {
            // If we're going from whitespace to a part number,
            // initialize a new part number.
            
            if(nState == STATE_WHITE)
            {
                // Can't start with a hyphen.
                
                if(*lpb == '-')
                    return ERR_BADFORMAT;
                    
                *lpcbRaw = 0;
                *lpcbNorm = 0;
                dwCurOffset = lpBrkParms->dwBufOffset + (lpb - lpBrkParms->lpbBuf);
                
                for(i = 0; i < PARTLENGTH; i++)
                    lpbNorm[i] = '0';
                
                nState = STATE_PART;
            }
            else
            {
                // Check for overflow.
                
                if(*lpcbNorm == PARTLENGTH)
                    return ERR_BADVALUE;
            }
            
            // Store the part number.
            
            if(*lpb == '-')
            {
                // Hyphens are only allowed in positions 2 and 5
                
                if(*lpcbNorm == 2 || *lpcbNorm == 5)
                    lpbRaw[(*lpcbRaw)++] = *lpb;
                else
                    return ERR_BADFORMAT;
            }
            else
            {
                // Add a digit to the part
                
                lpbRaw[(*lpcbRaw)++] = *lpb;
                lpbNorm[(*lpcbNorm)++] = *lpb;
            }
        }
        else
        {
            // If we're going from a part number to white
            // space, store the last part number.
            
            if(nState == STATE_PART)
            {
                // Store the part number
                
                *lpcbNorm = PARTLENGTH;
                    
                if(*lpBrkParms->lpfnOutWord)
                {
                    nRet = (*lpBrkParms->lpfnOutWord)(abRaw, abNorm, 
                        dwCurOffset, lpBrkParms->dwCBParm);
                    if(nRet)
                        return nRet;
                }
                        
                nState = STATE_WHITE;
            }
        }
    }
    
    if(nState == STATE_PART)
    {
        // Store the part number
                
        *lpcbNorm = PARTLENGTH;
                    
        if(*lpBrkParms->lpfnOutWord)
        {
            nRet = (*lpBrkParms->lpfnOutWord)(abRaw, abNorm, 
                dwCurOffset, lpBrkParms->dwCBParm);
            if(nRet)
                return nRet;
        }
    }
    
    return 0;
}

