;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;   Copyright (c) 1995 Xcentrics Incorporated All Rights Reserved
;
;   Assembly code for removing a TSR from memory.
;
;   The file was assembled using A86.COM, a shareware program 
;   produced by Eric Isaacson (812-339-1811).  
;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

     jmp DoIt            ;Off to code

Mess1 db 0dh,0ah,"Is the TSR tied into the DOS timer (Y/y = Yes)?",0dh,0ah,'$'
Mess2 db 0dh,0ah,"Enter the interrupt (in hex) that the TSR is tied to (must be 2 chars)?",0dh,0ah,'$'
Mess3 db 0dh,0ah,"Is this correct (Y/y = Yes)?",0dh,0ah,'$'
Mess4 db 0dh,0ah,"The TSR was always active and could not be removed$"
IntAddr dd 0             ;address of routine

DoIt:
     mov ah,09
     mov dx,offset Mess1
     int 021             ;Ask if tied into timer
     mov ah,01
     int 021             ;Get a key
     cmp al,01b
     jne > L0
     jmp Quit            ;ESC pressed
L0:
     or al,020h          ;Convert to lower case
     cmp al,'y'          
     jne UndoTsr         ;Not tied into timer
     mov al,01ch         ;Releasing from timer
     jmp ReleaseIt
          
UndoTsr:
     mov ah,09
     mov dx,offset Mess2
     int 021h             
     mov ah,01
     int 021             ;Get first character
     cmp al,01b
     je Quit             ;ESC pressed
     mov bx,ax           ;save it
     int 021h            ;now second
     cmp al,01b
     je Quit             ;ESC pressed
     mov cx,ax
     mov ah,09
     mov dx,offset Mess3
     int 021h
     mov ah,01
     int 021h            ;ask if input correct
     cmp al,01b
     je Quit             ;ESC pressed
     or al,020h          ;convert to lower case
     cmp al,'y'          
     jne UndoTsr         ;input wrong value
     call AsciiToHex

ReleaseIt:
     mov ah,035h         ;al has interrupt number
     int 021h            ;get address
     mov cx,8            ;waiting 8 ticks or about 1 sec
     mov bx,0130
     xor dx,dx
     mov ds,dx
     mov di,046c         ;address of tick
     mov dx,[di]
L0:
     cmp [di],dx
     je L0               ;wait for tick to change
     inc dx              ;next tick
L0:
     cmp es:b[bx],0
     je > L1
     cmp [di],dx
     je L0              ;tick didn't change
     inc dx             ;next tick
     loop L0
     push cs
     pop ds
     mov ah,09
     mov dx,offset Mess4
     int 021h           
     jmp Quit    
L1:
     mov es:b[bx],1
     push cs
     pop ds
     mov bx,offset IntAddr
     mov w[bx],01a6h
     mov ax,es
     mov [bx+2],ax       ;address set
     mov bx,-1
     mov ds,bx           ;set up flags
L0:
     pushf               ;simulate interrupt call
     call cs:[IntAddr]   ;release it
Quit:
     int 020h            ;back to DOS

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;              AsciiToHex
;
;Changes the ASCII values in bl and cl to hex and puts them in al.
;Value in cl is low nibble, bl is high.
;
;    Passed  - Values in bl and cl
;    Returns - al with converted values
;    Destroyed - May be all
;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
AsciiToHex:
     mov ah,cl
     mov cx,2
L0:
     cmp ah,'9'
     ja > L1             ;it > 9
     and ah,0fh          ;now 0 - 9
     jmp > L2
L1:
     inc ah
     or ah,08h
     and ah,0f           ;now A - F
L2:
     dec cx
     jz > L3             ;jmp if all done
     mov al,ah           ;low nibble to al
     mov ah,bl           ;next value
     jmp L0
L3:
     mov cl,04
     shl ah,cl           ;get it into right position
     or al,ah            ;put em together
     ret
 
