.section .bootload
.globl __bootloader_entry
.globl __vector_nmi
.globl __vector_lvl_1
.globl __vector_lvl_0

__bootloader_entry:

	//turn ints off for now
	cli
	
	//init r1 and SREG
	clr  r1
	out  0x3F, r1	//SREG

	//point stack to end of RAM minus 1
	ldi  r31, 0x3f
	ldi  r30, 0xff
	out  0x3E, r31	//SPH
	out  0x3D, r30	//SPL
	
	ldi  r29, hi8(__update_start)
	ldi  r28, lo8(__update_start)
	//see if we need to copy
	ldd  r30, Y + 2
	ldd  r31, Y + 3
	cpi  r30, 'D'
	brne boot_app
	cpi  r31, 'G'
	brne boot_app
	
	//setup and do the copy
	ldi  r31, hi8(__app_start)
	ldi  r30, lo8(__app_start)
	ldi  r27, lo8(__app_pages)
	ldi  r16, 0x9D
	ldi  r17, 4
	mov  r15, r17
	subi r17, 1

pages_loop:
	ldi  r18, 64
	ldi  r19, 1			//bool "same"
	movw r2, r28
	movw r4, r30
bytes_loop:
	ld   r20, Z+
	ld   r21, Y+
	cpse r20, r21
	ldi  r19, 0
	dec  r18
	brne bytes_loop
byte_loop_over:			//by now r18 is guaranteed to be zero
	cpse r19, r18		//skip if page needs write!
	rjmp page_copy_done

perform_copy:

	//wait for busy
	rcall eewait

	sts  0x0034, r16	//CCP
	sts  0x1000, r15	//NVMCTRLA = clear pagebuffer

	rcall eewait

	movw r30, r4
	movw r28, r2
	ldi  r18, 64
byte_load_loop:
	ld   r20, Y+
	st   Z+, r20
	dec  r18
	brne byte_load_loop
nvm_erz_wri:
	sts  0x0034, r16	//CCP
	sts  0x1000, r17	//NVMCTRLA = erase and write page

	rcall eewait

page_copy_done:
	dec  r27
	brne pages_loop

copy_done:
	//if we copied the app, erase staging area
	ldi  r29, hi8(__update_start)
	ldi  r28, lo8(__update_start)
	ldi  r27, lo8(__app_pages)
	ldi  r26, 2
erz_loop:
	st   Y, r27		//value written is irrelevant
	sts  0x0034, r16	//CCP
	sts  0x1000, r26	//NVMCTRLA = erase page
	rcall eewait
	
	subi  r28, -64		//increment Y by 64
	sbci  r29, -1
	
	dec   r27
	brne  erz_loop
	
	//if we applied an update, reset chip to come back to a sane state in terms of internal reg state (next boot will not see update as we just erased it)
	ldi  r16, 0xD7		//CCP_IOREG_gc
	ldi  r17, 1			//to reset chip
	sts  0x0034, r16	//CCP
	sts  0x0041, r17

1:
	rjmp 1b
	
	
boot_app:

	//clear all of ram (easier than clearing just .bss)
	ldi  r29, 0x3f
	ldi  r28, 0x00
1:
	st   Y, r1
	inc  r28
	brne 1b

	rjmp __app_reset_vector


eewait:
	push  r20
1:
	lds   r20, 0x1002
	sbrc  r20, 0
	rjmp  1b
	pop   r20
	ret





.section .crt

__app_reset_vector:
	
	//r1 is already 0 from bootloader, sp is already at top of ram
	//we assume we have no .data section (and we do not init it thus)
	//bootloader zeroes all of ram, so no need to clear bss either
	rjmp  main


__j_vector_nmi:
	.byte 'D'				// magic to indicate a valid image of byte offset 2 & 3
	.byte 'G'				//here in place of nmi vector since we never expect any NMIs

__j_vector_lvl_1:
	rjmp __vector_lvl_1
__j_vector_lvl_0:
	rjmp __vector_lvl_0

	