#define _XTAL_FREQ	4000000
#include <htc.h>

__CONFIG(OSC_IntRC & WDT_ON & CP_OFF & MCLRE_OFF);
typedef unsigned short UInt16;
typedef unsigned char UInt8;
//output RA2

#define OUTPUT					GP2
#define DELAY_FUDGE_FACTOR		38		//for all delays
#define LAST_DELAY_FUDGE_FACTOR	20		//for delays after last byte

#define CY  OUTPUT = 1; __delay_us(11); OUTPUT = 0; __delay_us(11);

void on(){
	CY CY CY CY CY CY CY
	CY CY CY CY CY CY
	CY CY CY CY CY CY
}


void byte(UInt8 v){

	UInt8 m = 0x80;

	do{
		on();
		__delay_us(500 - DELAY_FUDGE_FACTOR - LAST_DELAY_FUDGE_FACTOR);
		if(!(m & 1)) __delay_us(LAST_DELAY_FUDGE_FACTOR);
		if(v & m) __delay_us(1000);
		m >>= 1;
	}while(m);
	asm("clrwdt");
}

#define PACKET_LEN			6
#define BTN_INVALID			0xFF
#define IS_A_BTN_PRESSED	((GPIO & 0b1011) != 0b1011)
#define OPTION_CFG			0b00001101		//pullups on, wakeup on


UInt8 getBtn(void){

	UInt8 ret, num = 0;

	if(!GP0){

		ret = 0;
		num++;
	}

	if(!GP1){

		ret = 1;
		num++;
	}

	if(!GP3){

		ret = 2;
		num++;
	}

	return (num == 1) ? ret : BTN_INVALID;
}

void main(void){

	UInt8 packet[PACKET_LEN + 1] = {'A','B','L','1', 0, 0};	//UInt32 dst = 'ABL1', UInt16 button = 0..2 {pwr,down,up}
	UInt8 i, crc = 0;

	OPTION	= 0b10000000 | OPTION_CFG;	//wakeup off
	GPIO	= 0b00000000;
	asm(" MOVLW ~((1<<2) | (1 << 5))");
	asm(" TRIS _GPIO");

	if(!nTO){	//WDT timeout

		for(i = 0; i < 50; i++){

			GP5 = 1;
			__delay_us(1);
			GP5 = 0;
			__delay_us(100);
		}
		GP5 = 0;
	}
	else if(GPWUF){

		if(IS_A_BTN_PRESSED){	//only on wakeup from GPx going low [btn down] do we need to do this

			const UInt8 initialDelay = 70;
			const UInt8 normalDelay = 5;
			UInt8 delay = initialDelay;
			UInt8 btn;
		
			while((btn = getBtn()) != BTN_INVALID){
	
				packet[5] = btn;
	
				crc = 0;
				for(i = 0; i < PACKET_LEN; i++){
					
					UInt8 j, t = packet[i];
					for(j = 0; j < 8; j++, t <<= 1){
			
						crc = (crc << 1) ^ (((t ^ crc) & 0x80) ? 0x83 : 0);
					}
				}
				
				packet[PACKET_LEN] = crc;
				
				byte(0xFF);	//preamble
				byte(0x06);	//header: (5 = mood light, 6 = remote)
				for(i = 0; i <= PACKET_LEN; i++) byte(packet[i]);
				byte(0xFF);	//trailer
		
				while(delay--){
					
					__delay_ms(10);
					asm("clrwdt");
				}
				delay = normalDelay;
			}
		}
		GPWUF = 0;
	}
	
	i = GPIO;					//needed before sleep instr
	OPTION = OPTION_CFG;
	asm("SLEEP");
}
