.globl stack_start
.globl start
.globl __bss_start
.globl __bss_end
.set noreorder
.set noat


#include "../hypercall.h"

.globl entry
.section .vecs
entry:
#ifdef SELF_LOAD
	//we are either calling ourselves the first time or second, first time will be at the wrong
	// address (0x80000000) and require PIC technique and fitting into one sector
	//load first 32 sectors to 0x80001000, then jump to real_start
	li    $s0, 0x00001000
	li    $s1, 0
	li    $s2, 32
1:
	move  $a0, $s1
	bal   readblock
	move  $a1, $s0
	addiu $s1, 1
	bne   $s1, $s2, 1b
	addiu $s0, 512
	
	la    $s0, real_start
	jr    $s0
	nop

#endif

.globl real_start
real_start:
	la    $sp, stack_start	//setup SP
	mfc0  $t0, $12		//12 = status
	ori   $t0, $t0, 3	//ints off, kernel mode
	xori  $t0, $t0, 3
	mtc0  $t0, $12		//12 = status
	la    $t0, __bss_start
	la    $t1, __bss_end
1:
	beq   $t0, $t1, start
	addiu $t0, 4
	bal   1b
	sw    $zero, -4($t0)

//also in .vec to fit into ferst sector in case of "SELF_LOAD"
.globl readblock
readblock:		//(a0 = block number, a1 = destination PA)
	li    $at, H_STOR_READ
	jr    $ra
	.word HYPERCALL


.section .text
.globl getStoreSz
getStoreSz:
	li    $at, H_STOR_GET_SZ
	jr    $ra
	.word HYPERCALL

.globl getMemMap
getMemMap:
	li    $at, H_GET_MEM_MAP
	jr    $ra
	.word HYPERCALL

.globl consoleWrite
consoleWrite:
	li    $at, H_CONSOLE_WRITE
	jr    $ra
	.word HYPERCALL

.globl writeblock
writeblock:		//(a0 = block number, a1 = source PA)
	li    $at, H_STOR_WRITE
	jr    $ra
	.word HYPERCALL
	



.balign 32

.globl memcpy
memcpy:		//(a0 = dst, a1 = src, a2 = len)
	beqz  $a2, 1f
	move  $v0, $a0
	
	or    $v1, $a0, $a1
	andi  $v1, $v1, 3
	bnez  $v1, byteloop

	srl   $v1, $a2, 2
	andi  $a2, $a2, 3

.balign 32	//should be a single nop

wordloop:
	beqz  $v1, byteloop
	addiu $v1, $v1, -1
	lw    $a3, 0($a1)
	sw    $a3, 0($a0)
	addiu $a1, $a1, 4
	b     wordloop
	addiu $a0, $a0, 4

byteloop:
	beqz  $a2, 1f
	addiu $a2, $a2, -1
	lbu   $a3, 0($a1)
	sb    $a3, 0($a0)
	addiu $a1, $a1, 1
	b     byteloop
	addiu $a0, $a0, 1
1:
	jr    $ra
	nop

.globl strcmp
strcmp:		//(a0 = str1, a1 = str2)
	lbu   $a2, 0($a0)
	beqz  $a2, 1f
	lbu   $a3, 0($a1)
	beqz  $a3, 1f
	addiu $a0, $a0, 1
	bne   $a2, $a3, 1f
	addiu $a1, $a1, 1
	b     strcmp
	nop
	
1:
	jr    $ra
	sub   $v0, $a2, $a3

.globl memset
memset:		//a0 = dst, a1 = byte, a2 = len

	//save dst for return
	move  $v0, $a0

	//expand provided byte into word ($a1)
	sll	  $v1, $a1, 8
	addu  $v1, $a1
	sll   $a1, $v1, 16
	addu  $a1, $v1

	//align to word boundary
memset_align:
	andi  $v1, $a0, 3
	beqz  $v1, memset_aligned
	nop
	beqz  $a2, memset_done
	addiu $a2, -1
	sb    $a1, 0($a0)
	b     memset_align
	addiu $a0, 1

memset_aligned:
	srl   $v1, $a2, 5		//have at least 32?
	beqz  $v1, memset_small_check
	nop

memset_big:
	sw    $a1, 0($a0)
	sw    $a1, 4($a0)
	sw    $a1, 8($a0)
	sw    $a1, 12($a0)
	sw    $a1, 16($a0)
	sw    $a1, 20($a0)
	sw    $a1, 24($a0)
	sw    $a1, 28($a0)
	addiu $v1, -1
	bnez  $v1, memset_big
	addiu $a0, 32

	andi  $a2, 31
	b     memset_small_check

memset_small:
	sb    $a1, 0($a0)
	addiu $a2, -1

memset_small_check:
	bnez  $a2, memset_small
	addiu $a0, 1

memset_done:
	jr    $ra
	nop


.globl callWithGpVal
callWithGpVal:
	.set noreorder
	lw  $v0, 0x14($sp)
	jr  $v0
	lw  $gp, 0x10($sp)
