#include <string.h>
#include "printf.h"
#include "util.h"
#include "vfs.h"

#define PROGRESS_BAR_WIDTH		40
#define PROGRESS_USABLE_WIDTH	(PROGRESS_BAR_WIDTH - 2)

static void showProgress(uint32_t done, uint32_t of)
{
	unsigned i, bars = done * PROGRESS_USABLE_WIDTH / of, percent = done * 100 / of, numberWidth, textWidth, textPos;
	char x[PROGRESS_USABLE_WIDTH];

	for (i = 0; i < bars; i++)
		x[i] = '=';
	for(;i < PROGRESS_USABLE_WIDTH; i++)
		x[i]= '-';

	if (percent < 10)
		numberWidth = 1;
	else if (percent < 100)
		numberWidth = 2;
	else
		numberWidth = 3;

	textWidth = numberWidth + 3;	//space before, space after, percent sign
	textPos = (PROGRESS_USABLE_WIDTH - textWidth) / 2;
	
	x[textPos++] = ' ';
	textPos += numberWidth;
	do {
		x[--textPos] = '0' + percent % 10;
		percent /= 10;
	} while (percent);
	textPos += numberWidth;
	x[textPos++] = '%';
	x[textPos++] = ' ';
	
	prPutchar('\r');
	prPutchar('[');
	for (i = 0; i < PROGRESS_USABLE_WIDTH; i++)
		prPutchar(x[i]);
	prPutchar(']');
}

bool copyWithProgress(void *dst, struct VfsFile *src, uint32_t len)
{
	uint32_t j, now;

	for (j = 0; j < len; j += now) {
		
		now = len - j;
		if (now > 32768)
			now = 32768;
		showProgress(j, len);
				
		if (now != vfsFileRead(src, ((char*)dst) + j, now))
			return false;
	}
	showProgress(j, len);
	pr("\n");
	
	return true;
}

void zeroWithProgress(void *dst, uint32_t len)
{
	uint32_t j, now;

	for (j = 0; j < len; j += now) {
		
		now = len - j;
		if (now > 32768)
			now = 32768;
		showProgress( j, len);
		memset(((char*)dst) + j, 0, now);
	}
	showProgress(j, len);
	pr("\n");
}

int strcasecmp(const char *s1, const char *s2)
{
	char c1, c2;
	
	do{
		c1 = *s1++;
		c2 = *s2++;
		
		if (c1 >= 'a' && c1 <= 'z')
			c1 += 'A' - 'a';
		if (c2 >= 'a' && c2 <= 'z')
			c2 += 'A' - 'a';
		
	} while (c1 && c2 && c1 == c2);
		
	return c1 - c2;
}
