#ifndef _APP_H_
#define _APP_H_

#include <htc.h>

#define PIC16F1823
#define CONST_BRI		//slower though

#ifdef PIC18F1823
	#define _XTAL_FREQ 33000000
	#define DOUBLE_BUFFER
#else
	#define _XTAL_FREQ 9000000
	#define DOUBLE_BUFFER
#endif


#define RTC_TICKS_PER_SEC  50

typedef unsigned char UInt8;
typedef unsigned short UInt16;
typedef unsigned long UInt32;

typedef signed char Int8;
typedef signed short Int16;
typedef signed long Int32;

typedef unsigned char Boolean;

#define true 1
#define false 0

#define WIDTH	10
#define HEIGHT	11


//api for app to use
UInt8* appBufGet(Boolean back);
void appBufFlip(void); // flip meaning of front and back buf (fast)
void appBufCopy(void); // copy back buffer to front (slower)
UInt8 appGetFrameNo(void);
UInt16 appGetRand();		//SLOW!!!
UInt32 appReadRtc(void);	//in iterations of 1/10 sec from boot

//app's entry point
void appIgor(void);
void appFire(void);
void appMarquee(const char* str);
void appLife(UInt16* started, UInt16* born, UInt16* died, UInt16* generations, UInt32* livedTime);

#endif
