/*


#include "app.h"


Int8 get_rand(Int8 min, Int8 max);
void advance_ball(void);		


#define ON 1
#define OFF 0
#define ROWS 11
#define COLS 10
#define STRIDE COLS

#define PADDLE_LENGTH 5
#define PUCK_SIZE 1

UInt8 convert_2d_to_1d(UInt8 x, UInt8 y)
{
    return  ((y)*STRIDE+(x));
}

void set_pixel(UInt8 x, UInt8 y, UInt8 on)
{
    UInt8 arrayPos = convert_2d_to_1d(x,y);
	UInt8 mask;
	UInt8* img_b = appBufGet(1);

	mask = 1 << (arrayPos & 7);
	arrayPos >>= 3;

	if(on) 
		img_b[arrayPos] |= mask;
 	else 
		img_b[arrayPos] &= ~mask;
}

#define CLAMP(a, b, x) ((x) < (a)) ? (a) : ( ((x) > (b)) ? (b) : (x));

#define MAX_X (COLS-1)
#define MAX_Y (ROWS-1)
UInt8 cur_x = 0;
UInt8 cur_y = 0;
void run_frame(void)
{

	advance_ball();
}

Int8 pos_x, pos_y;
Int8 vel_x, vel_y;
void init_ball(void)
{
	pos_x = get_rand(0, MAX_X);
	pos_y = get_rand(0, MAX_Y);
	
	vel_x = 0;
	vel_y = 0;

	while (vel_x == 0)
		vel_x = get_rand(-MAX_X/4, MAX_X/4);
	
	while(vel_y == 0)
		vel_y = get_rand(-MAX_Y/4, MAX_Y/4);
}

void advance_ball(void)
{
    set_pixel(pos_x, pos_y, OFF);
	

	pos_x = CLAMP(0, MAX_X, pos_x + vel_x);
	pos_y = CLAMP(0, MAX_Y, pos_y + vel_y);


	// do collision detection and handling
	if (pos_x <= 0 || pos_x >= MAX_X)
	{
		// handle collision for x
		vel_x = -vel_x;
	}
	if (pos_y <= 0 || pos_y >= MAX_Y)
	{
		vel_y = -vel_y;
	}

	set_pixel(pos_x, pos_y, ON);

}

Int8 get_rand(Int8 min, Int8 max)
{
	UInt16 v = appGetRand();
	UInt8 range = max - min;

	return (v % range) + min;
}


void appGoIgor(void){

    UInt8 old_clk = 0;
	
	init_ball();
	while(1){
		if (old_clk != appGetFrameNo())
		{
			run_frame();
			appBufCopy();
			old_clk = appGetFrameNo();
		}
	}
}


*/