#ifndef _MKE_H_
#define _MKE_H_



/** Interrupt Number Definitions */
#define NUMBER_OF_INT_VECTORS 48                 /**< Number of interrupts in the Vector table */

typedef enum IRQn {
  /* Auxiliary constants */
  NotAvail_IRQn                = -128,             /**< Not available device specific interrupt */

  /* Core interrupts */
  NonMaskableInt_IRQn          = -14,              /**< Non Maskable Interrupt */
  HardFault_IRQn               = -13,              /**< Cortex-M0 SV Hard Fault Interrupt */
  SVCall_IRQn                  = -5,               /**< Cortex-M0 SV Call Interrupt */
  PendSV_IRQn                  = -2,               /**< Cortex-M0 Pend SV Interrupt */
  SysTick_IRQn                 = -1,               /**< Cortex-M0 System Tick Interrupt */

  /* Device specific interrupts */
  Reserved16_IRQn              = 0,                /**< Reserved interrupt */
  Reserved17_IRQn              = 1,                /**< Reserved interrupt */
  Reserved18_IRQn              = 2,                /**< Reserved interrupt */
  Reserved19_IRQn              = 3,                /**< Reserved interrupt */
  Reserved20_IRQn              = 4,                /**< Reserved interrupt */
  FTMRE_IRQn                   = 5,
  PMC_IRQn                     = 6,                /**< Low-voltage detect, low-voltage warning */
  IRQ_IRQn                     = 7,
  I2C0_IRQn                    = 8,                /**< I2C0 interrupt */
  Reserved25_IRQn              = 9,                /**< Reserved interrupt */
  SPI0_IRQn                    = 10,               /**< SPI0 single interrupt vector for all sources */
  Reserved27_IRQn              = 11,               /**< Reserved interrupt */
  UART0_IRQn                   = 12,               /**< UART0 status and error */
  Reserved29_IRQn              = 13,               /**< Reserved interrupt */
  Reserved30_IRQn              = 14,               /**< Reserved interrupt */
  ADC0_IRQn                    = 15,               /**< ADC0 interrupt */
  ACMP0_IRQn                   = 16,               /**< ACMP0 interrupt */
  FTM0_IRQn                    = 17,               /**< FTM0 single interrupt vector for all sources */
  Reserved34_IRQn              = 18,               /**< Reserved interrupt */
  FTM2_IRQn                    = 19,               /**< FTM2 single interrupt vector for all sources */
  RTC_IRQn                     = 20,               /**< RTC alarm */
  ACMP1_IRQn                   = 21,               /**< ACMP1 interrupt */
  PIT_CH0_IRQn                 = 22,
  PIT_CH1_IRQn                 = 23,
  KBI0_IRQn                    = 24,
  KBI1_IRQn                    = 25,
  Reserved42_IRQn              = 26,               /**< Reserved interrupt */
  ICS_IRQn                     = 27,
  WDOG_IRQn                    = 28,
  PWT_IRQn                     = 29,
  Reserved46_IRQn              = 30,               /**< Reserved interrupt */
  Reserved47_IRQn              = 31,               /**< Reserved interrupt */
} IRQn_Type;


#define __CM0PLUS_REV                  0x0000    /**< Core revision r0p0 */
#define __MPU_PRESENT                  0         /**< Defines if an MPU is present or not */
#define __VTOR_PRESENT                 1         /**< Defines if an MPU is present or not */
#define __NVIC_PRIO_BITS               2         /**< Number of priority bits implemented in the NVIC */
#define __Vendor_SysTickConfig         0         /**< Vendor specific implementation of SysTickConfig is defined */

#include "core_cm0plus.h"              /* Core Peripheral Access Layer */

struct MkeFtmType {
	volatile uint32_t SC;
	volatile uint32_t CNT;
	volatile uint32_t MOD;
	struct {	//warning: readnig past chan 6 WILL fuck you up
		volatile uint32_t CxSC;
		volatile uint32_t CxV;
	} chans[8];
	volatile uint32_t CNTIN;
	volatile uint32_t STATUS;
	volatile uint32_t MODE;
	volatile uint32_t SYNC;
	volatile uint32_t OUTINIT;
	volatile uint32_t OUTMASK;
	volatile uint32_t COMBINE;
	volatile uint32_t DEADTIME;
	volatile uint32_t EXTTRIG;
	volatile uint32_t POL;
	volatile uint32_t FMS;
	volatile uint32_t FILTER;
	volatile uint32_t FLTCTRL;
	uint32_t reserved;
	volatile uint32_t CONF;
	volatile uint32_t FLTPOL;
	volatile uint32_t SYNCCONF;
	volatile uint32_t INVCTRL;
	volatile uint32_t SWOCTRL;
	volatile uint32_t PWMLOAD;
};

struct MkePortType {
	volatile uint32_t IOFLT;
	volatile uint32_t PUEL;
	uint32_t reserved[0];
	volatile uint32_t HDRIVE;
};

struct MkeGpioType {
	volatile uint32_t PDOR;                              /**< Port Data Output Register, offset: 0x0 */
	volatile uint32_t PSOR;                              /**< Port Set Output Register, offset: 0x4 */
	volatile uint32_t PCOR;                              /**< Port Clear Output Register, offset: 0x8 */
	volatile uint32_t PTOR;                              /**< Port Toggle Output Register, offset: 0xC */
	volatile uint32_t PDIR;                              /**< Port Data Input Register, offset: 0x10 */
	volatile uint32_t PDDR;                              /**< Port Data Direction Register, offset: 0x14 */
	volatile uint32_t PIDR;                              /**< Port Inout Disable Register, offset: 0x18 */
};

struct MkePitType {
	volatile uint32_t MCR;
	uint32_t reserved[0x3f];
	struct {
		volatile uint32_t LDVAL;
		volatile uint32_t CVAL;
		volatile uint32_t TCTRL;
		volatile uint32_t TFLG;
	}timer[2];
};

struct MkeWdogType {
	volatile uint8_t CS1;
	volatile uint8_t CS2;
	union {
		struct {
			volatile uint8_t CNTH;
			volatile uint8_t CNTL;
		};
		volatile uint16_t CNT;
	};
	union {
		struct {
			volatile uint8_t TOVALH;
			volatile uint8_t TOVALL;
		};
		volatile uint16_t TOVAL;
	};
	union {
		struct {
			volatile uint8_t WINH;
			volatile uint8_t WINL;
		};
		volatile uint16_t WIN;
	};
};

struct MkeSimType {
	volatile uint32_t SRSID;
	volatile uint32_t SOPT;
	volatile uint32_t PINSEL;
	volatile uint32_t SCGC;
	volatile uint32_t UUIDL;
	volatile uint32_t UUIDML;
	volatile uint32_t UUIDMH;
	volatile uint32_t CLKDIV;
};

struct MkeIcsType {
	volatile uint8_t C1;
	volatile uint8_t C2;
	volatile uint8_t C3;
	volatile uint8_t C4;
	volatile uint8_t S;
};

struct MkeFtmreType {
	volatile uint8_t reserved0;
	volatile uint8_t FCCOBIX;
	volatile uint8_t FSEC;
	volatile uint8_t FCLKDIV;
	uint8_t reserved1;
	volatile uint8_t FSTAT;
	uint8_t reserved2;
	volatile uint8_t FCNFG;
	volatile uint8_t FCCOBLO;
	volatile uint8_t FCCOBHI;
	uint8_t reserved3;
	volatile uint8_t FPROT;
	uint8_t reserved4[3];
	volatile uint8_t FOPT;
};

struct MkeUartType {
	volatile uint8_t BDH;
	volatile uint8_t BDL;
	volatile uint8_t C1;
	volatile uint8_t C2;
	volatile uint8_t S1;
	volatile uint8_t S2;
	volatile uint8_t C3;
	volatile uint8_t D;
};


#define FTMRE		((struct  MkeFtmreType*) 0x40020000ul)
#define PIT			((struct  MkePitType*)   0x40037000ul)
#define FTM0		((struct  MkeFtmType*)   0x40038000ul)
#define FTM2		((struct  MkeFtmType*)   0x4003a000ul)
#define SIM			((struct  MkeSimType*)   0x40048000ul)
#define PORT		((struct  MkePortType*)  0x40049000ul)
#define WDOG		((struct  MkeWdogType*)  0x40052000ul)
#define ICS			((struct  MkeIcsType*)   0x40064000ul)
#define UART0		((struct  MkeUartType*)  0x4006a000ul)
#define GPIO		((struct  MkeGpioType*)  0xf8000000ul)




#endif
