#define WEAK __attribute__ ((weak))
#define ALIAS(f) __attribute__ ((weak, alias (#f)))


WEAK void IntDefaultHandler(void);
WEAK void NMI_Handler(void) ALIAS(IntDefaultHandler);
WEAK void HardFault_Handler(void) ALIAS(IntDefaultHandler);
WEAK void SVC_Handler(void) ALIAS(IntDefaultHandler);
WEAK void PendSV_Handler(void) ALIAS(IntDefaultHandler);
WEAK void SysTick_Handler(void) ALIAS(IntDefaultHandler);


void GPIO0_IRQHandler(void) ALIAS(IntDefaultHandler);
void GPIO1_IRQHandler(void) ALIAS(IntDefaultHandler);
void GPIO2_IRQHandler(void) ALIAS(IntDefaultHandler);
void GPIO3_IRQHandler(void) ALIAS(IntDefaultHandler);
void WDT_IRQHandler(void) ALIAS(IntDefaultHandler);
void SCB_IRQHandler(void) ALIAS(IntDefaultHandler);
void SPC_IRQHandler(void) ALIAS(IntDefaultHandler);
void CSD_IRQHandler(void) ALIAS(IntDefaultHandler);
void TCPWM0_IRQHandler(void) ALIAS(IntDefaultHandler);

//main must exist
extern int main(void);

//stack top (provided by linker)
extern void __stack_top();
extern void __data_data();
extern void __data_start();
extern void __data_end();
extern void __bss_start();
extern void __bss_end();



#define INFINITE_LOOP_LOW_POWER		while (1) {				\
							asm("wfi":::"memory");	\
						}




void __attribute__((noreturn)) IntDefaultHandler(void)
{
	INFINITE_LOOP_LOW_POWER
}


static void __attribute__((noreturn)) ResetISR(void)
{
	unsigned int *dst, *src, *end;

	//copy data
	dst = (unsigned int*)&__data_start;
	src = (unsigned int*)&__data_data;
	end = (unsigned int*)&__data_end;
	while(dst != end)
		*dst++ = *src++;

	//init bss
	dst = (unsigned int*)&__bss_start;
	end = (unsigned int*)&__bss_end;
	while(dst != end)
		*dst++ = 0;

	main();

//if main returns => bad
	HardFault_Handler();
	
	while(1);
}


__attribute__ ((section(".vectors"))) void (*const __VECTORS[]) (void) =
{
	&__stack_top,		// The initial stack pointer
	ResetISR,		// The reset handler
	NMI_Handler,		// The NMI handler
	HardFault_Handler,	// The hard fault handler
	
	0,			// Reserved
	0,			// Reserved
	0,			// Reserved
	0,			// Reserved
	0,			// Reserved
	0,			// Reserved
	0,			// Reserved

	SVC_Handler,		// SVCall handler
	0,			// Reserved
	0,			// Reserved
	PendSV_Handler,		// The PendSV handler
	SysTick_Handler,	// The SysTick handler
	
	// Chip Level - PSo4
	GPIO0_IRQHandler,
	GPIO1_IRQHandler,
	GPIO2_IRQHandler,
	GPIO3_IRQHandler,
	WDT_IRQHandler,
	SCB_IRQHandler,
	SPC_IRQHandler,
	CSD_IRQHandler,
	TCPWM0_IRQHandler,
};


