//we get here with irqs off but mmu on and no promises about much of anything
//we are at 0xa0084020, mapped at 0xfff00020 via a 4K uncacheable page
//current map as per SVC mode has the following uncached mappings:
// 0xa0000000 -> 0x00000000 32M (built in flash)
// 0xa2000000 -> 0x04000000 64M (external flash)
// 0xa4000000 -> 0xa0000000 64M (all of ram)
// 0xac000000 -> 0x40000000 32M (all 0x40000000 periphs)
// 0xbe000000 -> 0xe0000000 1M (invalid PA ???)
// 0xbe100000 -> 0x48000000 1M (mem ctrlr)
// 0xbe200000 -> 0x44000000 1M (lcd ctrlr)

	MOV    R9, R0
	MSR    CPSR_c, #0xD3			//disable irqs and fiqs, go to SVC mode
	LDR    R11, =0xAC100000			//uart base
	MOV    R12, #0					//a zero is nice to have
	MRC    p15, 0, R1, c2, c0, 0	//get TTBR officially
	MOV    R1, R1, LSR #14			//round TTBR properly
	MOV    R1, R1, LSL #14
	ADD    R1, #0xa4000000			//VA of all-ram map
	SUB    R1, #0xa0000000			//PA of RAM
	
	MOV    R0, #0 + '0'
	BL     sendChar
	
	//identity map all of ram over the rom we do not care about
	LDR    R2, =0xa0000c02
	ADD    R3, R2, #0x04000000
1:
	STR    R2, [R1, R2, LSR #18]
	ADD    R2, R2, #0x00100000
	CMP    R2, R3
	BNE    1b
	
	MOV    R0, #0 + '1'
	BL     sendChar
	
	//map 0xa4000000 (because our pointer is there) to PA 0x00000000 for mini dcache flushing
	LDR    R3, =0x00001c0a
	STR    R3, [R1, R2, LSR #18]
	
	//cacheably map 0xa5000000 to PA 0x00100000 for dcache flushing
	MOV    R2, #0xa5000000
	LDR    R3, =#0x00100c0e
	STR    R3, [R1, R2, LSR #18]
	
	MOV    R0, #0 + '2'
	BL     sendChar
	
	//unlock I & D TLBs
	MCR    p15, 0, R12, c10, c4, 1
	MCR    p15, 0, R12, c10, c8, 1
	
	//tlb flush (no cache flushing neeed since mapping we replaced was also uncached)
	MCR    p15, 0, R12, c8,  c7, 0
	
	MOV    R0, #0 + 'a'
	BL     sendChar
	
	//jump to self in new identity map
	LDR    R2, =0xfff00000 - 0xa0084000 + 4
	SUB    PC, PC, R2
	
//we're in an identity map from now on
	
	MOV    R0, #0 + '3'
	BL     sendChar
	
	//drain write buffers
	MCR    p15, 0, R12, c7, c10, 4
	//cpwait
	MRC    p15, 0, R0, c0,  c0, 0
	MOV    R0, R0
	SUB    PC, PC, #4

	//no longer autolock things into dcache. unlock both caches
	MCR    p15, 0, R12, c9,  c2, 0
	MCR    p15, 0, R12, c9,  c1, 1
	MCR    p15, 0, R12, c9,  c2, 1

	MOV    R0, #0 + '4'
	BL     sendChar

	//clean main d-cache using our mapping at 0xa5000000
	MOV    R2, #0xa5000000
	ADD    R3, R2, #0x10000
1:
	MCR    p15, 0, R2, c7, c2, 5
	ADD    R2, #0x20
	CMP    R2, R3
	BNE    1b

	MOV    R0, #0 + '5'
	BL     sendChar

	//clean mini data cache using our mapping at 0xa4000000
	MOV    R2, #0xa4000000
1:
	LDR    R3, [R2], #0x20
	TST    R2, #0x2000
	BEQ    1b

	MOV    R0, #0 + '6'
	BL     sendChar

	//drain write buffer again for good measure
	MCR    p15, 0, R12, c7, c10, 4
	//cpwait
	MRC    p15, 0, R0, c0,  c0, 0
	MOV    R0, R0
	SUB    PC, PC, #4

	//invalidate data both caches
	MCR    p15, 0, R12, c7, c6, 0

	//invalidate i-cache
	MCR    p15, 0, R12, c7, c5, 0
	
	//cpwait
	MRC    p15, 0, R0, c0,  c0, 0
	MOV    R0, R0
	SUB    PC, PC, #4

	MOV    R0, #0 + '7'
	BL     sendChar

	//turn off mmu and most other things
	MOV    R2, #0x0072
	MCR    p15, 0, R2, c1, c0, 0
	
	//CPWAIT
	MRC    p15, 0, R2, c2, c0, 0
	MOV    R2, R2
	SUB    PC,PC,#4
	NOP
	
	//re-init uart base
	LDR    R11, =0x40100000
	MOV    R0, #0 + '8'
	BL     sendChar
	
	//send PC
	MOV    R0, PC
	BL     sendWord
	
//we now need to move the kernel to start of ram. problem is, we're there and we do not know where kernel pages are or are not
//so we'll find the highest page that is NOT part of the kernel pagemap to move ourselves to. we'll then do the same for the pagemap
//we know we are at 0xa0084000 so that makes the "from" part easy
	MOV    R0, #0				//a page to consider used besides the pages in the pagemap: none
	BL     findFreePageDown
	MOV    R5, R0
	
	BL     sendWord
	
	LDR    R1, =0xa0084000
	MOV    R0, R5
	SUB    R4, R1, R0
	BL     copyPage
	
	MOV    R0, #0 + '9'
	BL     sendChar
	
	SUB    PC, PC, R4
	NOP
	
//now running from our new high page. we also want to move the pagemap page somewhere high. do so and adjust r9 to point to it again
	
	//send PC
	MOV    R0, PC
	BL     sendWord
	
	MOV    R0, R5				//a page to consider used besides the pages in the pagemap: our current code
	BL     findFreePageDown
	MOV    R1, R9
	MOV    R9, R0
	BL     copyPage

	MOV    R0, #0 + 'A'
	BL     sendChar

//now pagemap and our code are both out of the way of our copy, but we also need a page for swapping pages
	MOV    R0, R5				//1st page to consider used besides the pages in the pagemap: our current code
	BL     findFreePageDown
	MOV    R4, R0				//r4 has the temp page address
	
	MOV    R0, #0 + 'B'
	BL     sendChar
	
//all we need to do now is to assemble the image at start of ram - no easy task but we can manage
	
	MOV    R6, #0				//index in pagemap
	
move_loop:
	MOV    R7, #0xa0000000		//get dst addr
	ADD    R7, R7, R6, LSL #12
	
	MOV    R0, R7				//if destination addr is in the pagemap, it has useful data, so we need to swap with
	BL     isInPageMap
	CMN    R0, #1
	BEQ    no_swap_page_needed
	
swap_page_needed:
	MOV    R8, R0				//move the data from the page that overlaps destination to the temp page
	MOV    R0, R4
	MOV    R1, R7
	BL     copyPage
	
	//MOV    R0, #0 + 'C'
	//BL     sendChar
	
	MOV    R0, R7				//move data from our source page to destination
	LDR    R1, [R9, R6, LSL #2]
	BL     copyPage
	
	LDR    R0, [R9, R6, LSL #2]	//move data from temp page back to page of data we just copied from (reusing it for future data)
	MOV    R1, R4
	BL     copyPage
	
	LDR    R0, [R9, R6, LSL #2]
	STR    R0, [R9, R8, LSL #2]
	B      page_copied

no_swap_page_needed:
	
	MOV    R0, R7				//move data from our source page to destination
	LDR    R1, [R9, R6, LSL #2]
	BL     copyPage
	
	//MOV    R0, #0 + 'D'
	//BL     sendChar

page_copied:
	ADD    R6, #1
	CMP    R6, #0x400
	BNE    move_loop

	MOV    R0, #0 + 'E'
	BL     sendChar

	MOV    PC, #0xa0000000


sendWord:	//clobbers r10, r13
	MOV    R10, LR
	MOV    R13, R0
	MOV    R0, R13, LSR #24
	BL     sendChar
	MOV    R0, R13, LSR #16
	AND    R0, #0xff
	BL     sendChar
	MOV    R0, R13, LSR #8
	AND    R0, #0xff
	BL     sendChar
	AND    R0, R13, #0xff
	MOV    LR, R10
	B      sendChar
	

sendChar:			//r0 = char, no other regs touched, R11 is uart base
	STR    R0, [R11, #0x00]
1:
	LDR    R0, [R11, #0x14]
	TST    R0, #0x40
	BEQ    1b
	BX     LR


isInPageMap:		//return index in pagemap if found, -1 if not
	MOV   R1, #0
1:
	LDR   R2, [R9, R1, LSL #2]
	CMP   R0, R2
	MOVEQ R0, R1
	BXEQ  LR
	ADD   R1, #1
	CMP   R1, #0x400
	BNE   1b
	MVN   R0, #0
	BX    LR


findFreePageDown:	//void* (u32 blockedPa)	//assumes pagemap is in R9 and also blocked, assumes pagemap is 1024 entries exactly
	MOV   R2, #0xa4000000
1:
	SUB   R2, R2, #0x1000
	CMP   R2, R0	//compare to blocked list first - it is easier
	CMPNE R2, R9
	BEQ   1b
	
	MOV   R1, #0
2:
	LDR   R3, [R9, R1]
	CMP   R2, R3
	BEQ   1b
	ADD   R1, #4
	CMP   R1, #0x1000
	BNE   2b

	MOV   R0, R2
	BX    LR


copyPage:		//void (void* dst, void* src)
	MOV   R12, #512
1:
	LDMIA R1!, {R2, R3}
	STMIA R0!, {R2, R3}
	SUBS  R12, #1
	BNE   1b
	BX    LR





