#include "util.h"





static inline int32_t __attribute__((always_inline)) scaleAnalizeEx(uint32_t scale)			//we want this force inlined into scaleCoord so our "fatal" report is useful
{
	switch (scale) {
		case SCALE_UNITY / 4:
			return (BIG_SCALE_UNITY + 3) / 4;

		case SCALE_UNITY / 3:
			return (BIG_SCALE_UNITY + 2) / 3;

		case SCALE_UNITY / 2:
			return (BIG_SCALE_UNITY + 1) / 2;

		case SCALE_UNITY * 2 / 3:
			return (BIG_SCALE_UNITY * 4 + 3) / 6; 
		
		case SCALE_UNITY * 3 / 4:
			return (BIG_SCALE_UNITY * 3 + 2) / 4;
		 
		case SCALE_UNITY:
			return BIG_SCALE_UNITY;
		
		case SCALE_UNITY * 4 / 3:
			return (BIG_SCALE_UNITY * 8 + 3) / 6;
		
		case SCALE_UNITY * 3 / 2:
			return (BIG_SCALE_UNITY * 3 + 1) / 2;
		
		case SCALE_UNITY * 2:
			return BIG_SCALE_UNITY * 2;
		
		case SCALE_UNITY * 3:
			return BIG_SCALE_UNITY * 3;
		
		case SCALE_UNITY * 4:
			return BIG_SCALE_UNITY * 4;
		
		default:
			fatal("Unknown scale %u, called from 0x%08x: %02x%02x%02x%02x%02x%02x%02x%02x\n",
				scale, __builtin_return_address(0),
				((uint8_t*)__builtin_return_address(0))[0], ((uint8_t*)__builtin_return_address(0))[1],
				((uint8_t*)__builtin_return_address(0))[2], ((uint8_t*)__builtin_return_address(0))[3],
				((uint8_t*)__builtin_return_address(0))[4], ((uint8_t*)__builtin_return_address(0))[5],
				((uint8_t*)__builtin_return_address(0))[6], ((uint8_t*)__builtin_return_address(0))[7]);
			
			return 0;
	}
}

int32_t scaleAnalize(uint32_t scale)
{
	return scaleAnalizeEx(scale);
}

int32_t scaleCoord(int32_t coord, uint32_t scaleFactor, bool ceiling)		//this is actually called WinPrvScalePoint in garnet and is publicly exported
{
	bool haveRem = false;
	int32_t ret, scale;
	
	if (scaleFactor == SCALE_UNITY)
		return coord;
	
	scale = scaleAnalizeEx(scaleFactor);
	ret = ((int64_t)coord * scale) / BIG_SCALE_UNITY;
	haveRem = (((int64_t)coord * scale) % BIG_SCALE_UNITY) != 0;
	
	if (ceiling && scaleFactor < SCALE_UNITY && haveRem)
		ret++;
	else if (!ceiling && scaleFactor > SCALE_UNITY && haveRem)
		ret++;

	return ret;
}

void scaleRect(struct RectangleType *rct, uint32_t scaleFactor)
{
	int32_t leftOrTop, rightOrBottom;
	
	leftOrTop = scaleCoord(rct->topLeft.x, scaleFactor, false);
	rightOrBottom = scaleCoord((int32_t)rct->topLeft.x + rct->extent.x, scaleFactor, false);
	rct->topLeft.x = leftOrTop;
	rct->extent.x = rightOrBottom - leftOrTop;
	
	leftOrTop = scaleCoord(rct->topLeft.y, scaleFactor, false);
	rightOrBottom = scaleCoord((int32_t)rct->topLeft.y + rct->extent.y, scaleFactor, false);
	rct->topLeft.y = leftOrTop;
	rct->extent.y = rightOrBottom - leftOrTop;
}

struct PalmFont** getFontTableForFontMap(uint16_t fontType)
{
	//yes this is correct, when we have a font map, font is actually a font table pointer
	if ((fontType & FONT_MAP_APP_FONT_MAP) == FONT_MAP_APP_FONT_MAP)
		return PalmOSGetGlobalsPtr()->appSubFonts;
	else
		return UIGetGlobalsPtr()->uiFonts;
}