#ifndef _FIX_15_DD_UTIL_H_
#define _FIX_15_DD_UTIL_H_

#define _DIRECT_CALL_WITH_UNPOPPED_16BIT_SELECTOR(...)
#include "../dal/boot.h"
#include "../dal/dal.h"
#include <stdint.h>
#include <MemoryMgr.h>
#include <LibTraps.h>
#include <SerialMgr.h>
#include <FatalAlert.h>
#include <StringMgr.h>
#include <FeatureMgr.h>
#include <SystemMgr.h>
#include <TimeMgr.h>
#include <Window.h>
#include <Bitmap.h>
#include <string.h>
#include <stddef.h>
#include <Form.h>
#include "common.h"
#include "printf.h"
#include "../dal/ral.h"
#include "../dal/halDrawing.h"
#include "../dal/halDisplay.h"
#include <TextMgr.h>
#include <UIColor.h>
#include "pace.h"




struct PalmWindowFlags {

	uint16_t format			: 1;
	uint16_t offscreen		: 1;
	uint16_t modal			: 1;
	uint16_t focusable		: 1;
	uint16_t enabled		: 1;
	uint16_t visible		: 1;
	uint16_t dialog			: 1;
	uint16_t freeBitmap		: 1;
	uint16_t reserved		: 8;
};

union PalmFrameFlags {

	struct {
		uint16_t cornerDiam		: 8;		//lsl 24
		uint16_t rfu			: 3;		//lsl 21
		uint16_t threeD			: 1;		//lsl 20
		uint16_t shadowWidth	: 2;		//lsl 18
		uint16_t width			: 2;		//lsl 16
	};
	uint16_t frameType;
};

#define WinFrameLE_dialogFrame			0x8003
#define WinFrameLE_popupFrame			0x5002
#define WinFrameLE_none					0x0000
#define WinFrameLE_rectangleFrame		0x4000
#define WinFrameLE_roundFrame			0x4004
#define WinFrameLE_boldRoundFrame		0x8007


struct PalmWindow {
	uint16_t				oldStuff1[2];	//00
	uint32_t				oldStuff2;		//04
	struct RectangleType	bounds;			//08
	struct AbsRectType		clipBounds;		//10
	struct BitmapType		*bmp;			//18
	struct PalmWindowFlags	flags;			//1C
	union PalmFrameFlags  	frm;			//1E
	struct PalmDrawState 	*drawState;		//20
	struct PalmWindow 		*next;			//24
};

struct UiGlobals {
	uint32_t rfu1[7];
	struct PalmDrawState *curDrawState;	//0x1C
	uint32_t rfu2[11];
	struct PalmFont *curFont;			//0x4C
	struct PalmFont **systemFonts;		//0x50
	struct PalmFont **appFonts;			//0x54
	uint16_t numSystemFonts;			//0x58
	uint16_t numAppFonts;				//0x5A
	struct PalmFont **uiFonts;			//0x5C	(if ui has a font with a font map (and subfonts), this is where the fonts for it are)
	uint32_t rfu3[1];					//0x60
	uint8_t curFontId;					//0x64
	uint8_t padding1[3];				//0x65
	uint32_t rfu4[18];					//0x68
	struct {							//0xB0
		uint8_t alwaysRectaBorders : 1;	//changes how contorl borders are drawn
	} uiConfigs;
};

#define PALM_CTL_FRAME_NONE						0
#define PALM_CTL_FRAME_STD_BTN					1
#define PALM_CTL_FRAME_BOLD_BTN					2
#define PALM_CTL_FRAME_RECTANGLE				3

#define PALM_CONTROL_STYLE_BUTTON				0
#define PALM_CONTROL_STYLE_PUSHBUTTON			1
#define PALM_CONTROL_STYLE_CHECKBOX				2
#define PALM_CONTROL_STYLE_POPUP_TRIGGER		3
#define PALM_CONTROL_STYLE_SELECTOR_TRIGGER		4
#define PALM_CONTROL_STYLE_REPEATING_BUTTON		5
#define PALM_CONTROL_STYLE_SLIDER				6
#define PALM_CONTROL_STYLE_FEEDBACK_SLIDER		7

struct PalmControlAttrs {
	uint8_t usable				:1;
	uint8_t enabled				:1;
	uint8_t visible				:1;
	uint8_t on					:1;
	uint8_t leftAnchor			:1;
	uint8_t frame				:3;

	uint8_t drawnAsSelected		:1;
	uint8_t graphical			:1;
	uint8_t vertical			:1;
};

struct PalmControl {
	uint16_t				id;					//0
	struct PalmControlAttrs	attr;				//2
	struct RectangleType	bounds;				//4
	char					*text;				//C
	uint8_t					style;				//10
	FontID					font;				//11
	uint8_t					group;				//12
};

struct PalmGraphicControl {
	uint16_t				id;					//0
	struct PalmControlAttrs	attr;				//2
	struct RectangleType	bounds;				//4
	uint16_t				bitmapId;			//C
	uint16_t				selectedBitmapId;	//E
	uint8_t					style;				//10
	FontID					font;				//11
	uint8_t					group;				//12
};

struct PalmActiveSlider {
	MemHandle				thumbBmpH;			//0
	MemHandle				backgroundBmpH;		//4
	BitmapType				*thumbBmpPtr;		//8
	BitmapType				*backgroundBmpPtr;	//C
	int32_t					thumbPosX;			//10
	int16_t					newValue;			//14
	uint16_t				rfu2;				//16
	WinHandle				renderWinH;			//18
	bool					trackingPen;		//1C
};

struct PalmSliderControl {
	uint16_t				id;					//0
	struct PalmControlAttrs	attr;				//2
	struct RectangleType	bounds;				//4
	uint16_t				thumbBmpId;			//C
	uint16_t				backgroundBmpId;	//E
	uint8_t					style;				//10
	uint8_t					rfu1;				//11		
	int16_t					minValue;			//12
	int16_t					maxValue;			//14
	int16_t					pageSize;			//16
	int16_t					value;				//18
	uint16_t				rfu2;				//1A
	struct PalmActiveSlider	*activeSliderP;		//1C
};

struct PalmListObj {
	uint16_t				id;					//0
	struct {
		uint16_t			usable			:  1;
		uint16_t			enabled			:  1;
		uint16_t			visible			:  1;
		uint16_t			poppedUp		:  1;
		uint16_t			hasScrollBar	:  1;
		uint16_t			search			:  1;
		uint16_t			reserved		: 10;
	} attr;										//2
	struct RectangleType	bounds;				//4
	char**					itemsText;			//C
	int16_t					numItems;        	//10		// number of choices in the list
	int16_t 	  			currentItem;     	//12		// currently display choice
	int16_t   				topItem;         	//14		// top item visible when poped up
	FontID           		font;				//16		// font used to draw list
	uint8_t					reserved;			//17
	WinHandle   			popupWin;			//18		// used only by popup lists
	void (*ListItemDrawF)(uint16_t itmIdx, struct RectangleType *bounds, char **itmsTxt);
};

struct PalmTitleObj {
	RectangleType			rect;
	char*					text;
};

struct PalmFormObj {
	void* obj;
	FormObjectKind objKind;
};

struct PalmForm {
	struct PalmWindow		win;				//00
	struct {									//28
		uint16_t usable				: 1;
		uint16_t enabled			: 1;
		uint16_t visible			: 1;
		uint16_t dirty				: 1;
		uint16_t saveBehind			: 1;
		uint16_t graffitiShift		: 1;
		uint16_t globalsAvailable	: 1;
		uint16_t doingDialog		: 1;
		uint16_t exitDialog			: 1;
		uint16_t attnIndSupported	: 1;
		uint16_t reserved			: 6;
	} attr;
	struct {									//2A
		uint16_t frmDIAPolicy		: 1;
		uint16_t inputAreaState		: 3;
		uint16_t statusState		: 1;
		uint16_t inputTrigger		: 1;
		uint16_t orientation		: 3;
		uint16_t orientationTrigger	: 1;
		uint16_t reserved2			: 6;
	} diaPolicyAttr;
	void*					bitsBehindForm;		//2C
	void*					formEventHandler;	//30
	uint16_t				formID;				//34
	uint16_t				focus;				//36
	uint16_t				defaultButton;		//38
	uint16_t				helpRscId;			//3A
	uint16_t				menuRscId;			//3C
	uint16_t				numObjects;			//3E
	struct PalmFormObj*		objs;				//40
};


//our structs

struct Globals {						//size set to 20 bytes by amdi resource...
	
	//used for form title drawing
	void (*ot_pFrmDrawForm)(struct PalmForm* frm);
	void (*ot_pLstDrawList)(struct PalmListObj *listP);
	
	//used to intercept tapping on the help icon to make it look proper when tapped
	bool (*ot_pFrmHandleEvent)(struct PalmForm *frm, EventType *evt);
	
	//used to get a hold of PrvDrawControl
	void (*ot_pCtlDrawControl)(struct PalmControl *ctl);
	
	//pace 68k handler for HD dispatch
	PaceTrapHandler oldPaceHdDispatchHandler;
	
	//ui hacks are scary but needed to bend PrvDrawControl to our 1.5-density will
	struct {
		uint32_t replaceOneRectangleFrame : 1;
		uint32_t replaceOneEraseRectangle : 1;
	} uiHacksEnabled;
	
	struct PalmControl *ctl;
};

struct WorstCaseBitmapSize {		//fits any bitmap
	struct PalmBitmapV3 bmp;
	uint32_t clutPtr;
	uint32_t dataPtr;
};

struct BitmapType* BmpCreateVersion3(Coord w, Coord h, uint32_t depth, struct PalmClut *clut, uint32_t density, uint32_t transparentValue, uint32_t pixelFormat, Err *errOut);
void WinPrvInitCanvasWithBitmap(struct BitmapType* bmp, struct PalmBitmapV3fat* canvasBmp, struct PalmDrawState *drawState, struct PalmCanvas* canvas);
void WinPrvInitCanvas(struct PalmWindow* winFor, struct PalmBitmapV3fat* canvasBmp, struct PalmCanvas* canvas);
void AttnIndicatorAllow(bool allow);
struct UiGlobals* UIGetGlobalsPtr(void);

#define SCALE_UNITY							64				//palm os 5.2 scale
#define BIG_SCALE_UNITY						0x00100000		//our scale. should be multiple of SCALE_UNITY and less than or eq to 2^31 / (SCALE_UNITY * 2)!


struct PalmOsFuncPatch {
	void* func;
	uint16_t entryPt	: 12;
	uint16_t moduleId	:  4;
	int16_t oldTrapOfst;	//from start of globals, in words, neg means none
};

#define DEF_PATCH(_name, _mod, _ofst, _oldTrapOfstInBytes) 												\
	static const __attribute__((used, section(".patches.m"))) struct PalmOsFuncPatch _PI_ ## _name = {	\
		.func = &_name,																					\
		.entryPt = ((uint32_t)(_ofst)) / 4,																\
		.moduleId = _mod,																				\
		.oldTrapOfst = (_oldTrapOfstInBytes) >> 2, /* -1 => -1; +x -> x / 4 */							\
	}
#define DEF_PATCH_FULL(_name, _mod, _ofst)	DEF_PATCH(_name, _mod, _ofst, -1)


#define DEF_DAL_PATCH(_name, _ofst)			DEF_PATCH_FULL(_name, 0, _ofst)
#define DEF_BOOT_PATCH(_name, _ofst)		DEF_PATCH_FULL(_name, 1, _ofst)
#define DEF_UI_PATCH(_name, _ofst)			DEF_PATCH_FULL(_name, 2, _ofst)

#define DEF_DAL_PATCH_PARTIAL(_name, _ofst)		DEF_PATCH(_name, 0, _ofst, offsetof(struct Globals, ot_ ## _name))
#define DEF_BOOT_PATCH_PARTIAL(_name, _ofst)	DEF_PATCH(_name, 1, _ofst, offsetof(struct Globals, ot_ ## _name))
#define DEF_UI_PATCH_PARTIAL(_name, _ofst)		DEF_PATCH(_name, 2, _ofst, offsetof(struct Globals, ot_ ## _name))



static inline struct Globals* __attribute__((pure)) globalsGet(void)
{
	void**** ret;
	
	asm ("mov %0, r9":"=r"(ret));
	return (struct Globals*)&ret[0][MY_LIB_ID / 4][0x18/4];
}

int32_t scaleAnalize(uint32_t scale);
int32_t scaleCoord(int32_t coord, uint32_t scaleFactor, bool ceiling);
void scaleRect(struct RectangleType *rct, uint32_t scaleFactor);
struct PalmFont** getFontTableForFontMap(uint16_t fontType);


#endif
