#ifndef _NAND_IFACE_H_
#define _NAND_IFACE_H_

#include <stdbool.h>
#include <stdint.h>


struct NandByteRange {
	uint16_t offset :9;	//from start of spare area
	uint16_t len	:7;	//zero for terminator
};

struct NandSpec {
	uint32_t nandBlocks;
	uint16_t dataBytesPerPage;
	uint16_t spareAreaSize;					//total size of area, not all of which is usable by us
	uint8_t pagesPerBlockShift;
	const struct NandByteRange *eccedSpareBytes;
	const struct NandByteRange *uneccedSpareBytes;
	struct NandByteRange badBlockMarker;
	
	uint16_t maxFactoryBadBlocks;	//this many can be bad from the factory
	uint16_t maxBadBlocks;			//after this many device is considered dead
	uint16_t speccedErasesPerBlock;	//in units of 100
};

struct NandFuncs {
	bool (*NandBlockErase)(struct NandFuncs *funcs, uint32_t firstPageNum);
	int_fast8_t (*NandPageReadPartial)(struct NandFuncs *funcs, uint32_t pageNum, void *data, uint32_t ofst, uint32_t len, bool withEcc);
	bool (*NandPageWritePartial)(struct NandFuncs *funcs, uint32_t pageNum, const void *data, uint32_t ofst, uint32_t len, bool withEcc);
	//more things can be here
};



#endif
