#ifndef _KERNEL_ENTRY_H_
#define _KERNEL_ENTRY_H_

#include <stdint.h>
#include "dal.h"

//handlers that exist elsewhere
void SVC_Handler(void);
void MemManage_Handler(void);
void UsageFault_Handler(void);
void BusFault_Handler(void);
void HardFault_Handler(void);
void NMI_Handler(void);
void PendSV_Handler(void);
void SysTick_Handler(void);
void DebugMonitor_Handler(void);

//this exists
void IntDefaultHandler(void);

//machine init
void machInit(uint32_t stage, const void* data);

//machine idle (idle thread calls this repeatedly)
void machIdle(void);

//set storage area protection state
void machSetStorageAreaWriteable(bool writeable);

//sleep
void machSleep(void);

struct MachInitDataInterrupts {
	//for scheduling timer
	uint8_t schedulingTimerPrio;
	//for normal irqs
	uint8_t lowestAllowablePrio;
	uint8_t highestAllowablePrio;
	//how hardware services. (stuff that must preempt everything and is never blocked. code here cannot make syscalls or even expect proper time to be read from system)
	uint8_t hardwareServicesPrio;
};

#define STAGE_INIT_EARLY				0	//called from ASM early on. possibly not in proper memory space. no globals yet! no .bss/.data/.fastcode
#define STAGE_SOMEWHAT_EARLY_INIT		1	//.bss/.data exists, not much else
#define STAGE_INIT_SET_VTOR				2	//called to set vtor
#define STAGE_SETUP_HEAPS				3	//mpu is in allow-all mode. setup all heaps
#define STAGE_INIT_INTERRUPTS			4	//very early. have kernel heap but not much else. data points to struct MachInitDataInterrupts*
#define STAGE_INIT_MPU					5	//setup the MPU. until now it was configured in all-allow mode all 4GB
#define STAGE_INIT_PRE_SCHED			6	//scheduler not yet on, but timers are up
#define STAGE_INIT_IN_THREAD			7	//we're in a thread and can make syscalls
#define STAGE_INIT_POST_RAL				8	//RAL is inited and modules cna be loaded for real

#define STAGE_CRASH_LOCKS_BREAK			128	//do what we must to break locks and update display with crash info


int32_t cpuGetClockRate(enum ClockRateDevice dev);


#endif
