#include <PalmOS.h>
#include "driverless.h"
#include "SonyMSIO.h"
#include "globals.h"

extern void __code_start();
extern const struct DriverlessArea __driverless_start;
extern const struct DriverlessSupportRecord __driverless_end;

struct DriverlessArea {
	UInt32 base;
	struct DriverlessSupportRecord records[];
};

enum DriverlessResult driverlessCheck(struct Globals *g, UInt32 devID)
{
	const struct DriverlessArea *da = &__driverless_start;
	const struct DriverlessSupportRecord *dsr = da->records;
	const struct DriverlessSupportRecord *dsrEnd = &__driverless_end;
	enum DriverlessResult ds = DriverlessDeviceUnknown;
	UInt32 base = da->base;
	UInt16 i;
	
	for (; dsr < dsrEnd; dsr++) {
		
		if (dsr->dev == devID) {
			
			FuncSlotCustomControl fc = (FuncSlotCustomControl)(((UInt32)dsr->fCustomControl) - base + (UInt32)&__code_start);
			FuncPowerControl pc = (FuncPowerControl)(((UInt32)dsr->fPowerControl) - base + (UInt32)&__code_start);
			
			//any option for a device in here means it neede driverless support
			ds = DriverlessDeviceKnownAndError;
			if (errNone == pc(&g->customControlData, true)) {
				
				g->fSlotCustomControl = fc;
				return DriverlessDeviceKnownAndSupported;
			}
		}
	}
	
	return ds;
}