| start at this address (just because it must so be)
	.equ BASE, 0x08000000
	.section .text

| Card header
card_header:
	dc.l 0											| if this were a boot card, this would be initial sp
	dc.l 0											| if this were a boot card, this would be initial pc
	dc.l 0xFEEDBEEF									| card signature
	dc.w 4											| card header is version 4
	dc.w 0x0020										| flags: "targets the 68k EZ processor" (visor expects this)
str_name:
	.ascii "rePalm"									| name, 32 bytes
.org str_name + 32
str_manuf:
	.ascii "Dmitry.GR"								| manufacturer, 32 bytes
.org str_manuf + 32
	dc.w 1											| card version (1)
	dc.l 0xf0000000									| creation date
	dc.w 0											| num ram blocks: 0
	dc.l BASE + block_list - card_header			| address of the block list pointer
	dc.l 0											| read-write parms offset
	dc.l 0											| read-write parms size
	dc.l BASE + token_store - card_header			| address of the token storage
	dc.l BASE										| big rom adddress (for us: our address)
	dc.l the_end - card_header						| total rom size
	dc.w 0											| rom checksum (filled-in by crc tool)
	dc.l 0											| read-write working space offset
	dc.l 0											| read-write working space size
	dc.l 0											| hal code offset (for us: 0)

.org card_header + 0x100							| store header must start at card header + 256
store_header:
	dc.l 0xFEEDFACE									| store signature
	dc.w 1											| version 1
	dc.w 0											| flags: 0
str_store_name:
	.ascii "One store to rule them all"				| rom store name, 32 bytes
.org str_store_name + 32
	dc.l 0											| always zero
	dc.l 0											| always zero
	dc.l BASE + heap_list - card_header				| address of the heap list
	dc.l 0											| boot code data pointer
	dc.l 0											| boot code info pointer
	dc.l BASE + db_list - card_header				| address of the database list
	dc.l 0											| always zero

token_store:

	.ascii "HsWR"									| word: always zero in store header. we store tokens here
	dc.w 1											| word: always zero instore header. we store tokens here
	dc.b '1'
	dc.b 0xff
	dc.l 0xffffffff									| word: always zero instore header. we store tokens here

	dc.l 0											| always zero
	
heap_list:
	dc.w 1											| halfword: always zero in store header.  we use this as heap list numHeaps value
	dc.l BASE + heap_hdr - card_header				| word: boot screen 0 ptr. zero for springboard. we use this as heap list heaps[0] pointer

	dc.l 0											| boot screen 1 ptr
	dc.w 0											| always zero
	dc.w 0x00										| language: lEnglish = 0x00
	dc.w 0x17										| country: cUnitedStates = 0x17


| =============== END  store header

.balign 4
heap_hdr:
	dc.w 0x4001										| flags: v3 heap, readonly
	dc.l the_end - heap_hdr							| heap size
	dc.l 5											| heap terminator chunk poiner (first free chunk). should point to a word of zeros.
	dc.w 0											| heap's master pointer table has 0 entries
	dc.l 0											| there is no next table (also this is the terminator "chunk header" for the free chunk list) (also used as free chunk pointer)

db_list_chunk_header:								| OS gets this chunk's size so the header is a must
	dc.l db_list_end - db_list_chunk_header			| length of the chunk
	dc.l 0xf1000000									| nonmovable chunk owned by owner ID 1
db_list:
	dc.l 0											| there is no next db list entry
	dc.w 1											| there is only one databse
	dc.l BASE + db_hdr - card_header				| address of our only databse header
db_list_end:

db_hdr_chunk_header:								| OS gets this chunk's size so the header is a must
	dc.l db_hdr_end - db_hdr_chunk_header			| length of the chunk
	dc.l 0xf1000000									| nonmovable chunk owned by owner ID 1
db_hdr:
str_db_name:
	.ascii "CardWelcome"							| DB name, must be hardcoded to this
.org str_db_name + 32
	dc.w 0x0123										| attrbutes: resource db, readonly, hidden, reset after install
	dc.w 0											| db version: 0
	dc.l 0											| db creation date: 0
	dc.l 0											| db modification date: 0
	dc.l 0											| db last backup date: 0
	dc.l 0											| db modification number: 0
	dc.l 0											| db app info pointer: 0
	dc.l 0											| db sort info pointer: 0
	.ascii "appl"									| type is "appl"
	.ascii "reSp"									| creator is "reSp"
	dc.l 0											| unique ID seed: 0
	dc.l 0											| next record/resrouce list pointer: 0
	dc.w 1											| number of resources: 1
	.ascii "code"									| resrouce type: "code"
	dc.w 1											| resrouce id: 1
	dc.l BASE + the_code - card_header				| address of the code
db_hdr_end:

the_code_chunk_header:								| OS gets this chunk's size so the header is a must
	dc.l the_code_end - the_code_chunk_header		| length of the chunk
	dc.l 0xf2000000									| nonmovable chunk owned by owner ID 2
the_code:
	link	%a6, #-12
	movem.l	%d3/%a2-%a3,-(%sp)
	pea		-12(%a6)
	pea		-8(%a6)
	pea		-4(%a6)
	dc.w	0x4e4f									| systrap SysAppStartup
	dc.w	0xa08f
	lea     12(%sp), %sp							| restore sp
	movea.l -4(%a6), %a0							| get SysAppInfoPtr into a0
	tst.w	0(%a0)									| test launch code
	bne.s	path_out								| only do stuff on normal launch
	
	movea.l #0x28000000, %a2
	movea.l #0x29000000, %a3
	
wait:
	moveq   #1, %d0
	jsr     msgExg
	cmp.w   #2, %d0
	bne     wait
	
get_size:
	moveq   #3, %d0
	jsr     msgExg
	move.w  %d0, %d3

allocate:
	ext.l   %d0
	lsl.l   #1, %d0
	move.w  #0x1200, -(%sp)
	move.l  %d0, -(%sp)
	clr.w   -(%sp)
	dc.w	0x4e4f									| systrap MemChunkNew
	dc.w	0xa011
	lea     8(%sp), %sp							    | restore sp
	move.l  %a0, %a1
	beq     path_out
	
download:
	moveq   #4, %d0
	jsr     msgExg
	move.w  %d0, (%a0)+
	subi.w  #1, %d3
	bne     download

run:
|	move.l  %a1, %d3								| XXX: we do not free - let the system do this and we'll save some bytes
	jsr     (%a1)
	
free:												| XXX: we do not free - let the system do this and we'll save some bytes
|	move.l  %d3, -(%sp)
|	dc.w	0x4e4f									| systrap MemChunkFree
|	dc.w	0xa012
|	lea     4(%sp), %sp							    | restore sp

path_out:
	move.l	-12(%a6), -(%sp)
	move.l	-8(%a6), -(%sp)
	move.l	-4(%a6), -(%sp)
	dc.w	0x4e4f									| systrap SysAppExit
	dc.w	0xa090
	lea     12(%sp), %sp							| restore sp
	moveq	#0, %d0									| return 0
	movem.l (%sp)+, %d3/%a2-%a3
	unlk    %a6
	rts

| end of __start

msgExg:	| d0 input and output
	move.w  %d0, 2(%a2)
	move.w  #0xb00b, 6(%a2)
	move.w  0(%a3), %d0
1:
	cmpi.w  #0xf00d, 6(%a2)
	bne     1b
	move.w  2(%a2), %d0
	rts

the_code_end:
	
block_list:
	dc.l 0											| zero for all springboards
	dc.l 0											| zero for all springboards

the_end:


	

	