#ifndef _HAL_SOUND_H_
#define _HAL_SOUND_H_

#include <stdint.h>
#include <ErrorBase.h>
#include <SoundMgr.h>


#define INVALID_SND_STREAM		((SndStreamRef)(-1))


#define HAL_SOUND_DEVICE_NAME_OUTPUT		"mixer"
#define HAL_SOUND_DEVICE_NAME_INPUT			"adc"

#define HAL_SOUND_IOCTL_SETUP				0	//data is struct HalSoundInitInfo*
#define HAL_SOUND_IOCTL_SET_VOL				1	//data is u32* - volume
#define HAL_SOUND_IOCTL_GET_VOL				2	//data is u32* - volume
#define HAL_SOUND_IOCTL_SET_PAN				3	//data is i32* - pan
#define HAL_SOUND_IOCTL_GET_PAN				4	//data is i32* - pan
#define HAL_SOUND_IOCTL_GET_BUFFS			5	//data is struct HalSoundBuffersInfo*	assumes buffer depth of 2
#define HAL_SOUND_IOCTL_STREAM_STOP			6	//no data - advisory only
//sony-specific
#define HAL_SOUND_IOCTL_GET_STATS			8	//out struct HalSonySoundStreamStats*

//sony-specific, streamref must be SONY_STREAM_REF_SPECIAL
#define HAL_SOUND_IOCTL_7					7	//not sure yet, deeply entangled with the audio driver
#define HAL_SOUND_IOCTL_NUM_ACTIVE_STREAMS	9	//out. u32* - numStreams (playback only)

#define SONY_STREAM_REF_SPECIAL				((SndStreamRef)0xffff)


#define HAL_SOUND_MAX_VOLUME				0x7FFF
#define HAL_SOUND_UNITY_VOLUME				0x400	//volume with 1.0 gain

#define HAL_SOUND_PAN_FELL_LEFT				(-1024)
#define HAL_SOUND_PAN_FULL_RIGHT			1024
#define HAL_SOUND_PAN_CENTER				0


struct HalSoundInitInfo52 {		//OS 5.2 or later
	uint32_t sampleRate;
	uint32_t format;			//SndFormatTag
	uint16_t sampleType;		//SndSampleType
	uint8_t streamWidth;		//SndStreamWidth
};

struct HalSoundInitInfo50 {		//OS 5.1 or earlier
	uint32_t sampleRate;
	uint16_t sampleType;		//SndSampleType
	uint8_t streamWidth;		//SndStreamWidth
};

struct HalSoundBuffersInfo {
	uint32_t sz;				//in: requested. out: granted size (in bytes)
	void* bufs[2];				//out: bufs
};

struct HalSonySoundStreamStats {
	uint32_t numOutSamplesProduced;
	uint32_t lastMixedTicks;
};

//note: some pars of PalmOS treat SndStreamRef that is zero or has the top bit set as invalid!

Err HALSoundInitialize(void);

SndStreamRef HALSoundOpen(const char *deviceP, uint32_t flags, Err *errP);
Err HALSoundClose(SndStreamRef streamRef);
uint32_t HALSoundRead(SndStreamRef streamRef, void *bufP, uint32_t size, Err *errP);
uint32_t HALSoundWrite(SndStreamRef streamRef, void *bufP, uint32_t size, Err *errP);
Err HALSoundIoctl(SndStreamRef streamRef, uint32_t cmd, void *paramP);


Err HALSoundOff(void);
Err HALSoundPlay(uint32_t freq, uint16_t amplitude, int32_t timeDuration);
Err HALPlaySmf(void *channel, SndSmfCmdEnum command, UInt8 *midiData, SndSmfOptionsType *options, SndSmfChanRangeType *channelRange, SndSmfCallbacksType *callbacks, Boolean noWait);


#endif
