#include <stdint.h>
#include "irqsCortex.h"
#include "timers.h"
#include "irqs.h"
#include "cpu.h"

void __attribute__((used)) OsTimer_IRQHandler(void)
{
	timerExternalIrq();
}

void hwTimerInit(void)
{
	
}

uint32_t hwTimerIntOff(void)
{
	uint32_t ret = NVIC_IsEnabledIRQ(OsTimer_IRQn);		//allows re-entrancy
	NVIC_DisableIRQ(OsTimer_IRQn);
	
	return ret;
}

uint32_t hwTimerIntOn(void)
{
	uint32_t ret = NVIC_IsEnabledIRQ(OsTimer_IRQn);		//allows re-entrancy
	NVIC_EnableIRQ(OsTimer_IRQn);
	
	return ret;
}

void hwTimerIntRestore(uint32_t state)
{
	if (state)
		NVIC_EnableIRQ(OsTimer_IRQn);
	else
		NVIC_DisableIRQ(OsTimer_IRQn);
}

void hwTimerSet(uint32_t ticksFromNow)
{
	*(volatile uint32_t*)(OS_TIMER_UNIT_BASE + OS_TIMER_OFST_COUNTDOWN) = ticksFromNow;
}