#include "rtc.h"
#include "hw/CortexEmu/rtcIface.h"
#include "CortexEmuCpu.h"


static DrvRtcCbk mAlmCbk = NULL, mHzCbk = NULL;


void __attribute__((used)) RtcHz_IRQHandler(void)
{
	NVIC_ClearPendingIRQ(RtcHz_IRQn);
	if (mHzCbk)
		mHzCbk();
}

void __attribute__((used)) RtcAlarm_IRQHandler(void)
{
	NVIC_ClearPendingIRQ(RtcAlarm_IRQn);
	if (mAlmCbk)
		mAlmCbk();
}

kstatus_t drvRtcInit(DrvRtcCbk hzCbk, DrvRtcCbk almCbk)
{
	uint32_t time;
	kstatus_t sta;
	
	mAlmCbk = almCbk;
	mHzCbk = hzCbk;
	
	sta = drvRtcGet(&time);
	if (sta != KERN_STATUS_OK)
		return sta;
	
	if (time < 512) {					//is the rtc zeroed ?
		sta = drvRtcSet(0x9E73B880);	//start with this: as sane a time as any
		if (sta != KERN_STATUS_OK)
			return sta;
	}
	
	drvRtcSetAlarm(0);
	NVIC_EnableIRQ(RtcHz_IRQn);
	NVIC_EnableIRQ(RtcAlarm_IRQn);
	
	return KERN_STATUS_OK;
}

kstatus_t drvRtcPreSleep(void)
{
	NVIC_DisableIRQ(RtcHz_IRQn);
	
	return KERN_STATUS_OK;
}

kstatus_t drvRtcPostWake(void)
{
	NVIC_EnableIRQ(RtcHz_IRQn);
	
	return KERN_STATUS_OK;
}

kstatus_t drvRtcGet(uint32_t *valP)
{
	*valP = *(volatile uint32_t*)(RTC_UNIT_BASE + RTC_OFST_CURTIME);
	
	return KERN_STATUS_OK;
}

kstatus_t drvRtcSet(uint32_t val)
{
	*(volatile uint32_t*)(RTC_UNIT_BASE + RTC_OFST_CURTIME) = val;
	
	return KERN_STATUS_OK;
}

kstatus_t drvRtcSetAlarm(uint32_t at)
{
	*(volatile uint32_t*)(RTC_UNIT_BASE + RTC_OFST_ALARM) = at;

	return KERN_STATUS_OK;
}
