.syntax unified
.globl rp2040rtInit

rp2040rtInit:
	push	{r4-r7, lr}
	movs	r1, #0
	
#ifndef SUPPORT_OLD_BOOTROMS
	ldrb    r0, [r1, #0x13]
	cmp		r0, #2
1:								//infinite loop on ROM too old (older than v2)
	blt		1b
#endif

	ldrh	r7, [r1, #0x14]		//function table
	ldrh	r6, [r1, #0x18]		//table lookup
	ldr		r5, =rttab_funcreq_start
	ldr		r4, =rttab_funcptrs_start
	bl		rp2040rtTableLookup
	
	ldrh	r7, [r1, #0x16]		//data table
	ldr		r5, =rttab_datareq_start
	ldr		r4, =rttab_dataptrs_start
	bl		rp2040rtTableLookup
	
9:
	pop		{r4-r7, pc}

rp2040rtTableLookup:	//(r4 = dstStart, r5 = req_start, r6 = lookupfunc, r7 = tab)
	push	{lr}
3:
	ldrh	r1, [r5]
	cmp		r1, #0
	beq		9f
	mov		r0, r7
	blx		r6
	cmp		r0, #0
4:								//infinite loop on func not found
	beq		4b
	stmia   r4!, {r0}
	adds	r5, #2
	b		3b
9:
	pop		{pc}


.section .rodata.rttab_data
	.balign 2
	rttab_datareq_start:

.section .rodata.rttab_func
	.balign 2
	rttab_funcreq_start:

.section .bss.rttab_data
	.balign 4
	rttab_dataptrs_start:

.section .bss.rttab_func
	.balign 4
	rttab_funcptrs_start:

.macro addrtreq name, rpname, type
	.section .rodata.rttab_\type
	.hword \rpname
	.section .bss.rttab_\type
	.globl ___p\name
	___p\name:
	.word 0
.endm

.macro addrtfunc name, rpname		//3 params max
	addrtreq \name, \rpname, func
	.section .text.rttab_\name
	.globl \name
	\name:
		ldr r3, =___p\name
		ldr	r3, [r3]
		bx  r3
.endm

.macro fpfunc1 ofst, type, name, haveName2, name2

	.section .text.\name\type
	.globl \name
.if \haveName2
	.globl \name2
	\name2:
.endif
	\name:
		push	{r0}
		ldr		r0, =___pfptab\type
		ldr		r0, [r0]
		ldr		r0, [r0, #\ofst]
		mov		r12, r0
		pop		{r0}
		bx		r12

.endm

.macro fpfunc ofst, prename1, postname1, haveName2, prename2, postname2
	fpfunc1	\ofst, f, \prename1\()s\postname1, \haveName2, \prename2\()f\postname2
	#ifndef SUPPORT_OLD_BOOTROMS
		fpfunc1	\ofst, d, \prename1\()d\postname1, \haveName2, \prename2\()d\postname2
	#endif
.endm

.macro mathfunc prename, ofst
	fpfunc1 \ofst, f, \prename\()f, 0
	#ifndef SUPPORT_OLD_BOOTROMS
		fpfunc1 \ofst, d, \prename, 0
	#endif
.endm

addrtfunc __clzsi2,			'L' + 256 * '3'
addrtfunc __ctzsi2,			'T' + 256 * '3'
addrtfunc __popcountsi2,	'P' + 256 * '3'
addrtfunc memset,			'M' + 256 * 'S'
addrtfunc memcpy,			'M' + 256 * 'C'

addrtreq fptabf,'S' + 256 * 'F',data

#ifndef SUPPORT_OLD_BOOTROMS
	
	addrtreq fptabd,'S' + 256 * 'D',data

#endif

mathfunc sqrt, 0x18
mathfunc cos, 0x3c
mathfunc sin, 0x40
mathfunc tan, 0x44
mathfunc exp, 0x4c
mathfunc log, 0x50
mathfunc atan2, 0x58

fpfunc 0x00, __add, f3, 1, __aeabi_, add
fpfunc 0x04, __sub, f3, 1, __aeabi_, sub
fpfunc 0x08, __mul, f3, 1, __aeabi_, mul
fpfunc 0x0c, __div, f3, 1, __aeabi_, div
fpfunc 0x1c, __fix, fsi, 1, __aeabi_, 2iz
fpfunc 0x24, __fixuns, fsi, 1, __aeabi_, 2uiz
fpfunc 0x2c, __floatsi, f, 1, __aeabi_i2
fpfunc 0x34, __floatunsi, f, 1, __aeabi_ui2

#ifndef SUPPORT_OLD_BOOTROMS
	fpfunc 0x54, __cmp, f2, 0
	fpfunc 0x5c, __floatti, f, 1, __aeabi_l2,
	fpfunc 0x64, __floatunti, f, 1, __aeabi_ul2,
	fpfunc 0x6c, __fix, fti, 1, __aeabi_, 2lz
	fpfunc 0x74, __fixuns, fti, 1, __aeabi_, 2ulz
#endif

fpfunc1 0x7c, f, __extendsfdf2, 1, __aeabi_f2d

#ifndef SUPPORT_OLD_BOOTROMS
	fpfunc1 0x7c, d, __truncdfsf2, 1, __aeabi_d2f
#endif

.section .text.isnanf
.globl isnanf
isnanf:
	lsls	r2, r0, #1
	movs	r0, #0
	asrs	r3, r2, #24	//sign extended exponent
	adds	r3, #1
	bne		1f			//not nan
	lsls	r2, r2, #8
	beq		1f
	movs	r0, #1
1:
	bx		lr

.section .text.isnan
.globl isnan
isnan:
	lsls	r2, r0, #1
	movs	r0, #0
	asrs	r3, r2, #20	//sign extended exponent
	adds	r3, #1
	bne		1f			//not nan
	lsls	r2, r2, #11
	bne		2f
	movs	r1, r1
	beq		1f
2:
	movs	r0, #1
1:
	bx		lr

#ifndef SUPPORT_OLD_BOOTROMS
	
	.macro fcmp armCC
		
		.section .text.__aeabi_fcmp\armCC
		.globl __aeabi_fcmp\armCC
		__aeabi_fcmp\armCC:
			push	{r0-r1, lr}
			bl		isnanf
			cmp		r0, #1
			bne		1f
			ldr		r0, [sp, #4]
			bl		isnanf
			cmp		r0, #1
			bne		1f
			pop		{r0-r1}
			bl		__cmpsf2
			cmp		r0, #0
			b\armCC	2f
			movs	r0, #0
			pop		{pc}
		2:
			movs	r0, #1
			pop		{pc}
		1:
			movs	r0, #0
			pop		{r1-r2, pc}
		
		.globl __aeabi_dcmp\armCC
		__aeabi_dcmp\armCC:
			push	{r0-r3, lr}
			bl		isnan
			cmp		r0, #1
			bne		1f
			ldr		r0, [sp, #8]
			ldr		r1, [sp, #12]
			bl		isnan
			cmp		r0, #1
			bne		1f
			pop		{r0-r3}
			bl		__cmpdf2
			cmp		r0, #0
			b\armCC	2f
			movs	r0, #0
			pop		{pc}
		2:
			movs	r0, #1
			pop		{pc}
		1:
			movs	r0, #0
			add		sp, #16
			pop		{pc}
		
	.endm
	
	
	fcmp le
	fcmp lt
	fcmp ge
	fcmp gt
	fcmp eq
#endif


.section .rodata.rttab_func
	.hword 0		//terminator

.section .rodata.rttab_data
	.hword 0		//terminator






//safer routines to not worry about irqs. If an irq interrupted a calculation, it would be long finished so we can preserve results
//we do not rely on input regs to stay and thus need not restore them
.section .text.udiv
.globl __udivsi3 
.globl __aeabi_uidivmod
.globl __aeabi_uidiv
__udivsi3:
__aeabi_uidivmod:
__aeabi_uidiv:
	mov		r12, r4
	movs	r4, #0xd0
	lsls	r4, #24
	ldr		r2, [r4, #0x70]
	ldr		r3, [r4, #0x74]
	str		r0, [r4, #0x60]
	str		r1, [r4, #0x64]
	adds	r4, #0x70
	movs	r0, r4
	nop
	nop
	nop
	nop
	nop
	nop
	ldm		r0, {r0, r1}	//get results
	stmia	r4!, {r2, r3}	//restore old ones
	mov		r4, r12
	bx		lr

.section .text.sdiv
.globl __divsi3 
.globl __aeabi_idivmod
.globl __aeabi_idiv
__divsi3:
__aeabi_idivmod:
__aeabi_idiv:
	mov		r12, r4
	movs	r4, #0xd0
	lsls	r4, #24
	ldr		r2, [r4, #0x70]
	ldr		r3, [r4, #0x74]
	str		r0, [r4, #0x68]
	str		r1, [r4, #0x6c]
	adds	r4, #0x70
	movs	r0, r4
	nop
	nop
	nop
	nop
	nop
	nop
	ldm		r0, {r0, r1}	//get results
	stmia	r4!, {r2, r3}	//restore old ones
	mov		r4, r12
	bx		lr



