#ifndef _AUDIOHW_H_
#define _AUDIOHW_H_

#include <stdbool.h>
#include <stdint.h>
#include <audio.h>
#include "dal.h"

//each "sample" is {L+R} stereo pair

//likely to be called in interrupt context! if "start" is true, return pointer to
// buffer in our intermediate format, containing just the right number of samples
// (based on numSamplesPerBufP and nativeStereoP). If "start" is false, we"re done
// with the buffer and it is safe to reuse
typedef const int32_t* (*AudioOutHwReadyForMoreSamplesF)(bool start);

bool audioOutHwInit(AudioOutHwReadyForMoreSamplesF readyForSamplesF, uint32_t *numSamplesPerBufP, enum AudioSampleRate* nativeRateP, bool *nativeStereoP);
void audioOutHwSetState(bool on);

//mic is always mono
typedef void (*AudioInHwSamplesReadyF)(const uint16_t *samples, uint_fast16_t midpoint);	//samples always come out as int16_t, number is the value returned from audioInHwInit()
bool audioInHwInit(AudioInHwSamplesReadyF acceptSamplesF, uint32_t *numSamplesPerBufP);		//numSamplesPerBufP shall be a multiple of 8
bool audioInHwSetState(bool on, enum AudioSampleRate rate);

//misc ADC stuff that is likely cohabitating with audio-in

int32_t adcGetValue(enum AdcValueIdx which);



#endif

