#include "platform.h"
#include "printf.h"
#include "rtc.h"


static DrvRtcCbk mAlmCbk = NULL, mHzCbk = NULL;


#define PPC_TO_PALMOS_CLOCK_ADJ			1994544000


static void rtcPrvIrqHz(void *unused)
{
	struct PxaRTC *rtc = (struct PxaRTC*)unused;
	
	rtc->RTSR = (rtc->RTSR & 0x0c) | 2;
	
	if (mHzCbk)
		mHzCbk();
}

static void rtcPrvIrqAlarm(void *unused)
{
	struct PxaRTC *rtc = (struct PxaRTC*)unused;
	
	rtc->RTSR = (rtc->RTSR & 0x0c) | 1;
	
	if (mAlmCbk)
		mAlmCbk();
}

kstatus_t drvRtcInit(DrvRtcCbk hzCbk, DrvRtcCbk almCbk)
{
	struct PxaRTC *rtc = platPeriphP2V(PXA_BASE_RTC);
	uint32_t time;
	kstatus_t sta;
	
	mAlmCbk = almCbk;
	mHzCbk = hzCbk;
	
	rtc->RTTR = 0x7FFF;
	rtc->RTAR = 0;
	
	rtc->RTSR = 0x0b;
	
	HALInterruptSetHandler(REPALM_IRQ_NO_MANGLE(XSCALE_IRQ_NO_RTC_HZ), rtcPrvIrqHz, rtc);
	HALInterruptSetState(REPALM_IRQ_NO_MANGLE(XSCALE_IRQ_NO_RTC_HZ), true);
	HALInterruptSetHandler(REPALM_IRQ_NO_MANGLE(XSCALE_IRQ_NO_RTC_ALM), rtcPrvIrqAlarm, rtc);
	HALInterruptSetState(REPALM_IRQ_NO_MANGLE(XSCALE_IRQ_NO_RTC_ALM), true);
	
	return KERN_STATUS_OK;
}

kstatus_t drvRtcPreSleep(void)
{
	//todo
	
	return KERN_STATUS_OK;
}

kstatus_t drvRtcPostWake(void)
{
	//todo
	
	return KERN_STATUS_OK;
}

kstatus_t drvRtcGet(uint32_t *valP)
{
	struct PxaRTC *rtc = platPeriphP2V(PXA_BASE_RTC);
	
	*valP = rtc->RCNR + PPC_TO_PALMOS_CLOCK_ADJ;
	
	return KERN_STATUS_OK;
}

kstatus_t drvRtcSet(uint32_t val)
{
	struct PxaRTC *rtc = platPeriphP2V(PXA_BASE_RTC);
	
	rtc->RCNR = val - PPC_TO_PALMOS_CLOCK_ADJ;
	
	return KERN_STATUS_OK;
}

kstatus_t drvRtcSetAlarm(uint32_t at)
{
	struct PxaRTC *rtc = platPeriphP2V(PXA_BASE_RTC);
	
	rtc->RTSR &= 8;
	rtc->RTAR = at - PPC_TO_PALMOS_CLOCK_ADJ;
	if (at)
		rtc->RTSR = (rtc->RTSR & 8) | 4;
	
	return KERN_STATUS_OK;
}
