#include "dockAndBattery.h"
#include "msioComms.h"
#include "dal.h"



void dockHwrInit(void)
{
	const struct MsioPktBattInfo *bi = msioCommsGetBatteryInfo();
	SysBatteryKind kind = bi->kind;
	uint32_t state = 0;
	
	if (bi->isPluggedIn) {
		if (kind != sysBatteryKindAlkaline)		//we do not charge alkaline batteries
			state |= HAL_DOCK_STATUS_CHARGING;
		
		state |= HAL_DOCK_STATUS_EXTRNAL_PWR;
	}
	
	halDockStatusChanged(state);
}

void batteryInfo(SysBatteryKind *kindP, bool *haveMainsP, uint8_t *percentP)
{
	const struct MsioPktBattInfo *bi = msioCommsGetBatteryInfo();

	if (kindP)
		*kindP = (SysBatteryKind)bi->kind;
	
	if (haveMainsP)
		*haveMainsP = !!bi->isPluggedIn;
	
	if (percentP)
		*percentP = bi->percent;
}

