#ifndef _AC97_H_
#define _AC97_H_

#include <stdbool.h>
#include <stdint.h>


enum AC97deviceSelection {
	AC97primaryAudioCodec,
	AC97secondaryAudioCodec,
	AC97primaryModem,
	AC97secondaryModem,
};


void ac97init(void);
bool ac97regRead(enum AC97deviceSelection dev, uint8_t reg, uint16_t *valP);
bool ac97regWrite(enum AC97deviceSelection dev, uint8_t reg, uint_fast16_t val);
void ac97linkPowerDown(void);	//only after powering codecs down via write to reg 0x26 with bit 0x1000
bool ac97LinkReset(bool cold);
bool ac97IsCodecReady(enum AC97deviceSelection dev);

#endif

