#ifndef _AC97_CODEC_H_
#define _AC97_CODEC_H_


#include <stdbool.h>
#include <stdio.h>
#include "ac97.h"


//standard regs
#define AC97_REG_RESET					0x00
#define AC97_REG_MASTER_VOLUME			0x02
#define AC97_REG_AUX_OUT_VOLUME			0x04
#define AC97_REG_MONO_VOLUME			0x06
#define AC97_REG_MASTER_TONE			0x08
#define AC97_REG_PC_BEEP_VOLUME			0x0a
#define AC97_REG_PHONE_VOLUME			0x0c
#define AC97_REG_MIC_VOLUME				0x0e
#define AC97_REG_LINE_IN_VOLUME			0x10
#define AC97_REG_CD_VOLUME				0x12
#define AC97_REG_VIDEO_VOLUME			0x14
#define AC97_REG_AUX_IN_VOLUME			0x16
#define AC97_REG_PCM_OUT_VOLUME			0x18
#define AC97_REG_RECORD_SELECT			0x1a
#define AC97_REG_RECORD_GAIN			0x1c
#define AC97_REG_RECORD_GAIN_MIC		0x1e
#define AC97_REG_GENERAL_PURPOSE		0x20
#define AC97_REG_3D_CONTROL				0x22
#define AC97_REG_AUDIO_INT_AND_PAGING	0x24
#define AC97_REG_POWERDOWN				0x26
#define AC97_REG_VENDOR_ID_1			0x7c
#define AC97_REG_VENDOR_ID_2			0x7e

#define AC97_VOLREG_MUTE				0x8000
#define AC97_VOLREG_RIGHT_MASK			0x003f
#define AC97_VOLREG_RIGHT_SHIFT			0
#define AC97_VOLREG_LEFT_MASK			0x3f00
#define AC97_VOLREG_LEFT_SHIFT			8

#define AC97_PWRREG_STA_ADC_READY		0x0001
#define AC97_PWRREG_STA_DAC_READY		0x0002
#define AC97_PWRREG_STA_ANL_READY		0x0004	//analog mixers
#define AC97_PWRREG_STA_REF_READY		0x0008	//vref ready
#define AC97_PWRREG_PWDN_INPUT_ADCS		0x0100
#define AC97_PWRREG_PWDN_OUTPUT_DACS	0x0200
#define AC97_PWRREG_PWDN_ANL_MIX		0x0400	//keeps Vref ON
#define AC97_PWRREG_PWDN_VREF			0x0800	//Vref off
#define AC97_PWRREG_PWDN_AC97			0x1000	//power down the link
#define AC97_PWRREG_PWDN_INTERNAL_CLK	0x2000
#define AC97_PWRREG_PWDN_AUX_OUT		0x4000
#define AC97_PWRREG_PWDN_EXT_AMP		0x8000

enum AC97codecVolumeKnob {		//in spec order and relied upon for that!
	AC97volMaster = 1,
	AC97volAuxOut,
	AC97volMono,
	
	AC97volPhone = 6,
	AC97volMic,
	AC97volLineIn,
	AC97volCD,
	AC97volVideo,
	AC97volAuxIn,
	AC97volPcmOut
};


bool ac97codecInit(enum AC97deviceSelection where, uint16_t *vid1P, uint16_t *vid2P);
bool ac97setVolume(enum AC97codecVolumeKnob which, uint8_t volL, uint8_t volR);	//volume is out of 31 with 0 being max and 31 being min. each point is 1.5dB quieter
bool ac97getVolume(enum AC97codecVolumeKnob which, uint8_t *volLP, uint8_t *volRP);
bool ac97setMute(enum AC97codecVolumeKnob which, bool mute);
bool ac97getMute(enum AC97codecVolumeKnob which, bool *muteP);
bool ac97setPwrReg(uint16_t val);
bool ac97getPwrReg(uint16_t *valP);

bool ac97codecRegRead(uint8_t reg, uint16_t *regValP);
bool ac97codecRegWrite(uint8_t reg, uint16_t regVal);







#endif
