#ifndef _PLAT_XSCALE_H_
#define _PLAT_XSCALE_H_

#include <stdint.h>


struct PxaRTC {
	volatile uint32_t RCNR, RTAR, RTSR, RTTR;
};
#define PXA_BASE_RTC	0x40900000

struct PxaDMA {
	volatile uint32_t DCSR[16];
	uint32_t rfu1[44];
	volatile uint32_t DINT;
	uint32_t rfu2[3];
	volatile uint32_t DRCMR[40];
	uint32_t rfu3[24];
	struct PxaDMAch {
		volatile uint32_t DDADR, DSADR, DTADR, DCMD;
	} ch[16];
};
#define PXA_BASE_DMA		0x40000000

#define XSCALE_DMA_CH_DREQ0			0
#define XSCALE_DMA_CH_DREQ1			1
#define XSCALE_DMA_CH_I2S_RX		2
#define XSCALE_DMA_CH_I2S_TX		3
#define XSCALE_DMA_CH_BTUART_RX		4
#define XSCALE_DMA_CH_BTUART_TX		5
#define XSCALE_DMA_CH_FFUART_RX		6
#define XSCALE_DMA_CH_FFUART_TX		7
#define XSCALE_DMA_CH_AC97_MIC_RX	8
#define XSCALE_DMA_CH_AC97_MDM_RX	9
#define XSCALE_DMA_CH_AC97_MDM_TX	10
#define XSCALE_DMA_CH_AC97_AUD_RX	11
#define XSCALE_DMA_CH_AC97_AUD_TX	12
#define XSCALE_DMA_CH_SSP_RX		13
#define XSCALE_DMA_CH_SSP_TX		14
#define XSCALE_DMA_CH_FICP_RX		17
#define XSCALE_DMA_CH_FIXP_TX		18
#define XSCALE_DMA_CH_STUART_RX		19
#define XSCALE_DMA_CH_STUART_TX		20
#define XSCALE_DMA_CH_MMC_RX		21
#define XSCALE_DMA_CH_MMC_TX		22
#define XSCALE_DMA_CH_USB_EP1		25
#define XSCALE_DMA_CH_USB_EP2		26
#define XSCALE_DMA_CH_USB_EP3		27
#define XSCALE_DMA_CH_USB_EP4		28
#define XSCALE_DMA_CH_USB_EP6		30
#define XSCALE_DMA_CH_USB_EP7		31
#define XSCALE_DMA_CH_USB_EP8		32
#define XSCALE_DMA_CH_USB_EP9		33
#define XSCALE_DMA_CH_USB_EP11		35
#define XSCALE_DMA_CH_USB_EP12		36
#define XSCALE_DMA_CH_USB_EP13		37
#define XSCALE_DMA_CH_USB_EP14		38

struct PxaAC97 {
	volatile uint32_t POCR, PICR, MCCR, GCR, POSR, PISR, MCSR, GSR, CAR;
	uint32_t rfu1[7];
	volatile uint32_t PCDR;
	uint32_t rfu2[7];
	volatile uint32_t MCDR;
	uint32_t rfu3[39];
	volatile uint32_t MOCR;
	uint32_t rfu4;
	volatile uint32_t MICR;
	uint32_t rfu5;
	volatile uint32_t MOSR;
	uint32_t rfu6;
	volatile uint32_t MISR;
	uint32_t rfu7[9];
	volatile uint32_t MODR;
	uint32_t rfu8[47];
	volatile uint32_t primaryAudioRegs[64];
	volatile uint32_t secondaryAudioRegs[64];
	volatile uint32_t primaryModemRegs[64];
	volatile uint32_t secondaryModemRegs[64];
};
#define PXA_BASE_AC97		0x40500000

struct PxaMemCtrl {
	volatile uint32_t MDCNFG, MDREFR, MSC[3], MECR;
	uint32_t rfu1;
	volatile uint32_t SXCNFG;
	uint32_t rfu2;
	volatile uint32_t SXMRS, MCMEM[2], MCATT[2], MCIO[2], MDMRS, BOOT_DEF;
	uint32_t rfu3[4];
	volatile uint32_t MDMRSLP;
	uint32_t rfu4[2];
	volatile uint32_t SA1111CR;
};
#define PXA_BASE_MEM_CTRL	0x48000000

struct PxaPwm {
	volatile uint32_t CTRL, DUTY, PERVAL;
};
#define PXA_BASE_PWM0		0x40b00000
#define PXA_BASE_PWM1		0x40c00000

struct PxaLcd {
	volatile uint32_t LCCR[4];
	uint32_t rfu1[4];
	volatile uint32_t FBR[2];
	uint32_t rfu2[4];
	volatile uint32_t LCSR, LIIDR, TRGBR, TCR;
	uint32_t rfu3[110];
	struct {
		volatile uint32_t FDADR, FSADR, FIDR, LDCMD;
	} dma[2];
};
#define PXA_BASE_LCD_CTRL	0x44000000

struct PxaUart {
	union {
		volatile uint32_t RBR;	//RO
		volatile uint32_t THR;	//WO
		volatile uint32_t DLL;	//when DLAB is on
	};
	union {
		volatile uint32_t IER;
		volatile uint32_t DLH;	//when DLAB is on
	};
	union {
		volatile uint32_t IIR;	//RO
		volatile uint32_t FCR;	//WO;
	};
	volatile uint32_t LCR, MCR, LSR, MSR, SPR, ISR;
	
	//HWUART only:
	volatile uint32_t FOR, ABR, ACR;
};
#define PXA_BASE_FFUART		0x40100000
#define PXA_BASE_BTUART		0x40200000
#define PXA_BASE_STUART		0x40700000
#define PXA_BASE_HWUART		0x41600000

struct PxaOsTimer {
	volatile uint32_t OSMR[4];
	volatile uint32_t OSCR, OSSR, OWER, OIER;
};
#define PXA_BASE_OSTIMER	0x40a00000

struct PxaClockMgr {
	volatile uint32_t CCCR, CKEN, OSCC;
};
#define PXA_BASE_CLOCK_MGR	0x41300000

#define XSCALE_CLOCK_ID_PWM0	0
#define XSCALE_CLOCK_ID_PWM1	1
#define XSCALE_CLOCK_ID_AC97	2
#define XSCALE_CLOCK_ID_SSP		3
#define XSCALE_CLOCK_ID_HWUART	4
#define XSCALE_CLOCK_ID_STUART	5
#define XSCALE_CLOCK_ID_FFUART	6
#define XSCALE_CLOCK_ID_BTUART	7
#define XSCALE_CLOCK_ID_I2S		8
#define XSCALE_CLOCK_ID_NSSP	9
#define XSCALE_CLOCK_ID_ASSP	10
#define XSCALE_CLOCK_ID_USB		11
#define XSCALE_CLOCK_ID_MMC		12
#define XSCALE_CLOCK_ID_FICP	13
#define XSCALE_CLOCK_ID_I2C		14
#define XSCALE_CLOCK_ID_LCD		16

struct PxaPwrMgr {
	volatile uint32_t PMCR, PSSR, PSPR, PWER, PRER, PFER, PEDR, PCFR, PGSR[3];
	uint32_t rfu;
	volatile uint32_t RCSR, PMFWR;
};
#define PXA_BASE_PWR_MGR	0x40f00000


struct PxaGpio {
	volatile uint32_t GPLR[3];
	volatile uint32_t GPDR[3];
	volatile uint32_t GPSR[3];
	volatile uint32_t GPCR[3];
	volatile uint32_t GRER[3];
	volatile uint32_t GFER[3];
	volatile uint32_t GEDR[3];
	volatile uint32_t GAFR[6];
};
#define PXA_BASE_GPIO		0x40e00000



struct PxaIc {
	volatile uint32_t ICIP, ICMR, ICLR, ICFP, ICPR, ICCR;
};
#define PXA_BASE_IC		0x40d00000

#define XSCALE_IRQ_NO_HWUART	7
#define XSCALE_IRQ_NO_GPIO0		8
#define XSCALE_IRQ_NO_GPIO1		9
#define XSCALE_IRQ_NO_GPIO_2_89	10
#define XSCALE_IRQ_NO_USB		11
#define XSCALE_IRQ_NO_PMU		12
#define XSCALE_IRQ_NO_I2S		13
#define XSCALE_IRQ_NO_AC97		14
#define XSCALE_IRQ_NO_ASSP		15
#define XSCALE_IRQ_NO_NSSP		16
#define XSCALE_IRQ_NO_LCD		17
#define XSCALE_IRQ_NO_I2C		18
#define XSCALE_IRQ_NO_ICP		19
#define XSCALE_IRQ_NO_STUART	20
#define XSCALE_IRQ_NO_BTUART	21
#define XSCALE_IRQ_NO_FFUART	22
#define XSCALE_IRQ_NO_MMC		23
#define XSCALE_IRQ_NO_SSP		24
#define XSCALE_IRQ_NO_DMA		25
#define XSCALE_IRQ_NO_TMR0		26
#define XSCALE_IRQ_NO_TMR1		27
#define XSCALE_IRQ_NO_TMR2		28
#define XSCALE_IRQ_NO_TMR3		29
#define XSCALE_IRQ_NO_RTC_HZ	30
#define XSCALE_IRQ_NO_RTC_ALM	31
#define XSCALE_IRQ_NO_GPIO(x)	(32 + (x) - 2)




#endif

