#include <stdint.h>
#include "irqsCortex.h"
#include "timers.h"
#include "irqs.h"
#include "cpu.h"

void __attribute__((used)) TIM2_IRQHandler(void)
{
	TIM2->SR = 0;
	timerExternalIrq();
	asm volatile("DSB 0x0f");		//c-m4f erratum
}

void hwTimerInit(void)
{
	TIM2->CR1 = 0;
	TIM2->PSC = 0;
	TIM2->DIER = TIM_DIER_UIE;
}

uint32_t hwTimerIntOff(void)
{
	uint32_t ret = NVIC_IsEnabledIRQ(TIM2_IRQn);		//allows re-entrancy
	NVIC_DisableIRQ(TIM2_IRQn);
	
	return ret;
}

uint32_t hwTimerIntOn(void)
{
	uint32_t ret = NVIC_IsEnabledIRQ(TIM2_IRQn);		//allows re-entrancy
	NVIC_EnableIRQ(TIM2_IRQn);
	
	return ret;
}

void hwTimerIntRestore(uint32_t state)
{
	if (state)
		NVIC_EnableIRQ(TIM2_IRQn);
	else
		NVIC_DisableIRQ(TIM2_IRQn);
}

void hwTimerSet(uint32_t ticksFromNow)
{
	if (!ticksFromNow)
		TIM2->CR1 = 0;
	else {
		TIM2->SR = 0;
		TIM2->CNT = ticksFromNow;
		NVIC_ClearPendingIRQ(TIM2_IRQn);
		TIM2->CR1 = TIM_CR1_DIR | TIM_CR1_OPM | TIM_CR1_URS | TIM_CR1_CEN;
	}
}